<x-admin-layout>
    <div class="container mx-auto px-4 py-8">
        <div class="max-w-2xl mx-auto">
            <div class="bg-white rounded-lg shadow-lg p-6">
                <h2 class="text-2xl font-bold mb-6">Add New Product</h2>

                @if ($errors->any())
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{ route('admin.products.store') }}" method="POST" enctype="multipart/form-data" class="space-y-6" id="productForm">
                    @csrf
                    <input type="hidden" name="dynamic_fields" id="dynamic_fields" value="">

                    <div class="mb-4">
                        <label for="name" class="block text-gray-700 text-sm font-bold mb-2">Name</label>
                        <input type="text" name="name" id="name" value="{{ old('name') }}"
                            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline @error('name') border-red-500 @enderror">
                        @error('name')
                            <p class="text-red-500 text-xs italic">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-4">
                        <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                        <textarea name="description" id="description" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" required>{{ old('description') }}</textarea>
                    </div>

                    <div class="bg-white shadow sm:rounded-lg">
                        <div class="px-4 py-5 sm:p-6">
                            <h3 class="text-lg font-medium leading-6 text-gray-900">Dynamic Fields</h3>
                            <div class="mt-2 max-w-xl text-sm text-gray-500">
                                <p>Add custom fields for the product specifications. You can set additional prices for options.</p>
                            </div>
                            <div class="mt-5">
                                <button type="button" onclick="addDynamicField()" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                    Add Field
                                </button>
                            </div>
                            <div id="dynamicFields" class="mt-4 space-y-4">
                                <!-- Dynamic fields will be added here -->
                            </div>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="price" class="block text-gray-700 text-sm font-bold mb-2">Price</label>
                        <input type="number" name="price" id="price" step="0.01" value="{{ old('price') }}"
                            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline @error('price') border-red-500 @enderror">
                        @error('price')
                            <p class="text-red-500 text-xs italic">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-4">
                        <label for="discount_percentage" class="block text-gray-700 text-sm font-bold mb-2">Discount Percentage</label>
                        <input type="number" name="discount_percentage" id="discount_percentage" min="0" max="100" value="{{ old('discount_percentage') }}"
                            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline @error('discount_percentage') border-red-500 @enderror">
                        @error('discount_percentage')
                            <p class="text-red-500 text-xs italic">{{ $message }}</p>
                        @enderror
                        <p class="text-gray-600 text-xs mt-1">Enter a value between 0 and 100</p>
                    </div>

                    <div class="mb-4">
                        <label for="stock" class="block text-gray-700 text-sm font-bold mb-2">Stock</label>
                        <input type="number" name="stock" id="stock" value="{{ old('stock', 0) }}"
                            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline @error('stock') border-red-500 @enderror">
                        @error('stock')
                            <p class="text-red-500 text-xs italic">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-4">
                        <label for="category_id" class="block text-gray-700 text-sm font-bold mb-2">Category</label>
                        <select name="category_id" id="category_id"
                            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline @error('category_id') border-red-500 @enderror">
                            <option value="">Select a category</option>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                    {{ $category->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('category_id')
                            <p class="text-red-500 text-xs italic">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-4">
                        <label for="images" class="block text-gray-700 text-sm font-bold mb-2">Product Images</label>
                        <input type="file" name="images[]" id="images" multiple accept="image/*"
                            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline @error('images') border-red-500 @enderror">
                        @error('images')
                            <p class="text-red-500 text-xs italic">{{ $message }}</p>
                        @enderror
                        <p class="text-gray-600 text-xs mt-1">You can select multiple images. Maximum file size: 2MB per image.</p>
                    </div>

                    <div class="mb-4">
                        <label class="inline-flex items-center">
                            <input type="checkbox" name="is_featured" value="1" {{ old('is_featured') ? 'checked' : '' }}
                                class="form-checkbox h-5 w-5 text-blue-600">
                            <span class="ml-2 text-gray-700">Featured Product</span>
                        </label>
                    </div>

                    <div class="mb-4">
                        <label for="shipping_cost" class="block text-gray-700 text-sm font-bold mb-2">Shipping Cost</label>
                        <input type="number" name="shipping_cost" id="shipping_cost" step="0.01" value="{{ old('shipping_cost') }}"
                            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline @error('shipping_cost') border-red-500 @enderror">
                        @error('shipping_cost')
                            <p class="text-red-500 text-xs italic">{{ $message }}</p>
                        @enderror
                        <p class="text-gray-600 text-xs mt-1">If left empty, shipping will be Free.</p>
                    </div>

                    <!-- SEO Section -->
                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-6 mb-6">
                        <h3 class="text-lg font-semibold text-blue-900 mb-4 flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            SEO Settings
                        </h3>

                        <!-- Basic SEO -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                            <div>
                                <label for="meta_title" class="block text-sm font-medium text-gray-700">Meta Title</label>
                                <input type="text" name="meta_title" id="meta_title" value="{{ old('meta_title') }}" maxlength="60"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                    placeholder="Auto-generated from product name">
                                <p class="text-xs text-gray-500 mt-1">Max 60 characters</p>
                            </div>

                            <div>
                                <label for="meta_description" class="block text-sm font-medium text-gray-700">Meta Description</label>
                                <textarea name="meta_description" id="meta_description" rows="2" maxlength="160"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                    placeholder="Auto-generated from description">{{ old('meta_description') }}</textarea>
                                <p class="text-xs text-gray-500 mt-1">Max 160 characters</p>
                            </div>
                        </div>

                        <div class="mb-6">
                            <label for="meta_keywords" class="block text-sm font-medium text-gray-700">Meta Keywords</label>
                            <input type="text" name="meta_keywords" id="meta_keywords" value="{{ old('meta_keywords') }}"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                placeholder="Auto-generated from product name, brand, category">
                            <p class="text-xs text-gray-500 mt-1">Comma separated keywords</p>
                        </div>

                        <!-- Product Identifiers -->
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
                            <div>
                                <label for="brand" class="block text-sm font-medium text-gray-700">Brand</label>
                                <input type="text" name="brand" id="brand" value="{{ old('brand') }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                            </div>

                            <div>
                                <label for="model" class="block text-sm font-medium text-gray-700">Model</label>
                                <input type="text" name="model" id="model" value="{{ old('model') }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                            </div>

                            <div>
                                <label for="sku" class="block text-sm font-medium text-gray-700">SKU</label>
                                <input type="text" name="sku" id="sku" value="{{ old('sku') }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                            </div>

                            <div>
                                <label for="gtin" class="block text-sm font-medium text-gray-700">GTIN</label>
                                <input type="text" name="gtin" id="gtin" value="{{ old('gtin') }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                            </div>
                        </div>

                        <!-- Product Status -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                            <div>
                                <label for="availability" class="block text-sm font-medium text-gray-700">Availability</label>
                                <select name="availability" id="availability"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                                    <option value="in_stock" {{ old('availability') == 'in_stock' ? 'selected' : '' }}>In Stock</option>
                                    <option value="out_of_stock" {{ old('availability') == 'out_of_stock' ? 'selected' : '' }}>Out of Stock</option>
                                    <option value="preorder" {{ old('availability') == 'preorder' ? 'selected' : '' }}>Pre-order</option>
                                </select>
                            </div>

                            <div>
                                <label for="condition" class="block text-sm font-medium text-gray-700">Condition</label>
                                <select name="condition" id="condition"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                                    <option value="new" {{ old('condition') == 'new' ? 'selected' : '' }}>New</option>
                                    <option value="used" {{ old('condition') == 'used' ? 'selected' : '' }}>Used</option>
                                    <option value="refurbished" {{ old('condition') == 'refurbished' ? 'selected' : '' }}>Refurbished</option>
                                </select>
                            </div>
                        </div>

                        <!-- SEO Settings -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                            <div>
                                <label for="seo_url" class="block text-sm font-medium text-gray-700">SEO URL</label>
                                <input type="text" name="seo_url" id="seo_url" value="{{ old('seo_url') }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                    placeholder="Auto-generated from product name">
                            </div>

                            <div>
                                <label for="seo_priority" class="block text-sm font-medium text-gray-700">SEO Priority</label>
                                <select name="seo_priority" id="seo_priority"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                                    <option value="low" {{ old('seo_priority') == 'low' ? 'selected' : '' }}>Low</option>
                                    <option value="normal" {{ old('seo_priority') == 'normal' ? 'selected' : '' }} selected>Normal</option>
                                    <option value="high" {{ old('seo_priority') == 'high' ? 'selected' : '' }}>High</option>
                                </select>
                            </div>
                        </div>

                        <!-- SEO Options -->
                        <div class="flex items-center space-x-6">
                            <label class="inline-flex items-center">
                                <input type="checkbox" name="seo_indexable" value="1" {{ old('seo_indexable', true) ? 'checked' : '' }}
                                    class="form-checkbox h-4 w-4 text-blue-600">
                                <span class="ml-2 text-sm text-gray-700">Allow search engines to index</span>
                            </label>

                            <label class="inline-flex items-center">
                                <input type="checkbox" name="auto_generate_seo" value="1" {{ old('auto_generate_seo', true) ? 'checked' : '' }}
                                    class="form-checkbox h-4 w-4 text-blue-600">
                                <span class="ml-2 text-sm text-gray-700">Auto-generate missing SEO fields</span>
                            </label>
                        </div>
                    </div>

                    <div class="flex justify-end">
                        <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            Save Product
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
    function addDynamicField() {
        const fieldId = 'field_' + Date.now();
        const fieldHtml = `
            <div id="${fieldId}" class="dynamic-field bg-gray-50 p-4 rounded-lg">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Field Title</label>
                        <input type="text" class="field-title mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" required>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Field Type</label>
                        <select class="field-type mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" onchange="handleFieldTypeChange('${fieldId}')">
                            <option value="text">Text</option>
                            <option value="select">Select</option>
                            <option value="checkbox">Checkbox</option>
                            <option value="radio">Radio</option>
                        </select>
                    </div>
                </div>
                <div id="${fieldId}_options" class="mt-4 hidden">
                    <label class="block text-sm font-medium text-gray-700">Options</label>
                    <div id="${fieldId}_options_list" class="mt-2 space-y-2">
                        <div class="flex items-center space-x-2">
                            <input type="text" class="option-input block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="Option name">
                            <input type="number" class="option-price block w-24 rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="Price" step="0.01" min="0">
                            <button type="button" onclick="addOption('${fieldId}')" class="inline-flex items-center p-2 border border-transparent rounded-full shadow-sm text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z" clip-rule="evenodd" />
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="mt-4">
                    <button type="button" onclick="removeField('${fieldId}')" class="inline-flex items-center px-3 py-1.5 border border-transparent text-sm font-medium rounded-md text-red-700 bg-red-100 hover:bg-red-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                        Remove Field
                    </button>
                </div>
            </div>
        `;
        document.getElementById('dynamicFields').insertAdjacentHTML('beforeend', fieldHtml);
    }

    function handleFieldTypeChange(fieldId) {
        const field = document.getElementById(fieldId);
        const type = field.querySelector('.field-type').value;
        const optionsDiv = document.getElementById(fieldId + '_options');

        if (['select', 'checkbox', 'radio'].includes(type)) {
            optionsDiv.classList.remove('hidden');
        } else {
            optionsDiv.classList.add('hidden');
        }
    }

    function addOption(fieldId) {
        const optionsList = document.getElementById(fieldId + '_options_list');
        const optionHtml = `
            <div class="flex items-center space-x-2">
                <input type="text" class="option-input block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="Option name">
                <input type="number" class="option-price block w-24 rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="Price" step="0.01" min="0">
                <button type="button" onclick="removeOption(this)" class="inline-flex items-center p-2 border border-transparent rounded-full shadow-sm text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
                    </svg>
                </button>
            </div>
        `;
        optionsList.insertAdjacentHTML('beforeend', optionHtml);
    }

    function removeOption(button) {
        button.closest('div').remove();
    }

    function removeField(fieldId) {
        document.getElementById(fieldId).remove();
    }

    function collectDynamicFields() {
        const fields = [];
        const dynamicFieldsContainer = document.getElementById('dynamicFields');

        // Debug: Log the container
        console.log('Dynamic Fields Container:', dynamicFieldsContainer);

        dynamicFieldsContainer.querySelectorAll('.dynamic-field').forEach(field => {
            const title = field.querySelector('.field-title').value.trim();
            const type = field.querySelector('.field-type').value;

            // Debug: Log each field
            console.log('Processing field:', { title, type });

            if (title) {
                const fieldData = {
                    title: title,
                    type: type
                };

                // Handle options for select, checkbox, and radio
                if (['select', 'checkbox', 'radio'].includes(type)) {
                    const options = [];
                    const optionInputs = field.querySelectorAll('.option-input');
                    const optionPrices = field.querySelectorAll('.option-price');

                    optionInputs.forEach((optionInput, index) => {
                        const optionValue = optionInput.value.trim();
                        const optionPrice = optionPrices[index] ? parseFloat(optionPrices[index].value) || 0 : 0;

                        if (optionValue) {
                            options.push({
                                name: optionValue,
                                price: optionPrice
                            });
                        }
                    });

                    if (options.length > 0) {
                        fieldData.options = options;
                    }
                }

                // Debug: Log the field data
                console.log('Field data:', fieldData);

                fields.push(fieldData);
            }
        });

        // Debug: Log all collected fields
        console.log('All collected fields:', fields);

        const jsonData = JSON.stringify(fields);
        console.log('JSON data:', jsonData);

        document.getElementById('dynamic_fields').value = jsonData;
        return jsonData;
    }

    // Add form submit handler
    document.getElementById('productForm').addEventListener('submit', function(e) {
        e.preventDefault();

        // Debug: Log form data before collection
        console.log('Form data before collection:', new FormData(this));

        const dynamicFields = collectDynamicFields();

        // Debug: Log form data after collection
        console.log('Form data after collection:', new FormData(this));
        console.log('Dynamic fields value:', document.getElementById('dynamic_fields').value);

        // Submit the form
        this.submit();
    });

    // Auto-generate SEO fields
    function autoGenerateSeoFields() {
        const name = document.getElementById('name').value;
        const description = document.getElementById('description').value;
        const categorySelect = document.getElementById('category_id');
        const selectedCategory = categorySelect.options[categorySelect.selectedIndex]?.text || '';

        // Auto-generate meta title
        if (!document.getElementById('meta_title').value && name) {
            document.getElementById('meta_title').value = name + ' - ' + '{{ config("app.name") }}';
        }

        // Auto-generate meta description
        if (!document.getElementById('meta_description').value && description) {
            const cleanDescription = description.replace(/<[^>]*>/g, '').trim();
            document.getElementById('meta_description').value = cleanDescription.substring(0, 160);
        }

        // Auto-generate meta keywords
        if (!document.getElementById('meta_keywords').value && name) {
            const keywords = [name];
            if (selectedCategory) keywords.push(selectedCategory);
            if (document.getElementById('brand').value) keywords.push(document.getElementById('brand').value);
            document.getElementById('meta_keywords').value = keywords.join(', ');
        }

        // Auto-generate SEO URL
        if (!document.getElementById('seo_url').value && name) {
            document.getElementById('seo_url').value = name.toLowerCase()
                .replace(/[^a-z0-9\s-]/g, '')
                .replace(/\s+/g, '-')
                .replace(/-+/g, '-')
                .trim('-');
        }
    }

    // Add event listeners for auto-generation
    document.getElementById('name').addEventListener('input', autoGenerateSeoFields);
    document.getElementById('description').addEventListener('input', autoGenerateSeoFields);
    document.getElementById('category_id').addEventListener('change', autoGenerateSeoFields);
    document.getElementById('brand').addEventListener('input', autoGenerateSeoFields);

    // Character counter for meta description
    document.getElementById('meta_description').addEventListener('input', function() {
        const maxLength = 160;
        const currentLength = this.value.length;
        const remaining = maxLength - currentLength;

        // Update character count display
        let counter = this.parentNode.querySelector('.char-counter');
        if (!counter) {
            counter = document.createElement('p');
            counter.className = 'char-counter text-xs mt-1';
            this.parentNode.appendChild(counter);
        }

        if (remaining < 0) {
            counter.textContent = `${Math.abs(remaining)} characters over limit`;
            counter.className = 'char-counter text-xs mt-1 text-red-500';
        } else {
            counter.textContent = `${remaining} characters remaining`;
            counter.className = 'char-counter text-xs mt-1 text-gray-500';
        }
    });

    // Character counter for meta title
    document.getElementById('meta_title').addEventListener('input', function() {
        const maxLength = 60;
        const currentLength = this.value.length;
        const remaining = maxLength - currentLength;

        // Update character count display
        let counter = this.parentNode.querySelector('.char-counter');
        if (!counter) {
            counter = document.createElement('p');
            counter.className = 'char-counter text-xs mt-1';
            this.parentNode.appendChild(counter);
        }

        if (remaining < 0) {
            counter.textContent = `${Math.abs(remaining)} characters over limit`;
            counter.className = 'char-counter text-xs mt-1 text-red-500';
        } else {
            counter.textContent = `${remaining} characters remaining`;
            counter.className = 'char-counter text-xs mt-1 text-gray-500';
        }
    });
    </script>
    @endpush
</x-admin-layout>
