<div class="mb-4">
    <h3 class="text-lg font-medium text-gray-900">description</h3>
    <p class="mt-1 text-sm text-gray-600">{{ $product->description }}</p>
</div>

@if($product->dynamic_fields)
<div class="mb-4">
    <h3 class="text-lg font-medium text-gray-900">ویژگی‌های محصول</h3>
    <div class="mt-2 grid grid-cols-1 gap-4 sm:grid-cols-2">
        @foreach($product->dynamic_fields as $field)
            <div class="bg-white overflow-hidden shadow rounded-lg">
                <div class="px-4 py-5 sm:p-6">
                    <dt class="text-sm font-medium text-gray-500 truncate">{{ $field['label'] }}</dt>
                    <dd class="mt-1 text-sm text-gray-900">
                        @if($field['type'] === 'text')
                            {{ $field['value'] ?? '-' }}
                        @elseif($field['type'] === 'select')
                            {{ $field['value'] ?? '-' }}
                        @elseif($field['type'] === 'checkbox')
                            @if(isset($field['value']) && is_array($field['value']))
                                {{ implode(', ', $field['value']) }}
                            @else
                                -
                            @endif
                        @elseif($field['type'] === 'radio')
                            {{ $field['value'] ?? '-' }}
                        @endif
                    </dd>
                </div>
            </div>
        @endforeach
    </div>
</div>
@endif

<div class="mb-4">
    <h3 class="text-lg font-medium text-gray-900">تصاویر محصول</h3>
    <div class="mt-2 grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4">
        @foreach($product->images as $image)
            <div class="relative">
                <img src="{{ asset('storage/' . $image->path) }}" alt="{{ $product->name }}" class="w-full h-32 object-cover rounded-lg">
            </div>
        @endforeach
    </div>
</div>
