<x-admin-layout>
    <div class="bg-white p-4 rounded-md">
    <x-slot name="title">Edit Role Permissions</x-slot>
    <h1 class="text-2xl font-bold mb-6">Edit Role: {{ $role->name }}</h1>
    <form method="POST" action="{{ route('admin.roles.update', $role->id) }}">
        @csrf
        @method('PUT')
        <div class="mb-6 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            @foreach($permissions as $permission)
                <label class="flex items-center space-x-2">
                    <input type="checkbox" name="permissions[]" value="{{ $permission->id }}"
                        {{ $role->permissions->contains($permission->id) ? 'checked' : '' }}>
                    <span>{{ $permission->name }}</span>
                </label>
            @endforeach
        </div>
        <div class="flex justify-end">
            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">Save</button>
        </div>
    </form>
</div>
</x-admin-layout>
