@section('title', 'Shopping Cart')
@section('meta_description', 'Your shopping cart at ' . config('app.name') . '. View and manage selected products before checkout. Secure purchase and fast delivery.')

<x-app-layout>
    <x-slot name="header">
        <div class="bg-gradient-to-r from-purple-600 to-blue-600 -mx-6 -mt-6 px-6 pt-6 pb-8">
            <h2 class="font-bold text-2xl text-white leading-tight flex items-center">
                <svg class="w-8 h-8 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4m0 0L7 13m0 0l-1.5 6M7 13l-1.5-6m0 0h15M17 21a2 2 0 100-4 2 2 0 000 4zM9 21a2 2 0 100-4 2 2 0 000 4z"/>
                </svg>
                {{ __('Shopping Cart') }}
            </h2>
        </div>
    </x-slot>

    <div class="py-12 bg-gradient-to-br from-gray-50 to-blue-50 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if($cartItems->isEmpty())
                <!-- Empty Cart State -->
                <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
                    <div class="p-12 text-center">
                        <div class="mx-auto w-32 h-32 bg-gradient-to-br from-purple-100 to-blue-100 rounded-full flex items-center justify-center mb-8">
                            <svg class="w-16 h-16 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4m0 0L7 13m0 0l-1.5 6M7 13l-1.5-6m0 0h15"/>
                            </svg>
                        </div>
                        <h3 class="text-3xl font-bold text-gray-900 mb-4">{{ __('Your Cart is Empty') }}</h3>
                        <p class="text-xl text-gray-600 mb-8 max-w-md mx-auto">{{ __('Looks like you haven\'t added anything to your cart yet. Start shopping to find amazing products!') }}</p>
                        <a href="{{ route('home') }}" class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-purple-600 to-blue-600 hover:from-purple-700 hover:to-blue-700 text-white font-semibold rounded-xl transition-all duration-300 transform hover:scale-105 shadow-lg hover:shadow-xl">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                            </svg>
                            {{ __('Start Shopping') }}
                        </a>
                    </div>
                </div>
            @else
                <!-- Cart Items -->
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                    <!-- Cart Items Column -->
                    <div class="lg:col-span-2 space-y-6">
                        <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
                            <div class="bg-gradient-to-r from-purple-600 to-blue-600 px-6 py-4">
                                <h3 class="text-xl font-bold text-white flex items-center">
                                    <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                    </svg>
                                    {{ __('Cart Items') }} ({{ $cartItems->count() }})
                                </h3>
                            </div>
                            <div class="p-6">
                                <div class="space-y-6">
                                    @foreach($cartItems as $item)
                                        <div class="group bg-gradient-to-r from-white to-gray-50 rounded-xl p-6 border border-gray-200 hover:shadow-lg transition-all duration-300">
                                            <div class="flex items-center space-x-6">
                                                <!-- Product Image -->
                                                <div class="relative flex-shrink-0">
                                                    @if($item->product->first_image)
                                                        <img src="{{ asset($item->product->first_image) }}"
                                                             alt="{{ $item->product->name }}"
                                                             class="w-24 h-24 object-cover rounded-xl shadow-md group-hover:shadow-lg transition-shadow duration-300">
                                                    @else
                                                        <div class="w-24 h-24 bg-gray-100 rounded-xl flex items-center justify-center">
                                                            <svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                                            </svg>
                                                        </div>
                                                    @endif
                                                    <div class="absolute -top-2 -right-2 w-6 h-6 bg-gradient-to-r from-purple-500 to-blue-500 rounded-full flex items-center justify-center">
                                                        <span class="text-white text-xs font-bold">{{ $item->quantity }}</span>
                                                    </div>
                                                </div>

                                                <!-- Product Details -->
                                                <div class="flex-1 min-w-0">
                                                    <h4 class="text-xl font-bold text-gray-900 mb-2 group-hover:text-purple-600 transition-colors duration-300">
                                                        {{ $item->product->name }}
                                                    </h4>
                                                    <p class="text-gray-600 mb-3">{{ Str::limit($item->product->description, 60) }}</p>

                                                    <!-- Dynamic Selections Display -->
                                                    @if($item->dynamic_selections && !empty($item->dynamic_selections))
                                                        <div class="mb-3">
                                                            <h5 class="text-sm font-semibold text-gray-700 mb-2">Selected Options:</h5>
                                                            <div class="space-y-1">
                                                                @php
                                                                    $dynamicFields = [];
                                                                    if (is_string($item->product->dynamic_fields)) {
                                                                        $decoded = json_decode($item->product->dynamic_fields, true);
                                                                        if (is_array($decoded)) {
                                                                            $dynamicFields = $decoded;
                                                                        }
                                                                    } elseif (is_array($item->product->dynamic_fields)) {
                                                                        $dynamicFields = $item->product->dynamic_fields;
                                                                    }
                                                                @endphp

                                                                @foreach($item->dynamic_selections as $fieldIndex => $selection)
                                                                    @if(isset($dynamicFields[$fieldIndex]))
                                                                        @php
                                                                            $field = $dynamicFields[$fieldIndex];
                                                                            $fieldTitle = $field['title'] ?? 'Unknown Field';
                                                                        @endphp

                                                                        <div class="text-sm text-gray-600">
                                                                            <span class="font-medium">{{ $fieldTitle }}:</span>
                                                                            @if($selection['type'] === 'select' || $selection['type'] === 'radio')
                                                                                @if(isset($field['options'][$selection['value']]))
                                                                                    @php
                                                                                        $option = $field['options'][$selection['value']];
                                                                                        $optionName = is_array($option) ? $option['name'] : $option;
                                                                                        $optionPrice = is_array($option) ? ($option['price'] ?? 0) : 0;
                                                                                    @endphp
                                                                                    <span class="text-gray-800">{{ $optionName }}</span>
                                                                                    @if($optionPrice > 0)
                                                                                        <span class="text-green-600 font-semibold">(+${{ number_format($optionPrice, 2) }})</span>
                                                                                    @endif
                                                                                @endif
                                                                            @elseif($selection['type'] === 'checkbox')
                                                                                @if(isset($selection['values']) && is_array($selection['values']))
                                                                                    @php
                                                                                        $selectedOptions = [];
                                                                                        foreach($selection['values'] as $valueIndex) {
                                                                                            if(isset($field['options'][$valueIndex])) {
                                                                                                $option = $field['options'][$valueIndex];
                                                                                                $optionName = is_array($option) ? $option['name'] : $option;
                                                                                                $optionPrice = is_array($option) ? ($option['price'] ?? 0) : 0;
                                                                                                $selectedOptions[] = $optionName . ($optionPrice > 0 ? ' (+$' . number_format($optionPrice, 2) . ')' : '');
                                                                                            }
                                                                                        }
                                                                                    @endphp
                                                                                    <span class="text-gray-800">{{ implode(', ', $selectedOptions) }}</span>
                                                                                @endif
                                                                            @endif
                                                                        </div>
                                                                    @endif
                                                                @endforeach
                                                            </div>
                                                        </div>
                                                    @endif

                                                    <div class="flex items-center space-x-4">
                                                        <span class="text-sm text-gray-500">{{ __('Unit Price:') }}</span>
                                                        <span class="text-lg font-semibold text-gray-900">${{ number_format($item->product->price, 2) }}</span>
                                                        @if($item->additional_price > 0)
                                                            <span class="text-sm text-green-600 font-semibold">+ ${{ number_format($item->additional_price, 2) }} options</span>
                                                        @endif
                                                    </div>
                                                </div>

                                                <!-- Quantity & Actions -->
                                                <div class="flex flex-col items-end space-y-4">
                                                    <div class="text-right">
                                                        <div class="text-2xl font-black text-gray-900 mb-1">
                                                            ${{ number_format(($item->total_price ?? $item->product->price) * $item->quantity, 2) }}
                                                        </div>
                                                        <div class="text-sm text-gray-500">{{ __('Total') }}</div>
                                                    </div>

                                                    <div class="flex items-center space-x-3">
                                                        <!-- Quantity Update -->
                                                        <form action="{{ route('cart.update', $item->id) }}" method="POST" class="flex items-center bg-white rounded-lg border-2 border-gray-200 focus-within:border-purple-500 transition-colors duration-300">
                                                            @csrf
                                                            @method('PATCH')
                                                            <input type="number"
                                                                   name="quantity"
                                                                   value="{{ $item->quantity }}"
                                                                   min="1"
                                                                   class="w-16 px-3 py-2 text-center border-0 rounded-l-lg focus:ring-0 font-semibold">
                                                            <button type="submit" class="px-4 py-2 bg-gradient-to-r from-purple-500 to-blue-500 hover:from-purple-600 hover:to-blue-600 text-white font-semibold rounded-r-lg transition-all duration-300 transform hover:scale-105">
                                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                                                                </svg>
                                                            </button>
                                                        </form>

                                                        <!-- Remove Button -->
                                                        <form action="{{ route('cart.remove', $item->id) }}" method="POST">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="p-3 bg-red-100 hover:bg-red-200 text-red-600 hover:text-red-700 rounded-lg transition-all duration-300 transform hover:scale-105 group/remove">
                                                                <svg class="w-4 h-4 group-hover/remove:animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                                                </svg>
                                                            </button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Order Summary Column -->
                    <div class="lg:col-span-1">
                        <div class="bg-white rounded-2xl shadow-xl overflow-hidden sticky top-6">
                            <div class="bg-gradient-to-r from-purple-600 to-blue-600 px-6 py-4">
                                <h3 class="text-xl font-bold text-white flex items-center">
                                    <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 7h6m0 10v-3m-3 3h.01M9 17h.01M9 14h.01M12 14h.01M15 11h.01M12 11h.01M9 11h.01M7 21h10a2 2 0 002-2V5a2 2 0 00-2-2H7a2 2 0 00-2 2v14a2 2 0 002 2z"/>
                                    </svg>
                                    {{ __('Order Summary') }}
                                </h3>
                            </div>
                            <div class="p-6 space-y-6">
                                <!-- Summary Details -->
                                <div class="space-y-4">
                                    <div class="flex justify-between items-center py-2 border-b border-gray-100">
                                        <span class="text-gray-600">{{ __('Subtotal') }}</span>
                                        <span class="font-semibold text-gray-900">${{ number_format($subtotal, 2) }}</span>
                                    </div>
                                    <div class="flex justify-between text-sm p-3 bg-green-50 rounded-xl mt-4">
                                        <span class="text-gray-600 font-medium">Shipping</span>
                                        <span class="font-bold text-green-600 flex items-center">
                                            @if($shippingTotal == 0)
                                                Free
                                            @else
                                                ${{ number_format($shippingTotal, 2) }}
                                            @endif
                                        </span>
                                    </div>
                                    <div class="flex justify-between items-center py-2 border-b border-gray-100">
                                        <span class="text-gray-600">{{ __('Tax') }}</span>
                                        <span class="font-semibold text-gray-900">${{ number_format($tax, 2) }}</span>
                                    </div>
                                    <div class="flex justify-between items-center py-4 border-t-2 border-gray-200">
                                        <span class="text-xl font-bold text-gray-900">{{ __('Total') }}</span>
                                        <span class="text-2xl font-black text-gray-900">${{ number_format($total, 2) }}</span>
                                    </div>
                                </div>

                                <!-- Action Buttons -->
                                <div class="space-y-4">
                                    <a href="{{ route('checkout.index') }}"
                                       class="block w-full text-center bg-gradient-to-r from-green-500 to-emerald-600 hover:from-green-600 hover:to-emerald-700 text-white font-bold py-4 px-6 rounded-xl transition-all duration-300 transform hover:scale-105 shadow-lg hover:shadow-xl">
                                        <svg class="w-5 h-5 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
                                        </svg>
                                        {{ __('Proceed to Checkout') }}
                                    </a>

                                    <a href="{{ route('home') }}"
                                       class="block w-full text-center bg-gray-100 hover:bg-gray-200 text-gray-800 font-semibold py-3 px-6 rounded-xl transition-all duration-300">
                                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16l-4-4m0 0l4-4m-4 4h18"/>
                                        </svg>
                                        {{ __('Continue Shopping') }}
                                    </a>
                                </div>

                                <!-- Security Notice -->
                                <div class="bg-green-50 border border-green-200 rounded-xl p-4">
                                    <div class="flex items-center">
                                        <svg class="w-5 h-5 text-green-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                                        </svg>
                                        <div>
                                            <p class="text-sm font-semibold text-green-800">{{ __('Secure Checkout') }}</p>
                                            <p class="text-xs text-green-600">{{ __('Your information is protected') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>
