@section('title', 'Crypto Payment ')
@section('meta_description', 'Complete your order securely with cryptocurrency payment at ' . config('app.name') . '. Fast, safe, and easy crypto checkout.')

<x-app-layout>
    <x-slot name="header">
        <div class="bg-gradient-to-r from-blue-600 to-purple-600 -mx-6 -mt-6 px-6 pt-6 pb-8">
            <h2 class="font-bold text-2xl text-white leading-tight flex items-center">
                <svg class="w-8 h-8 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
                </svg>
                Payment Information
            </h2>
            <p class="text-blue-100 mt-2">Complete your payment to finalize your order</p>
        </div>
    </x-slot>

    <div class="py-12 bg-gradient-to-br from-gray-50 to-blue-50 min-h-screen">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            @if(isset($payment) && isset($order))
                <!-- Payment Success Card -->
                <div class="bg-white rounded-2xl shadow-xl overflow-hidden mb-8 border border-gray-100">
                    <div class="bg-gradient-to-r from-green-500 to-emerald-600 px-8 py-6">
                        <div class="flex items-center">
                            <div class="bg-white/20 rounded-full p-3 mr-4">
                                <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-2xl font-bold text-white">Payment Ready</h3>
                                <p class="text-green-100">Send the exact amount to complete your order</p>
                            </div>
                        </div>
                    </div>

                    <div class="p-8">
                        <div class="bg-blue-50 border-l-4 border-blue-500 p-6 rounded-r-xl mb-6">
                            <div class="flex items-start">
                                <svg class="w-6 h-6 text-blue-500 mr-3 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                <div>
                                    <h4 class="text-lg font-semibold text-blue-800 mb-2">Payment Instructions</h4>
                                    <p class="text-blue-700 text-lg">
                                        Please send exactly <span class="font-bold text-2xl text-blue-900">{{ $payment['pay_amount'] }} {{ strtoupper($payment['pay_currency']) }}</span>
                                    </p>
                                    <p class="text-blue-600 mt-1">to the following address:</p>
                                </div>
                            </div>
                        </div>

                        <!-- Payment Address Section -->
                        <div class="bg-gray-50 rounded-xl p-6 border-2 border-dashed border-gray-300">
                            <label class="block text-sm font-semibold text-gray-700 mb-3 uppercase tracking-wide">
                                Payment Address:
                            </label>
                            <div class="flex flex-col md:flex-row md:items-center space-y-4 md:space-y-0 md:space-x-6">
                                <div class="flex-1 relative">
                                    <input type="text"
                                           class="w-full px-4 py-4 bg-white border-2 border-gray-200 rounded-xl font-mono text-lg text-gray-800 focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300"
                                           value="{{ $payment['pay_address'] }}"
                                           readonly>
                                    <div class="absolute right-4 top-1/2 transform -translate-y-1/2">
                                        <span class="bg-gray-100 text-gray-600 text-xs px-2 py-1 rounded-full">READ ONLY</span>
                                    </div>
                                </div>
                                <button class="bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-semibold px-6 py-4 rounded-xl transition-all duration-300 transform hover:scale-105 shadow-lg hover:shadow-xl"
                                        type="button"
                                        onclick="copyToClipboard('{{ $payment['pay_address'] }}')">
                                    <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
                                    </svg>
                                    Copy
                                </button>
                                <!-- QR Code for Payment Address -->
                                <div class="flex-shrink-0 flex flex-col items-center">
                                    <img src="https://api.qrserver.com/v1/create-qr-code/?size=180x180&data={{ urlencode($payment['pay_address']) }}" alt="QR Code" class="w-36 h-36 border-2 border-gray-200 rounded-xl shadow-md">
                                    <span class="text-xs text-gray-500 mt-2">Scan to pay</span>
                                </div>
                            </div>
                        </div>

                        <!-- Timer Warning -->
                        <div class="bg-amber-50 border-l-4 border-amber-500 p-6 rounded-r-xl mt-6">
                            <div class="flex items-start">
                                <svg class="w-6 h-6 text-amber-500 mr-3 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.982 16.5c-.77.833.192 2.5 1.732 2.5z"/>
                                </svg>
                                <div>
                                    <h4 class="text-lg font-semibold text-amber-800 mb-2">⏰ Payment Deadline</h4>
                                    <p class="text-amber-700">
                                        <strong>Important:</strong> This payment will expire at
                                        <span class="font-bold text-amber-900">{{ \Carbon\Carbon::parse($payment['expires_at'])->format('Y-m-d H:i:s') }}</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Order Summary Card -->
                <div class="bg-white rounded-2xl shadow-xl overflow-hidden border border-gray-100">
                    <div class="bg-gradient-to-r from-gray-800 to-gray-900 px-8 py-6">
                        <h3 class="text-2xl font-bold text-white flex items-center">
                            <svg class="w-7 h-7 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                            Order Summary
                        </h3>
                    </div>

                    <div class="p-8">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            <div class="space-y-4">
                                <div class="flex justify-between items-center py-3 border-b border-gray-200">
                                    <span class="text-gray-600 font-medium">Order ID:</span>
                                    <span class="font-bold text-lg text-gray-900">#{{ $order->id }}</span>
                                </div>
                                <div class="flex justify-between items-center py-3">
                                    <span class="text-gray-600 font-medium">Total Amount:</span>
                                    <span class="font-bold text-2xl text-green-600">${{ number_format($order->total_amount, 2) }}</span>
                                </div>
                            </div>

                            <div class="flex justify-center md:justify-end">
                                <a href="{{ route('orders.show', $order) }}"
                                   class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-purple-600 to-pink-600 hover:from-purple-700 hover:to-pink-700 text-white font-semibold rounded-xl transition-all duration-300 transform hover:scale-105 shadow-lg hover:shadow-xl">
                                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                    </svg>
                                    View Order Status
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

            @else
                <!-- Error Card -->
                <div class="bg-white rounded-2xl shadow-xl overflow-hidden border border-red-200">
                    <div class="bg-gradient-to-r from-red-500 to-red-600 px-8 py-6">
                        <div class="flex items-center">
                            <div class="bg-white/20 rounded-full p-3 mr-4">
                                <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.982 16.5c-.77.833.192 2.5 1.732 2.5z"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-2xl font-bold text-white">Payment Error</h3>
                                <p class="text-red-100">Payment information is missing</p>
                            </div>
                        </div>
                    </div>

                    <div class="p-8 text-center">
                        <div class="mb-6">
                            <div class="mx-auto w-20 h-20 bg-red-100 rounded-full flex items-center justify-center mb-4">
                                <svg class="w-10 h-10 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                </svg>
                            </div>
                            <h4 class="text-xl font-bold text-gray-900 mb-2">Oops! Something went wrong</h4>
                            <p class="text-gray-600">Please contact support if this error persists.</p>
                        </div>

                        <a href="{{ route('checkout.index') }}"
                           class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-semibold rounded-xl transition-all duration-300 transform hover:scale-105 shadow-lg hover:shadow-xl">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                            </svg>
                            Return to Checkout
                        </a>
                    </div>
                </div>
            @endif
        </div>
    </div>

    @push('scripts')
    <script>
    function copyToClipboard(text) {
        navigator.clipboard.writeText(text).then(function() {
            // Show success message with modern toast
            showToast('Address copied to clipboard!', 'success');
        }).catch(function(err) {
            console.error('Could not copy text: ', err);
            showToast('Failed to copy address', 'error');
        });
    }

    function showToast(message, type) {
        const toast = document.createElement('div');
        toast.className = `fixed top-4 right-4 px-6 py-4 rounded-xl shadow-lg z-50 transform transition-all duration-300 ${
            type === 'success'
                ? 'bg-green-500 text-white'
                : 'bg-red-500 text-white'
        }`;
        toast.innerHTML = `
            <div class="flex items-center">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    ${type === 'success'
                        ? '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>'
                        : '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>'
                    }
                </svg>
                ${message}
            </div>
        `;

        document.body.appendChild(toast);

        // Animate in
        setTimeout(() => {
            toast.style.transform = 'translateX(0)';
        }, 100);

        // Remove after 3 seconds
        setTimeout(() => {
            toast.style.transform = 'translateX(100%)';
            setTimeout(() => {
                document.body.removeChild(toast);
            }, 300);
        }, 3000);
    }
    </script>
    @endpush

</x-app-layout>
