@section('title', 'Checkout')
@section('meta_description', 'Fast and secure checkout process at ' . config('app.name') . '. Enter shipping info, select payment gateway, and complete your order.')

@php
    $cryptoCurrencies = [
        'BTC' => 'Bitcoin',
        'ETH' => 'Ethereum',
        'USDT' => 'Tether',
        'DOGE' => 'Dogecoin',
        // Add more as needed
    ];
@endphp
<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-bold text-2xl text-gray-800 leading-tight flex items-center">
                <div class="p-2 bg-gradient-to-r from-blue-600 to-purple-600 rounded-xl mr-3">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4m0 0L7 13m0 0l-1.5 9M7 13h10M17 17a2 2 0 100 4 2 2 0 000-4zM9 17a2 2 0 100 4 2 2 0 000-4z"/>
                    </svg>
                </div>
                <span class="bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent">
                    {{ __('Secure Checkout') }}
                </span>
            </h2>
            <a href="{{ route('cart.index') }}" class="group bg-gradient-to-r from-gray-600 to-gray-700 hover:from-gray-700 hover:to-gray-800 text-white font-semibold py-3 px-6 rounded-xl transition-all duration-300 flex items-center shadow-lg hover:shadow-xl transform hover:scale-105">
                <svg class="w-5 h-5 mr-2 transform group-hover:-translate-x-1 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
                Back to Cart
            </a>
        </div>
    </x-slot>

    <!-- Enhanced Progress Bar -->
    <div class="bg-white shadow-lg border-b-4 border-gradient-to-r from-blue-500 to-purple-500">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="py-6">
                <div class="flex items-center justify-center">
                    <div class="flex items-center space-x-8">
                        <!-- Step 1: Cart -->
                        <div class="flex items-center">
                            <div class="relative">
                                <div class="w-12 h-12 bg-gradient-to-r from-green-500 to-green-600 rounded-full flex items-center justify-center text-white font-bold text-lg shadow-lg animate-pulse-subtle">
                                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                </div>
                                <div class="absolute -inset-2 bg-green-400 rounded-full opacity-20 animate-ping"></div>
                            </div>
                            <div class="ml-3">
                                <span class="text-sm font-bold text-green-600">Cart</span>
                                <p class="text-xs text-gray-500">Items selected</p>
                            </div>
                        </div>

                        <!-- Progress Line -->
                        <div class="flex-1 h-2 bg-gradient-to-r from-green-500 to-blue-500 rounded-full mx-4 relative overflow-hidden">
                            <div class="absolute inset-0 bg-gradient-to-r from-green-400 to-blue-400 opacity-50 animate-shimmer"></div>
                        </div>

                        <!-- Step 2: Checkout (Current) -->
                        <div class="flex items-center">
                            <div class="relative">
                                <div class="w-12 h-12 bg-gradient-to-r from-blue-600 to-purple-600 rounded-full flex items-center justify-center text-white font-bold text-lg shadow-lg animate-bounce-subtle">
                                    2
                                </div>
                                <div class="absolute -inset-2 bg-blue-400 rounded-full opacity-20 animate-ping"></div>
                            </div>
                            <div class="ml-3">
                                <span class="text-sm font-bold text-blue-600">Checkout</span>
                                <p class="text-xs text-gray-500">Payment details</p>
                            </div>
                        </div>

                        <!-- Progress Line -->
                        <div class="flex-1 h-2 bg-gray-200 rounded-full mx-4 relative overflow-hidden">
                            <div class="absolute inset-0 w-1/3 bg-gradient-to-r from-blue-500 to-purple-500 rounded-full animate-pulse"></div>
                        </div>

                        <!-- Step 3: Complete -->
                        <div class="flex items-center">
                            <div class="w-12 h-12 bg-gray-200 rounded-full flex items-center justify-center text-gray-500 font-bold text-lg">
                                3
                            </div>
                            <div class="ml-3">
                                <span class="text-sm font-medium text-gray-400">Complete</span>
                                <p class="text-xs text-gray-400">Order confirmation</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Floating Background Elements -->
    <div class="fixed inset-0 overflow-hidden pointer-events-none z-0">
        <div class="absolute top-20 left-10 w-32 h-32 bg-blue-200 rounded-full opacity-10 animate-float"></div>
        <div class="absolute top-40 right-20 w-24 h-24 bg-purple-200 rounded-full opacity-10 animate-float-delayed"></div>
        <div class="absolute bottom-20 left-1/4 w-28 h-28 bg-pink-200 rounded-full opacity-10 animate-float-slow"></div>
    </div>

    <div class="relative z-10 py-12 bg-gradient-to-br from-gray-50 via-blue-50 to-purple-50 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

                <!-- Enhanced Order Summary -->
                <div class="lg:col-span-1">
                    <div class="bg-white rounded-3xl shadow-2xl overflow-hidden border border-gray-100 backdrop-blur-sm bg-white/90">
                        <div class="relative bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 px-6 py-6">
                            <div class="absolute inset-0 bg-gradient-to-r from-blue-600/90 via-purple-600/90 to-pink-600/90"></div>
                            <h3 class="relative text-xl font-bold text-white flex items-center">
                                <div class="p-2 bg-white/20 rounded-xl mr-3 backdrop-blur-sm">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v6a2 2 0 002 2h6a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                                    </svg>
                                </div>
                                Order Summary
                            </h3>
                            <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -mr-16 -mt-16"></div>
                        </div>

                        <div class="p-6">
                            <div class="space-y-4 max-h-96 overflow-y-auto custom-scrollbar">
                                @foreach($cartItems as $item)
                                    <div class="group flex items-center space-x-4 p-4 bg-gradient-to-r from-gray-50 to-blue-50 rounded-2xl border border-gray-100 hover:shadow-lg hover:border-blue-200 transition-all duration-500 transform hover:-translate-y-1">
                                        <div class="relative">
                                            @php
                                                $images = is_string($item->product->image) ? json_decode($item->product->image, true) : $item->product->image;
                                                $firstImage = !empty($images) ? $images[0] : null;
                                            @endphp
                                            @if($firstImage)
                                                <img src="{{ asset('/' . $firstImage) }}"
                                                     alt="{{ $item->product->name }}"
                                                     class="w-16 h-16 object-cover rounded-xl shadow-lg group-hover:scale-110 transition-transform duration-300">
                                            @else
                                                <div class="w-16 h-16 bg-gray-100 rounded-xl flex items-center justify-center">
                                                    <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                                    </svg>
                                                </div>
                                            @endif
                                            <div class="absolute -top-2 -right-2 bg-gradient-to-r from-blue-600 to-purple-600 text-white text-xs font-bold rounded-full w-6 h-6 flex items-center justify-center shadow-lg animate-pulse">
                                                {{ $item->quantity }}
                                            </div>
                                        </div>
                                        <div class="flex-1">
                                            <h4 class="font-bold text-gray-900 text-sm group-hover:text-blue-600 transition-colors duration-300">{{ $item->product->name }}</h4>
                                            <p class="text-gray-500 text-xs">Qty: {{ $item->quantity }}</p>
                                            <p class="text-blue-600 font-bold text-sm">${{ number_format($item->total_price, 2) }} each</p>

                                            @if($item->additional_price > 0)
                                                <p class="text-green-600 font-bold text-xs">+${{ number_format($item->additional_price, 2) }} options</p>
                                            @endif

                                            @if($item->dynamic_selections)
                                                @php
                                                    $selections = is_string($item->dynamic_selections) ? json_decode($item->dynamic_selections, true) : $item->dynamic_selections;
                                                @endphp
                                                @if($selections && is_array($selections))
                                                    <div class="mt-1">
                                                        @foreach($selections as $fieldName => $selection)
                                                            @if(is_array($selection) && isset($selection['value']))
                                                                <p class="text-xs text-gray-600">{{ $fieldName }}: {{ $selection['value'] }}</p>
                                                            @elseif(is_string($selection))
                                                                <p class="text-xs text-gray-600">{{ $fieldName }}: {{ $selection }}</p>
                                                            @endif
                                                        @endforeach
                                                    </div>
                                                @endif
                                            @endif
                                        </div>
                                        <div class="text-right">
                                            @php
                                                $itemTotal = $item->total_price * $item->quantity;
                                            @endphp
                                            <p class="font-black text-gray-900 text-lg">${{ number_format($itemTotal, 2) }}</p>
                                        </div>
                                    </div>
                                @endforeach
                            </div>

                            <!-- Enhanced Order Totals -->
                            <div class="mt-6 pt-6 border-t-2 border-gray-100 space-y-4">
                                <div class="flex justify-between text-sm p-3 bg-gray-50 rounded-xl">
                                    <span class="text-gray-600 font-medium">Subtotal</span>
                                    <span class="font-bold text-gray-900">${{ number_format($total, 2) }}</span>
                                </div>
                                <div class="flex justify-between text-sm p-3 bg-green-50 rounded-xl">
                                    <span class="text-gray-600 font-medium">Shipping</span>
                                    <span class="font-bold text-green-600 flex items-center">
                                        @if($shippingTotal == 0)
                                        Free
                                        @else
                                            ${{ number_format($shippingTotal, 2) }}
                                        @endif
                                    </span>
                                </div>
                                <div class="flex justify-between text-sm p-3 bg-yellow-50 rounded-xl">
                                    <span class="text-gray-600 font-medium">Tax ({{ number_format($taxRate * 100, 0) }}%)</span>
                                    <span class="font-bold text-yellow-700">${{ number_format($tax, 2) }}</span>
                                </div>
                                <div class="border-t-2 border-gray-200 pt-4">
                                    <div class="flex justify-between text-xl font-black p-4 bg-gradient-to-r from-blue-50 to-purple-50 rounded-xl border-2 border-blue-200">
                                        <span class="text-gray-900">Total</span>
                                        <span class="text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-purple-600">${{ number_format($totalWithTax, 2) }}</span>
                                    </div>
                                </div>
                            </div>

                            <!-- Enhanced Security Badge -->
                            <div class="mt-6 p-4 bg-gradient-to-r from-green-50 to-emerald-50 border-2 border-green-200 rounded-xl">
                                <div class="flex items-center text-green-700">
                                    <div class="p-2 bg-green-100 rounded-lg mr-3">
                                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                        </svg>
                                    </div>
                                    <div>
                                        <span class="text-sm font-bold">256-bit SSL Encryption</span>
                                        <p class="text-xs text-green-600">Your payment is 100% secure</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Enhanced Checkout Form - Mobile Responsive -->
                <div class="lg:col-span-2 order-1 lg:order-2">
                    <div class="bg-white rounded-xl sm:rounded-3xl shadow-lg sm:shadow-2xl overflow-hidden border border-gray-100 backdrop-blur-sm bg-white/90">
                        <div class="relative bg-gradient-to-r from-purple-600 via-pink-600 to-red-500 px-4 sm:px-6 py-4 sm:py-6">
                            <div class="absolute inset-0 bg-gradient-to-r from-purple-600/90 via-pink-600/90 to-red-500/90"></div>
                            <h3 class="relative text-lg sm:text-xl font-bold text-white flex items-center">
                                <div class="p-1.5 sm:p-2 bg-white/20 rounded-lg sm:rounded-xl mr-2 sm:mr-3 backdrop-blur-sm">
                                    <svg class="w-4 h-4 sm:w-5 sm:h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    </svg>
                                </div>
                                Shipping & Payment Details
                            </h3>
                            <div class="absolute top-0 right-0 w-16 h-16 sm:w-32 sm:h-32 bg-white/10 rounded-full -mr-8 -mt-8 sm:-mr-16 sm:-mt-16"></div>
                        </div>

                        <form id="checkout-form" method="POST" action="{{ route('checkout.process') }}" class="p-4 sm:p-8">
                            @csrf
                            <input type="hidden" name="payment_method" id="payment_method_hidden" value="{{ old('payment_method', array_key_first($nonCryptoGateways)) }}">

                            <!-- Enhanced Error/Success Messages - Mobile Responsive -->
                            @if (session('error'))
                                <div class="mb-4 sm:mb-6 p-3 sm:p-4 bg-gradient-to-r from-red-50 to-pink-50 border-l-4 border-red-500 rounded-lg sm:rounded-xl shadow-lg animate-shake">
                                    <div class="flex items-center text-red-700">
                                        <div class="p-1.5 sm:p-2 bg-red-100 rounded-lg mr-2 sm:mr-3">
                                            <svg class="w-4 h-4 sm:w-5 sm:h-5" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                            </svg>
                                        </div>
                                        <span class="font-semibold text-sm sm:text-base">{{ session('error') }}</span>
                                    </div>
                                </div>
                            @endif

                            @if (session('success'))
                                <div class="mb-4 sm:mb-6 p-3 sm:p-4 bg-gradient-to-r from-green-50 to-emerald-50 border-l-4 border-green-500 rounded-lg sm:rounded-xl shadow-lg animate-fade-in">
                                    <div class="flex items-center text-green-700">
                                        <div class="p-1.5 sm:p-2 bg-green-100 rounded-lg mr-2 sm:mr-3">
                                            <svg class="w-4 h-4 sm:w-5 sm:h-5" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                            </svg>
                                        </div>
                                        <span class="font-semibold text-sm sm:text-base">{{ session('success') }}</span>
                                    </div>
                                </div>
                            @endif

                            @if ($errors->any())
                                <div class="mb-4 sm:mb-6 p-3 sm:p-4 bg-gradient-to-r from-red-50 to-pink-50 border-l-4 border-red-500 rounded-lg sm:rounded-xl shadow-lg">
                                    <div class="flex items-center text-red-700 mb-2 sm:mb-3">
                                        <div class="p-1.5 sm:p-2 bg-red-100 rounded-lg mr-2 sm:mr-3">
                                            <svg class="w-4 h-4 sm:w-5 sm:h-5" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                            </svg>
                                        </div>
                                        <span class="font-semibold text-sm sm:text-base">Please fix the following errors:</span>
                                    </div>
                                    <ul class="list-disc list-inside text-xs sm:text-sm text-red-600 space-y-1">
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <!-- Enhanced Shipping Information - Mobile Responsive -->
                            <div class="mb-6 sm:mb-8">
                                <h4 class="text-lg sm:text-xl font-bold text-gray-900 mb-4 sm:mb-6 flex items-center">
                                    <div class="p-1.5 sm:p-2 bg-gradient-to-r from-blue-500 to-purple-500 rounded-lg sm:rounded-xl mr-2 sm:mr-3">
                                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                        </svg>
                                    </div>
                                    <span class="bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent">Shipping Address</span>
                                </h4>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-6 mb-4 sm:mb-6">
                                    <div class="space-y-1 sm:space-y-2">
                                        <label for="first_name" class="block text-xs sm:text-sm font-bold text-gray-700">First Name</label>
                                        <input type="text" id="first_name" name="first_name" required
                                            class="w-full px-3 sm:px-4 py-3 sm:py-4 rounded-lg sm:rounded-2xl border-2 border-gray-200 focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 bg-white shadow-sm hover:shadow-md text-sm sm:text-base">
                                    </div>
                                    <div class="space-y-1 sm:space-y-2">
                                        <label for="last_name" class="block text-xs sm:text-sm font-bold text-gray-700">Last Name</label>
                                        <input type="text" id="last_name" name="last_name" required
                                            class="w-full px-3 sm:px-4 py-3 sm:py-4 rounded-lg sm:rounded-2xl border-2 border-gray-200 focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 bg-white shadow-sm hover:shadow-md text-sm sm:text-base">
                                    </div>
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-6 mb-4 sm:mb-6">
                                    <div class="space-y-1 sm:space-y-2">
                                        <label for="email" class="block text-xs sm:text-sm font-bold text-gray-700">Email Address</label>
                                        <input type="email" id="email" name="email" required
                                            class="w-full px-3 sm:px-4 py-3 sm:py-4 rounded-lg sm:rounded-2xl border-2 border-gray-200 focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 bg-white shadow-sm hover:shadow-md text-sm sm:text-base">
                                    </div>
                                    <div class="space-y-1 sm:space-y-2">
                                        <label for="phone" class="block text-xs sm:text-sm font-bold text-gray-700">Phone Number</label>
                                        <input type="tel" id="phone" name="phone" required
                                            class="w-full px-3 sm:px-4 py-3 sm:py-4 rounded-lg sm:rounded-2xl border-2 border-gray-200 focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 bg-white shadow-sm hover:shadow-md text-sm sm:text-base">
                                    </div>
                                </div>

                                <div class="space-y-1 sm:space-y-2">
                                    <label for="shipping_address" class="block text-xs sm:text-sm font-bold text-gray-700">Complete Address</label>
                                    <textarea id="shipping_address" name="shipping_address" rows="3" required placeholder="Street address"
                                        class="w-full px-3 sm:px-4 py-3 sm:py-4 rounded-lg sm:rounded-2xl border-2 border-gray-200 focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 resize-none bg-white shadow-sm hover:shadow-md text-sm sm:text-base"></textarea>
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-6">
                                    <div class="space-y-1 sm:space-y-2">
                                        <label for="country" class="block text-xs sm:text-sm font-bold text-gray-700">Country</label>
                                        <input type="text" id="country" name="country" required
                                            class="w-full px-3 sm:px-4 py-3 sm:py-4 rounded-lg sm:rounded-2xl border-2 border-gray-200 focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 bg-white shadow-sm hover:shadow-md text-sm sm:text-base"
                                            placeholder="Enter your country">
                                    </div>
                                    <div class="space-y-1 sm:space-y-2">
                                        <label for="city" class="block text-xs sm:text-sm font-bold text-gray-700">City</label>
                                        <input type="text" id="city" name="city" required
                                            class="w-full px-3 sm:px-4 py-3 sm:py-4 rounded-lg sm:rounded-2xl border-2 border-gray-200 focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 bg-white shadow-sm hover:shadow-md text-sm sm:text-base"
                                            placeholder="Enter your city">
                                    </div>
                                </div>
                            </div>

                            <!-- Enhanced Payment Method - Mobile Responsive -->
                            <div class="mb-6 sm:mb-8">
                                <h4 class="text-lg sm:text-xl font-bold text-gray-900 mb-4 sm:mb-6 flex items-center">
                                    <div class="p-1.5 sm:p-2 bg-gradient-to-r from-green-500 to-emerald-500 rounded-lg sm:rounded-xl mr-2 sm:mr-3">
                                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
                                        </svg>
                                    </div>
                                    <span class="bg-gradient-to-r from-green-600 to-emerald-600 bg-clip-text text-transparent">Payment Method</span>
                                </h4>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-6">
                                    @foreach($nonCryptoGateways as $key => $label)
                                        <label class="payment-option relative flex items-center p-4 sm:p-6 border-2 border-gray-200 rounded-lg sm:rounded-2xl cursor-pointer hover:border-blue-400 hover:bg-blue-50 transition-all duration-500 group transform hover:scale-105 hover:shadow-xl">
                                            <input type="radio" value="{{ $key }}" class="sr-only payment-method-radio" {{ $loop->first ? 'checked' : '' }}>
                                            <div class="flex items-center w-full">
                                                <div class="radio-circle w-5 h-5 sm:w-6 sm:h-6 border-2 border-gray-300 rounded-full flex items-center justify-center group-hover:border-blue-500 mr-3 sm:mr-4 transition-all duration-300">
                                                    <div class="radio-dot w-2.5 h-2.5 sm:w-3 sm:h-3 bg-blue-600 rounded-full opacity-0 group-hover:opacity-50 transition-all duration-300"></div>
                                                </div>
                                                <div class="p-2 sm:p-3 bg-blue-100 rounded-lg sm:rounded-xl mr-3 sm:mr-4 group-hover:bg-blue-200 transition-colors duration-300">
                                                    @if($key === 'paypal')
                                                        <i class="fab fa-paypal text-blue-600 text-lg sm:text-2xl"></i>
                                                    @elseif($key === 'stripe')
                                                        <i class="fa-solid fa-credit-card text-indigo-600 text-lg sm:text-2xl"></i>
                                                    @elseif($key === 'payoneer')
                                                        <i class="fa-solid fa-credit-card text-green-600 text-lg sm:text-2xl"></i>
                                                    @elseif($key === 'wise')
                                                        <i class="fa-solid fa-money-bill-wave text-teal-600 text-lg sm:text-2xl"></i>
                                                    @endif
                                                </div>
                                                <div>
                                                    <span class="font-bold text-gray-900 text-base sm:text-lg">{{ $label }}</span>
                                                    <p class="text-xs sm:text-sm text-gray-600">Pay with {{ $label }}</p>
                                                </div>
                                            </div>
                                            <div class="selection-indicator absolute inset-0 border-2 border-blue-500 rounded-lg sm:rounded-2xl opacity-0 transition-all duration-300"></div>
                                        </label>
                                    @endforeach
                                    @if(count($cryptoGateways))
                                        <label class="payment-option relative flex items-center p-4 sm:p-6 border-2 border-gray-200 rounded-lg sm:rounded-2xl cursor-pointer hover:border-yellow-400 hover:bg-yellow-50 transition-all duration-500 group transform hover:scale-105 hover:shadow-xl">
                                            <input type="radio" value="crypto" class="sr-only payment-method-radio">
                                            <div class="flex items-center w-full">
                                                <div class="radio-circle w-5 h-5 sm:w-6 sm:h-6 border-2 border-gray-300 rounded-full flex items-center justify-center group-hover:border-yellow-500 mr-3 sm:mr-4 transition-all duration-300">
                                                    <div class="radio-dot w-2.5 h-2.5 sm:w-3 sm:h-3 bg-yellow-500 rounded-full opacity-0 group-hover:opacity-50 transition-all duration-300"></div>
                                                </div>
                                                <div class="p-2 sm:p-3 bg-yellow-100 rounded-lg sm:rounded-xl mr-3 sm:mr-4 group-hover:bg-yellow-200 transition-colors duration-300">
                                                    <i class="fa-solid fa-coins text-yellow-600 text-lg sm:text-2xl"></i>
                                                </div>
                                                <div>
                                                    <span class="font-bold text-gray-900 text-base sm:text-lg">Cryptocurrency</span>
                                                    <p class="text-xs sm:text-sm text-gray-600">Pay with crypto (BTC, ETH, ...)</p>
                                                </div>
                                            </div>
                                            <div class="selection-indicator absolute inset-0 border-2 border-yellow-500 rounded-lg sm:rounded-2xl opacity-0 transition-all duration-300"></div>
                                        </label>
                                    @endif
                                </div>
                                @if(count($cryptoGateways))
                                <div id="crypto-gateway-selection" class="hidden mt-4 p-4 bg-gray-50 rounded-xl border border-gray-200">
                                    <input type="hidden" id="total_amount" value="{{ $totalWithTax }}">
                                    <label for="crypto_gateway" class="block text-sm font-medium text-gray-700 mb-2">Select Crypto Gateway</label>
                                    <select name="crypto_gateway" id="crypto_gateway" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:ring-4 focus:ring-yellow-200 focus:border-yellow-500 transition-all duration-300">
                                        @foreach($cryptoGateways as $key => $label)
                                            <option value="{{ $key }}">{{ $label }}</option>
                                        @endforeach
                                    </select>
                                    <label for="crypto_currency" class="block text-sm font-medium text-gray-700 mb-2 mt-4">Select Cryptocurrency</label>
                                    <select name="crypto_currency" id="crypto_currency" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:ring-4 focus:ring-yellow-200 focus:border-yellow-500 transition-all duration-300">
                                        <!-- Options will be filled by JS -->
                                    </select>
                                </div>
                                <script>
                                    document.addEventListener('DOMContentLoaded', function() {
                                        const cryptoRadio = document.querySelector('input[name="payment_method"][value="crypto"]');
                                        const cryptoSection = document.getElementById('crypto-gateway-selection');
                                        if (cryptoRadio && cryptoSection) {
                                            cryptoRadio.addEventListener('change', function() {
                                                if (this.checked) {
                                                    cryptoSection.classList.remove('hidden');
                                                }
                                            });
                                            document.querySelectorAll('input[name="payment_method"]').forEach(function(radio) {
                                                if (radio.value !== 'crypto') {
                                                    radio.addEventListener('change', function() {
                                                        cryptoSection.classList.add('hidden');
                                                    });
                                                }
                                            });
                                        }
                                        // Dynamic crypto currency dropdown
                                        function updateCryptoCurrencies() {
                                            const amount = {{ $totalWithTax }};
                                            const select = document.getElementById('crypto_currency');
                                            if (!select) return;
                                            select.innerHTML = '<option>Loading...</option>';
                                            fetch(`/api/available-cryptos?amount=${amount}`)
                                                .then(res => res.json())
                                                .then(currencies => {
                                                    select.innerHTML = '';
                                                    if (currencies.length === 0) {
                                                        select.innerHTML = '<option value="">No crypto available</option>';
                                                    } else {
                                                        currencies.forEach(function(code) {
                                                            let name = code;
                                                            if (code === 'BTC') name = 'Bitcoin';
                                                            if (code === 'ETH') name = 'Ethereum';
                                                            if (code === 'USDT') name = 'Tether';
                                                            if (code === 'DOGE') name = 'Dogecoin';
                                                            select.innerHTML += `<option value="${code}">${name}</option>`;
                                                        });
                                                    }
                                                })
                                                .catch(() => {
                                                    select.innerHTML = '<option value="">Error loading</option>';
                                                });
                                        }
                                        // Only run if crypto section exists
                                        if (document.getElementById('crypto_currency')) {
                                            updateCryptoCurrencies();
                                        }
                                    });
                                </script>
                                @endif
                            </div>

                            <!-- Enhanced Order Notes -->
                            <div class="mb-6">
                                <label for="order_notes" class="block text-sm font-bold text-gray-700 mb-3">Order Notes (Optional)</label>
                                <textarea id="order_notes" name="order_notes" rows="4"
                                    class="w-full px-4 py-4 border-2 border-gray-200 rounded-2xl focus:ring-4 focus:ring-purple-200 focus:border-purple-500 transition-all duration-300 resize-none bg-white shadow-sm hover:shadow-md"
                                    placeholder="Add any special instructions or notes for your order...">{{ old('order_notes') }}</textarea>
                            </div>

                            <!-- Enhanced Terms and Conditions -->
                            <div class="mb-8">
                                <div class="flex items-start p-4 bg-gray-50 rounded-2xl border border-gray-200">
                                    <div class="flex items-center h-5 mt-1">
                                        <input id="terms" name="terms" type="checkbox" class="w-5 h-5 border-2 border-gray-300 rounded-lg bg-white focus:ring-4 focus:ring-blue-300 text-blue-600 transition-all duration-300" required>
                                    </div>
                                    <label for="terms" class="ml-3 text-sm font-medium text-gray-700 leading-relaxed">
                                        I agree to the <a href="#" class="text-blue-600 hover:text-blue-800 underline font-bold">Terms and Conditions</a> and <a href="#" class="text-blue-600 hover:text-blue-800 underline font-bold">Privacy Policy</a>
                                    </label>
                                </div>
                                @error('terms')
                                    <p class="mt-2 text-sm text-red-600 font-medium">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Enhanced Submit Button -->
                            <button type="submit" id="submit-button" class="w-full bg-gradient-to-r from-green-600 via-blue-600 to-purple-600 hover:from-green-700 hover:via-blue-700 hover:to-purple-700 text-white font-bold py-5 px-8 rounded-2xl shadow-2xl hover:shadow-3xl transform hover:scale-105 transition-all duration-500 flex items-center justify-center relative overflow-hidden group">
                                <div class="absolute inset-0 bg-gradient-to-r from-green-400 via-blue-400 to-purple-400 opacity-0 group-hover:opacity-20 transition-opacity duration-500"></div>
                                <svg class="w-6 h-6 mr-3 relative z-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                                </svg>
                                <span class="text-xl font-black relative z-10">Complete Secure Order - ${{ number_format($totalWithTax, 2) }}</span>
                            </button>

                            <!-- Enhanced Security Info -->
                            <div class="mt-6 text-center">
                                <div class="flex items-center justify-center space-x-6 text-sm text-gray-500">
                                    <div class="flex items-center">
                                        <svg class="w-5 h-5 mr-2 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"/>
                                        </svg>
                                        <span class="font-medium">SSL Encrypted</span>
                                    </div>
                                    <div class="flex items-center">
                                        <svg class="w-5 h-5 mr-2 text-blue-500" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                        </svg>
                                        <span class="font-medium">100% Secure</span>
                                    </div>
                                    <div class="flex items-center">
                                        <svg class="w-5 h-5 mr-2 text-purple-500" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                        </svg>
                                        <span class="font-medium">Money Back Guarantee</span>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>


<script src="{{ asset('site/js/checkout.js') }}"></script>

