@section('title', 'Cooperation With Us')
@section('meta_description', 'Submit your cooperation request for selling, buying, or advertising with ' . config('app.name') . '. Join us for business partnership opportunities and grow your brand.')
@section('meta_keywords', 'cooperation, partnership, business, sell, buy, advertise, join, request, ' . config('app.name'))
@section('robots', 'index, follow')
@section('canonical_url', url()->current())
@section('og_title', 'Cooperation With Us | ' . config('app.name'))
@section('og_description', 'Submit your cooperation request for selling, buying, or advertising with ' . config('app.name') . '. Join us for business partnership opportunities and grow your brand.')
@section('og_type', 'website')
@section('og_url', url()->current())
@section('og_image', asset('logo/logo.png'))
@section('twitter_card', 'summary_large_image')
@section('twitter_title', 'Cooperation With Us | ' . config('app.name'))
@section('twitter_description', 'Submit your cooperation request for selling, buying, or advertising with ' . config('app.name'))
@section('twitter_image', asset('logo/logo.png'))
@section('schema_markup')
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebPage",
  "name": "Cooperation With Us",
  "description": "Submit your cooperation request for selling, buying, or advertising with {{ config('app.name') }}. Join us for business partnership opportunities and grow your brand.",
  "url": "{{ url()->current() }}",
  "publisher": {
    "@type": "Organization",
    "name": "{{ config('app.name') }}",
    "logo": {
      "@type": "ImageObject",
      "url": "{{ asset('logo/logo.png') }}"
    }
  }
}
</script>
<x-app-layout>
    <div class="max-w-2xl mx-auto py-10">
        <h1 class="text-3xl font-extrabold mb-8 text-center bg-gradient-to-r from-blue-600 via-purple-500 to-pink-500 bg-clip-text text-transparent drop-shadow-lg">Cooperation With Us</h1>
        @if(isset($pendingRequest) && $pendingRequest)
            <div class="bg-gradient-to-r from-yellow-100 via-yellow-50 to-yellow-100 border-l-4 border-yellow-500 text-yellow-800 p-4 mb-8 rounded-lg shadow">
                <span class="font-bold">Notice:</span> You have already submitted a cooperation request. Please wait for review.<br>
                Status: <b class="uppercase">{{ ucfirst($pendingRequest->status) }}</b>
            </div>
        @endif
        <div class="mb-8 flex flex-col items-center">
            <label class="mb-2 font-semibold text-lg text-gray-700">Select cooperation type:</label>
            <select id="cooperationType" class="border-2 border-purple-300 focus:border-pink-400 focus:ring-2 focus:ring-pink-200 rounded-xl p-2 w-64 shadow-sm bg-white text-gray-700 transition-all duration-200" @if(isset($pendingRequest) && $pendingRequest) disabled @endif>
                <option value="">Select</option>
                <option value="seller">Sell Cooperation</option>
                <option value="buyer">Buy Cooperation</option>
                <option value="advertiser">Advertising Cooperation</option>
            </select>
        </div>
        <div id="formContainer"></div>
    </div>
    <script>
        const inputClass = 'border-2 border-gray-200 focus:border-pink-400 focus:ring-2 focus:ring-pink-200 rounded-xl p-2 w-full shadow-sm bg-white text-gray-700 transition-all duration-200';
        const textareaClass = 'border-2 border-gray-200 focus:border-blue-400 focus:ring-2 focus:ring-blue-200 rounded-xl p-2 w-full shadow-sm bg-white text-gray-700 transition-all duration-200';
        const labelClass = 'block mb-1 font-semibold text-gray-700';
        const buttonClass = 'bg-gradient-to-r from-pink-500 via-purple-500 to-blue-500 text-white px-8 py-2 rounded-xl shadow-lg font-bold hover:from-pink-600 hover:to-blue-600 hover:scale-105 transition-all duration-200';
        const forms = {
            seller: `
                <form id='coopForm' class='space-y-6 bg-white/80 backdrop-blur-lg rounded-2xl shadow-xl p-6 border border-purple-100' method='POST' action='{{ route('cooperation.store') }}'>
                    <input type='hidden' name='_token' value='{{ csrf_token() }}'>
                    <input type='hidden' name='type' value='seller'>
                    <div class='grid grid-cols-1 md:grid-cols-2 gap-6'>
                        <div><label class='${labelClass}'>Full Name *</label><input type='text' name='name' class='${inputClass}' required></div>
                        <div><label class='${labelClass}'>Email *</label><input type='email' name='email' class='${inputClass}' required></div>
                        <div><label class='${labelClass}'>Mobile Number *</label><input type='text' name='mobile' class='${inputClass}' required></div>
                        <div><label class='${labelClass}'>WhatsApp Number</label><input type='text' name='whatsapp' class='${inputClass}'></div>
                        <div><label class='${labelClass}'>Store Name</label><input type='text' name='store_name' class='${inputClass}'></div>
                        <div><label class='${labelClass}'>Store Phone</label><input type='text' name='store_phone' class='${inputClass}'></div>
                        <div class='md:col-span-2'><label class='${labelClass}'>Store Address</label><input type='text' name='store_address' class='${inputClass}'></div>
                        <div class='md:col-span-2'><label class='${labelClass}'>Website / Social Media</label><input type='text' name='website' class='${inputClass}'></div>
                        <div class='md:col-span-2'><label class='${labelClass}'>Brand Names (comma separated)</label><input type='text' name='brands' class='${inputClass}'></div>
                        <div class='md:col-span-2'><label class='${labelClass}'>Product Types (comma separated)</label><input type='text' name='product_types' class='${inputClass}'></div>
                        <div class='md:col-span-2'><label class='${labelClass}'>Business Registration Number</label><input type='text' name='registration_number' class='${inputClass}'></div>
                        <div class='md:col-span-2'><label class='${labelClass}'>Years in Business</label><input type='number' name='years_in_business' class='${inputClass}' min='0'></div>
                    </div>
                    <div><label class='${labelClass}'>Description / Additional Info</label><textarea name='description' class='${textareaClass}' rows='3'></textarea></div>
                    <div class='text-center'><button type='submit' class='${buttonClass}'>Submit</button></div>
                </form>
            `,
            buyer: `
                <form id='coopForm' class='space-y-6 bg-white/80 backdrop-blur-lg rounded-2xl shadow-xl p-6 border border-blue-100' method='POST' action='{{ route('cooperation.store') }}'>
                    <input type='hidden' name='_token' value='{{ csrf_token() }}'>
                    <input type='hidden' name='type' value='buyer'>
                    <div class='grid grid-cols-1 md:grid-cols-2 gap-6'>
                        <div><label class='${labelClass}'>Full Name *</label><input type='text' name='name' class='${inputClass}' required></div>
                        <div><label class='${labelClass}'>Email *</label><input type='email' name='email' class='${inputClass}' required></div>
                        <div><label class='${labelClass}'>Mobile Number *</label><input type='text' name='mobile' class='${inputClass}' required></div>
                        <div><label class='${labelClass}'>WhatsApp Number</label><input type='text' name='whatsapp' class='${inputClass}'></div>
                        <div><label class='${labelClass}'>Company Name</label><input type='text' name='company_name' class='${inputClass}'></div>
                        <div><label class='${labelClass}'>Company Address</label><input type='text' name='company_address' class='${inputClass}'></div>
                        <div class='md:col-span-2'><label class='${labelClass}'>Product(s) Needed (comma separated) *</label><input type='text' name='products_needed' class='${inputClass}' required></div>
                        <div><label class='${labelClass}'>Estimated Quantity *</label><input type='number' name='quantity' class='${inputClass}' min='1' required></div>
                        <div><label class='${labelClass}'>Preferred Brands</label><input type='text' name='preferred_brands' class='${inputClass}'></div>
                        <div class='md:col-span-2'><label class='${labelClass}'>Delivery Address *</label><input type='text' name='delivery_address' class='${inputClass}' required></div>
                        <div class='md:col-span-2'><label class='${labelClass}'>Budget (optional)</label><input type='text' name='budget' class='${inputClass}'></div>
                        <div class='md:col-span-2'><label class='${labelClass}'>Purchase Frequency</label><select name='purchase_frequency' class='${inputClass}'><option value=''>Select</option><option value='one_time'>One Time</option><option value='monthly'>Monthly</option><option value='quarterly'>Quarterly</option><option value='yearly'>Yearly</option></select></div>
                    </div>
                    <div><label class='${labelClass}'>Description / Additional Info</label><textarea name='description' class='${textareaClass}' rows='3'></textarea></div>
                    <div class='text-center'><button type='submit' class='${buttonClass}'>Submit</button></div>
                </form>
            `,
            advertiser: `
                <form id='coopForm' class='space-y-6 bg-white/80 backdrop-blur-lg rounded-2xl shadow-xl p-6 border border-pink-100' method='POST' action='{{ route('cooperation.store') }}'>
                    <input type='hidden' name='_token' value='{{ csrf_token() }}'>
                    <input type='hidden' name='type' value='advertiser'>
                    <div class='grid grid-cols-1 md:grid-cols-2 gap-6'>
                        <div><label class='${labelClass}'>Full Name *</label><input type='text' name='name' class='${inputClass}' required></div>
                        <div><label class='${labelClass}'>Email *</label><input type='email' name='email' class='${inputClass}' required></div>
                        <div><label class='${labelClass}'>Mobile Number *</label><input type='text' name='mobile' class='${inputClass}' required></div>
                        <div><label class='${labelClass}'>WhatsApp Number</label><input type='text' name='whatsapp' class='${inputClass}'></div>
                        <div><label class='${labelClass}'>Company/Agency Name</label><input type='text' name='company_name' class='${inputClass}'></div>
                        <div><label class='${labelClass}'>Advertising Type *</label><select name='ads_type' class='${inputClass}' required><option value=''>Select</option><option value='social_media'>Social Media</option><option value='influencer'>Influencer</option><option value='website'>Website</option><option value='other'>Other</option></select></div>
                        <div class='md:col-span-2'><label class='${labelClass}'>Platforms (comma separated)</label><input type='text' name='platforms' class='${inputClass}' placeholder='Instagram, Telegram, Google, ...'></div>
                        <div class='md:col-span-2'><label class='${labelClass}'>Target Audience</label><input type='text' name='audience' class='${inputClass}'></div>
                        <div class='md:col-span-2'><label class='${labelClass}'>Previous Campaigns / Experience</label><textarea name='experience' class='${textareaClass}' rows='2'></textarea></div>
                        <div class='md:col-span-2'><label class='${labelClass}'>Proposal / Offer Description *</label><textarea name='proposal' class='${textareaClass}' rows='3' required></textarea></div>
                    </div>
                    <div><label class='${labelClass}'>Description / Additional Info</label><textarea name='description' class='${textareaClass}' rows='3'></textarea></div>
                    <div class='text-center'><button type='submit' class='${buttonClass}'>Submit</button></div>
                </form>
            `
        };
        const pending = {{ (isset($pendingRequest) && $pendingRequest) ? 'true' : 'false' }};
        document.getElementById('cooperationType').addEventListener('change', function() {
            if (pending) return;
            const val = this.value;
            document.getElementById('formContainer').innerHTML = forms[val] || '';
            if (val) attachAjaxForm();
        });
        function attachAjaxForm() {
            const form = document.getElementById('coopForm');
            if (!form) return;
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                const oldAlerts = form.querySelectorAll('.coop-alert');
                oldAlerts.forEach(el => el.remove());
                const formData = new FormData(form);
                fetch(form.action, {
                    method: 'POST',
                    headers: { 'X-Requested-With': 'XMLHttpRequest' },
                    body: formData
                })
                .then(res => res.json().then(data => ({ok: res.ok, data})))
                .then(res => {
                    const oldAlerts = form.querySelectorAll('.coop-alert');
                    oldAlerts.forEach(el => el.remove());
                    if (res.ok) {
                        form.innerHTML = `<div class='coop-alert bg-gradient-to-r from-green-100 via-green-50 to-green-100 border-l-4 border-green-500 text-green-800 p-4 rounded-lg shadow'>${res.data.message}</div>`;
                        document.getElementById('cooperationType').disabled = true;
                    } else {
                        form.querySelector('button[type="submit"]').disabled = false;
                        form.insertAdjacentHTML('afterbegin', `<div class='coop-alert bg-gradient-to-r from-red-100 via-red-50 to-red-100 border-l-4 border-red-500 text-red-800 p-2 mb-2 rounded-lg shadow'>${res.data.message}</div>`);
                    }
                })
                .catch(() => {
                    const oldAlerts = form.querySelectorAll('.coop-alert');
                    oldAlerts.forEach(el => el.remove());
                    form.insertAdjacentHTML('afterbegin', `<div class='coop-alert bg-gradient-to-r from-red-100 via-red-50 to-red-100 border-l-4 border-red-500 text-red-800 p-2 mb-2 rounded-lg shadow'>An error occurred. Please try again.</div>`);
                });
                form.querySelector('button[type="submit"]').disabled = true;
            });
        }
        if (pending) {
            document.getElementById('formContainer').innerHTML = '';
        }
    </script>
</x-app-layout>
