@component('mail::message')
{{-- Header --}}
@if($type === 'new')
# 🆕 New Product Added!
@else
# ✏️ Product Updated!
@endif

{{-- Product Image --}}
@if($firstImage)
<img src="{{ asset($firstImage) }}" alt="{{ $product->name }}" style="width:100%;max-width:400px;border-radius:16px;margin:24px auto;display:block;box-shadow:0 4px 24px #0001;">
@endif

{{-- Product Name --}}
## {{ $product->name }}

{{-- Product Description --}}
@if($product->description)
<p style="font-size:1.1em;color:#444;line-height:1.7;margin-bottom:16px;">
    {{ Str::limit(strip_tags($product->description), 200) }}
</p>
@endif

{{-- Product Price --}}
@if($product->price)
**Price:** <span style="color:#16a34a;font-weight:bold;">${{ number_format($product->price, 2) }}</span>
@endif

{{-- View Product Button --}}
@component('mail::button', ['url' => $productUrl, 'color' => 'blue'])
View Product
@endcomponent

---
Thanks for staying with {{ config('app.name') }}!
@endcomponent
