@section('title', $seoData['title'] ?? 'Home')
@section('meta_description', $seoData['description'] ?? 'Discover authentic luxury brands, exclusive products, and premium shopping experience at ' . config('app.name') . '. Shop the worlds best designer items with fast delivery and secure checkout.')

@if(isset($seoData))
    @section('meta_keywords', $seoData['meta_keywords'] ?? '')
    @section('canonical', $seoData['canonical'] ?? '')
    @section('og_title', $seoData['og_title'] ?? '')
    @section('og_description', $seoData['og_description'] ?? '')
    @section('og_type', $seoData['og_type'] ?? 'website')
    @section('og_url', $seoData['og_url'] ?? '')
    @section('og_image', $seoData['og_image'] ?? '')
    @section('twitter_card', $seoData['twitter_card'] ?? '')
    @section('twitter_title', $seoData['twitter_title'] ?? '')
    @section('twitter_description', $seoData['twitter_description'] ?? '')
    @section('twitter_image', $seoData['twitter_image'] ?? '')
    @section('structured_data', json_encode($seoData['structured_data'] ?? []))
@endif

<x-app-layout>

    <!-- Hero Section - Compact and Responsive -->
    <div class="relative bg-gradient-to-br from-blue-900 via-purple-900 to-indigo-900 overflow-hidden min-h-[60vh] lg:min-h-[70vh]">
        <!-- Animated Background Pattern -->
        <div class="absolute inset-0">
            <div class="absolute inset-0 bg-[radial-gradient(circle_at_50%_50%,rgba(120,119,198,0.3),rgba(255,255,255,0))]"></div>
            <div class="absolute top-0 left-0 w-full h-full bg-gradient-to-r from-purple-800/90 to-blue-900/90"></div>
        </div>

        <!-- Floating Animated Elements - Smaller and fewer -->
        <div class="absolute top-10 left-5 w-12 h-12 bg-yellow-400/30 rounded-full blur-lg animate-pulse"></div>
        <div class="absolute top-20 right-10 w-16 h-16 bg-pink-400/30 rounded-full blur-lg animate-bounce"></div>
        <div class="absolute bottom-10 left-1/4 w-10 h-10 bg-green-400/30 rounded-full blur-lg animate-ping"></div>

        <!-- Main Hero Content - Compact -->
        <div class="relative max-w-6xl mx-auto py-16 px-4 sm:py-20 sm:px-6 lg:px-8 text-center">
            <!-- Luxury Badge - Smaller -->
            <div class="mb-4 inline-block">
                <div class="bg-gradient-to-r from-yellow-400 to-orange-500 text-black px-4 py-1 rounded-full font-bold text-xs shadow-lg animate-bounce">
                    🏆 EXCLUSIVE LUXURY 🏆
                </div>
            </div>

            <!-- Main Title - Smaller and more responsive -->
            <h1 class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-black tracking-tight text-white mb-4 animate-fade-in-up">
                <span class="bg-gradient-to-r from-yellow-400 via-pink-400 to-purple-400 bg-clip-text text-transparent drop-shadow-xl">
                    {{ __('Welcome to ') . config('app.name', 'Royalux') }}
                </span>
            </h1>

            <!-- Subtitle - Compact -->
            <div class="relative mb-6">
                <p class="mt-4 text-sm sm:text-base md:text-lg text-gray-200 max-w-3xl mx-auto leading-relaxed animate-fade-in-up-delay font-medium">
                    {{ __('🌟 The premier destination for authentic luxury brands in the UAE and elite countries. Only original, world-renowned labels—exclusively for those who demand the best.') }}
                </p>
                <div class="absolute inset-0 bg-gradient-to-r from-transparent via-white/10 to-transparent blur-sm"></div>
            </div>

            <!-- Action Button - Smaller -->
            <div class="mt-6 flex justify-center">
                <a href="#products" class="group relative inline-flex items-center px-6 py-3 text-base font-bold text-white bg-gradient-to-r from-pink-500 via-purple-600 to-indigo-600 rounded-full hover:from-pink-600 hover:via-purple-700 hover:to-indigo-700 transform hover:scale-105 transition-all duration-300 shadow-xl hover:shadow-pink-500/50">
                    <span class="absolute inset-0 bg-gradient-to-r from-pink-400 to-purple-600 rounded-full blur-lg opacity-50 group-hover:opacity-75 animate-pulse"></span>
                    <svg class="w-5 h-5 mr-2 relative z-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                    </svg>
                    <span class="relative z-10">{{ __('🛍️ START SHOPPING') }}</span>
                </a>
            </div>

            <!-- Congratulations Message - Compact -->
            <div class="mt-6 p-4 bg-gradient-to-r from-yellow-400/20 to-orange-500/20 backdrop-blur-lg rounded-xl border border-yellow-400/30 shadow-xl">
                <p class="text-sm sm:text-base md:text-lg text-yellow-300 font-bold animate-bounce">
                    {{ __('🎉 Congratulations! You\'ve unlocked access to ') . config('app.name', 'Royalux') . __(' —where only the world\'s most exclusive luxury shoppers belong! 🥂') }}
                </p>
            </div>
        </div>

        <!-- Decorative Elements - Smaller -->
        <div class="absolute top-5 left-5 w-12 h-12 border-2 border-white/20 rounded-full animate-spin" style="animation-duration: 8s;"></div>
        <div class="absolute top-10 right-10 w-10 h-10 border-2 border-purple-400/30 rounded-full animate-ping"></div>
        <div class="absolute bottom-10 left-1/4 w-8 h-8 border-2 border-pink-400/40 rounded-full animate-pulse"></div>
    </div>

    <!-- Breadcrumbs Navigation - Compact -->
    @if(isset($seoData['breadcrumbs']) && count($seoData['breadcrumbs']) > 1)
        <div class="bg-white border-b border-gray-200">
            <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 py-2">
                <nav class="flex" aria-label="Breadcrumb">
                    <ol class="flex items-center space-x-2 text-sm">
                        @foreach($seoData['breadcrumbs'] as $index => $breadcrumb)
                            <li class="flex items-center">
                                @if($index > 0)
                                    <svg class="flex-shrink-0 h-4 w-4 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" />
                                    </svg>
                                @endif
                                @if($index === count($seoData['breadcrumbs']) - 1)
                                    <span class="text-gray-500 font-medium">{{ $breadcrumb['title'] }}</span>
                                @else
                                    <a href="{{ $breadcrumb['url'] }}" class="text-blue-600 hover:text-blue-800 font-medium">
                                        {{ $breadcrumb['title'] }}
                                    </a>
                                @endif
                            </li>
                        @endforeach
                    </ol>
                </nav>
            </div>
        </div>
    @endif

    <!-- Premium Search Section - Compact -->
    <div class="bg-gradient-to-r from-white via-gray-50 to-white shadow-lg border-t-4 border-gradient-to-r from-blue-500 via-purple-500 to-pink-500">
        <div class="max-w-6xl mx-auto py-8 px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-6">
                <h2 class="text-2xl sm:text-3xl font-black text-gray-900 mb-2">
                    <span class="bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent">
                        🔍 {{ __('Find Your Perfect Luxury Item') }} 🔍
                    </span>
                </h2>
            </div>

            <form action="{{ route('home') }}" method="GET" class="space-y-4">
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                    <div class="sm:col-span-2">
                        <div class="relative group">
                            <label for="search" class="sr-only">{{ __('Search Products') }}</label>
                            <input type="text"
                                   name="search"
                                   id="search"
                                   value="{{ request('search') }}"
                                   placeholder="{{ __('Search luxury products...') }}"
                                   aria-label="{{ __('Search for luxury products') }}"
                                   class="w-full pl-12 pr-4 py-3 rounded-xl border-2 border-gray-200 shadow-md focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 text-base bg-white/90 backdrop-blur-sm hover:shadow-lg group-hover:border-purple-400">
                            <svg class="absolute left-4 top-1/2 transform -translate-y-1/2 w-5 h-5 text-gray-400 group-hover:text-purple-500 transition-colors duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                            </svg>
                        </div>
                    </div>
                    <div>
                        <label for="category" class="sr-only">{{ __('Select Category') }}</label>
                        <select name="category" id="category" aria-label="{{ __('Filter by category') }}"
                                class="w-full py-3 px-4 rounded-xl border-2 border-gray-200 shadow-md focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 text-base bg-white/90 backdrop-blur-sm hover:shadow-lg hover:border-purple-400">
                            <option value="">{{ __('🏷️ All Categories') }}</option>
                            @foreach($categories ?? [] as $category)
                                <option value="{{ $category->id }}" {{ request('category') == $category->id || request('category') == (string)$category->id ? 'selected' : '' }}>
                                    {{ $category->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label for="sort" class="sr-only">{{ __('Sort Products') }}</label>
                        <select name="sort" id="sort" aria-label="{{ __('Sort products by') }}"
                                class="w-full py-3 px-4 rounded-xl border-2 border-gray-200 shadow-md focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 text-base bg-white/90 backdrop-blur-sm hover:shadow-lg hover:border-purple-400">
                            <option value="newest" {{ request('sort') == 'newest' ? 'selected' : '' }}>{{ __('⭐ Newest') }}</option>
                            <option value="price_asc" {{ request('sort') == 'price_asc' ? 'selected' : '' }}>{{ __('💰 Price: Low to High') }}</option>
                            <option value="price_desc" {{ request('sort') == 'price_desc' ? 'selected' : '' }}>{{ __('💎 Price: High to Low') }}</option>
                            <option value="name" {{ request('sort') == 'name' ? 'selected' : '' }}>{{ __('📝 Name A-Z') }}</option>
                        </select>
                    </div>
                </div>
                <div class="flex justify-center">
                    <button type="submit"
                            aria-label="{{ __('Search for products') }}"
                            class="group relative inline-flex items-center px-8 py-3 border-0 rounded-xl shadow-lg text-base font-bold text-white bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 hover:from-blue-700 hover:via-purple-700 hover:to-pink-700 focus:outline-none focus:ring-4 focus:ring-blue-300 transform hover:scale-105 transition-all duration-300">
                        <span class="absolute inset-0 bg-gradient-to-r from-blue-400 to-purple-600 rounded-xl blur-lg opacity-50 group-hover:opacity-75 animate-pulse"></span>
                        <svg class="w-5 h-5 mr-2 relative z-10" fill="none" stroke="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                        </svg>
                        <span class="relative z-10">{{ __('🔍 SEARCH NOW') }}</span>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Featured Products Section - Compact -->
    <div class="bg-gradient-to-br from-gray-50 via-blue-50 to-purple-50" id="products">
        <div class="max-w-6xl mx-auto py-12 px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl sm:text-4xl md:text-5xl font-black text-gray-900 mb-4">
                    <span class="bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 bg-clip-text text-transparent">
                        ✨ {{ __('Featured Luxury Products') }} ✨
                    </span>
                </h2>
                <div class="w-24 h-1 bg-gradient-to-r from-blue-500 via-purple-500 to-pink-500 mx-auto rounded-full shadow-lg mb-4"></div>
                <p class="text-base sm:text-lg text-gray-600 max-w-2xl mx-auto">
                    {{ __('Discover our handpicked selection of the finest luxury items from around the world') }}
                </p>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                @foreach($featuredProducts ?? [] as $product)
                    <div class="group bg-white/80 backdrop-blur-lg rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transform hover:-translate-y-2 hover:rotate-1 transition-all duration-500 border border-white/50 hover:border-purple-300">
                        <div class="relative overflow-hidden">
                            <img src="{{ $product->first_image ? asset($product->first_image) : 'https://via.placeholder.com/400x300?text=Luxury+Product' }}"
                                 alt="{{ $product->name }} - {{ __('Luxury Product') }}"
                                 class="w-full h-48 object-cover group-hover:scale-110 transition-transform duration-500">

                            <!-- Luxury Badge - Smaller -->
                            <div class="absolute top-2 right-2">
                                <span class="bg-gradient-to-r from-yellow-400 to-orange-500 text-black text-xs font-bold px-2 py-1 rounded-full shadow-md animate-pulse">
                                    ⭐ {{ __('FEATURED') }}
                                </span>
                            </div>

                            @if(($product->stock ?? 0) <= 5)
                                <div class="absolute top-2 left-2">
                                    <span class="bg-red-500 text-white text-xs font-bold px-2 py-1 rounded-full animate-bounce shadow-md">
                                        🚨 {{ __('LIMITED') }}
                                    </span>
                                </div>
                            @endif

                            <!-- Overlay Effect -->
                            <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                        </div>

                        <div class="p-4">
                            <h3 class="text-lg font-bold text-gray-900 mb-2 group-hover:text-blue-600 transition-colors duration-300">
                                {{ $product->name ?? 'Luxury Product' }}
                            </h3>
                            <p class="text-gray-600 text-xs mb-4 leading-relaxed">
                                {{ Str::limit($product->description ?? 'Premium luxury item', 60) }}
                            </p>

                            <div class="flex items-center justify-between mb-4">
                                @if(method_exists($product ?? new stdClass, 'hasDiscount') && $product->hasDiscount())
                                    <div class="flex items-center space-x-1">
                                        <span class="text-xl font-bold text-gray-900">
                                            ${{ number_format($product->discounted_price, 2) }}
                                        </span>
                                        <span class="text-sm text-gray-400 line-through">
                                            ${{ number_format($product->price, 2) }}
                                        </span>
                                        <span class="text-xs text-red-500 font-bold bg-red-100 px-1 py-0.5 rounded-full">
                                            {{ $product->discount_percentage }}% OFF
                                        </span>
                                    </div>
                                @else
                                    <span class="text-xl font-bold bg-gradient-to-r from-green-600 to-blue-600 bg-clip-text text-transparent">
                                        ${{ number_format($product->price ?? 999, 2) }}
                                    </span>
                                @endif

                                <div class="flex items-center text-yellow-400">
                                    @for($i = 0; $i < 5; $i++)
                                        <svg class="w-4 h-4 fill-current drop-shadow-lg" viewBox="0 0 20 20">
                                            <path d="M10 15l-5.878 3.09 1.123-6.545L.489 6.91l6.572-.955L10 0l2.939 5.955 6.572.955-4.756 4.635 1.123 6.545z"/>
                                        </svg>
                                    @endfor
                                    <span class="text-gray-500 text-xs ml-1 font-semibold">({{ rand(50, 200) }})</span>
                                </div>
                            </div>

                            <a href="{{ route('products.show', $product) ?? '#' }}"
                               class="block w-full text-center bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 hover:from-blue-700 hover:via-purple-700 hover:to-pink-700 text-white font-bold py-2 px-4 rounded-xl transition-all duration-300 transform hover:scale-105 shadow-lg hover:shadow-purple-500/50 group-hover:animate-pulse text-sm">
                                💎 {{ __('VIEW DETAILS') }}
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- All Products Section - Compact -->
    <div class="bg-white">
        <div class="max-w-6xl mx-auto py-12 px-4 sm:px-6 lg:px-8">
            <!-- Search Results Header - Compact -->
            @if(request('search') || request('category'))
                <div class="text-center mb-8">
                    <h1 class="text-2xl sm:text-3xl md:text-4xl font-black text-gray-900 mb-3">
                        <span class="bg-gradient-to-r from-purple-600 to-pink-600 bg-clip-text text-transparent">
                            @if(request('search') && request('category'))
                                {{ __('Search Results for') }} "{{ request('search') }}" {{ __('in') }} {{ $categories->find(request('category'))->name ?? '' }}
                            @elseif(request('search'))
                                {{ __('Search Results for') }} "{{ request('search') }}"
                            @elseif(request('category'))
                                {{ $categories->find(request('category'))->name ?? '' }} {{ __('Products') }}
                            @endif
                        </span>
                    </h1>
                    <div class="w-16 h-1 bg-gradient-to-r from-purple-500 to-pink-500 mx-auto rounded-full mb-3"></div>
                    <p class="text-sm sm:text-base text-gray-600">
                        @if(request('search') && request('category'))
                            {{ __('Found') }} {{ $products->total() }} {{ __('products matching') }} "{{ request('search') }}" {{ __('in') }} {{ $categories->find(request('category'))->name ?? '' }}
                        @elseif(request('search'))
                            {{ __('Found') }} {{ $products->total() }} {{ __('products matching') }} "{{ request('search') }}"
                        @elseif(request('category'))
                            {{ __('Found') }} {{ $products->total() }} {{ __('products in') }} {{ $categories->find(request('category'))->name ?? '' }}
                        @endif
                    </p>

                    <!-- Active Filters - Compact -->
                    @if(request('search') || request('category') || request('sort'))
                        <div class="mt-4 flex flex-wrap justify-center gap-2">
                            @if(request('search'))
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                    {{ __('Search:') }} {{ request('search') }}
                                    <a href="{{ route('home', array_filter(['category' => request('category'), 'sort' => request('sort')])) }}" class="ml-1 text-blue-600 hover:text-blue-800">
                                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414z" clip-rule="evenodd"/>
                                        </svg>
                                    </a>
                                </span>
                            @endif
                            @if(request('category'))
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                    {{ __('Category:') }} {{ $categories->find(request('category'))->name ?? '' }}
                                    <a href="{{ route('home', array_filter(['search' => request('search'), 'sort' => request('sort')])) }}" class="ml-1 text-green-600 hover:text-green-800">
                                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                                        </svg>
                                    </a>
                                </span>
                            @endif
                            @if(request('sort') && request('sort') !== 'newest')
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                                    {{ __('Sort:') }}
                                    @switch(request('sort'))
                                        @case('price_asc')
                                            {{ __('Price: Low to High') }}
                                            @break
                                        @case('price_desc')
                                            {{ __('Price: High to Low') }}
                                            @break
                                        @case('name')
                                            {{ __('Name A-Z') }}
                                            @break
                                        @default
                                            {{ __('Newest') }}
                                    @endswitch
                                    <a href="{{ route('home', array_filter(['search' => request('search'), 'category' => request('category')])) }}" class="ml-1 text-purple-600 hover:text-purple-800">
                                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                                        </svg>
                                    </a>
                                </span>
                            @endif
                        </div>
                    @endif
                </div>
            @else
                <div class="text-center mb-12">
                    <h2 class="text-2xl sm:text-3xl md:text-4xl font-black text-gray-900 mb-3">
                        <span class="bg-gradient-to-r from-purple-600 to-pink-600 bg-clip-text text-transparent">
                            {{ __('All Products') }}
                        </span>
                    </h2>
                    <div class="w-16 h-1 bg-gradient-to-r from-purple-500 to-pink-500 mx-auto rounded-full"></div>
                </div>
            @endif

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                @forelse($products as $product)
                    <div class="group bg-white rounded-xl shadow-md overflow-hidden hover:shadow-lg transform hover:-translate-y-1 transition-all duration-300 border border-gray-100">
                        <div class="relative overflow-hidden">
                            <img src="{{ $product->first_image ? asset($product->first_image) : 'https://via.placeholder.com/400x300?text=Product+Image' }}"
                                 alt="{{ $product->name }} - {{ __('Product Image') }}"
                                 class="w-full h-48 object-cover group-hover:scale-105 transition-transform duration-300">
                            @if($product->stock <= 5)
                                <div class="absolute top-2 right-2">
                                    <span class="bg-red-500 text-white text-xs font-bold px-2 py-1 rounded-full animate-pulse">
                                        {{ __('Low Stock') }}
                                    </span>
                                </div>
                            @endif
                            @if($product->is_approved)
                                <div class="absolute bottom-2 right-2">
                                    <span class="bg-green-500 text-white text-xs font-bold px-1 py-0.5 rounded-full">
                                        <svg class="w-3 h-3 inline" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                        </svg>
                                    </span>
                                </div>
                            @endif
                        </div>
                        <div class="p-4">
                            <h3 class="text-base font-bold text-gray-900 mb-2 group-hover:text-purple-600 transition-colors duration-300">
                                {{ $product->name }}
                            </h3>
                            <p class="text-gray-600 text-xs mb-3 leading-relaxed">
                                {{ Str::limit($product->description, 60) }}
                            </p>
                            <div class="flex items-center justify-between mb-3">
                                @if($product->hasDiscount())
                                    <div class="flex items-center space-x-1">
                                        <span class="text-lg font-bold text-gray-900">
                                            ${{ number_format($product->discounted_price, 2) }}
                                        </span>
                                        <span class="text-sm text-gray-400 line-through">
                                            ${{ number_format($product->price, 2) }}
                                        </span>
                                        <span class="text-xs text-red-500 font-semibold">
                                            {{ $product->discount_percentage }}% OFF
                                        </span>
                                    </div>
                                @else
                                    <span class="text-lg font-bold text-gray-900">
                                        ${{ number_format($product->price, 2) }}
                                    </span>
                                @endif
                                <span class="text-xs text-gray-500">
                                    Stock: {{ $product->stock }}
                                </span>
                            </div>
                            <a href="{{ route('products.show', $product) }}"
                               class="block w-full text-center bg-gradient-to-r from-purple-600 to-pink-600 hover:from-purple-700 hover:to-pink-700 text-white font-semibold py-2 px-4 rounded-lg transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg text-sm">
                                {{ __('View Details') }}
                            </a>
                        </div>
                    </div>
                @empty
                    <div class="col-span-4 text-center py-12">
                        <div class="mx-auto w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mb-4">
                            <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-2">{{ __('No Products Found') }}</h3>
                        <p class="text-gray-600 mb-6 text-sm">{{ __('Try adjusting your search or filter criteria to find what you\'re looking for.') }}</p>
                        <a href="{{ route('home') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white font-semibold rounded-lg hover:bg-blue-700 transition-colors duration-300 text-sm">
                            {{ __('View All Products') }}
                        </a>
                    </div>
                @endforelse
            </div>

            <!-- Pagination - Compact -->
            @if($products->hasPages())
                <div class="mt-8 flex justify-center">
                    <div class="bg-white rounded-lg shadow-md p-3">
                        {{ $products->links() }}
                    </div>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>
