<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <!-- Basic SEO Meta Tags -->
        <title>@yield('title', config('app.name')) | {{ config('app.name') }}</title>
        <meta name="description" content="@yield('meta_description', isset($meta_description) ? $meta_description : 'Discover authentic luxury brands, exclusive products, and premium shopping experience at ' . config('app.name') . '. Shop the worlds best designer items with fast delivery and secure checkout.')">
        <meta name="keywords" content="@yield('meta_keywords', 'luxury products, designer items, premium shopping, authentic brands')">
        <meta name="author" content="{{ config('app.name') }}">
        <meta name="robots" content="@yield('robots', 'index, follow')">

        <!-- Canonical URL -->
        <link rel="canonical" href="@yield('canonical_url', url()->current())">

        <!-- Open Graph Meta Tags -->
        <meta property="og:title" content="@yield('og_title', config('app.name'))">
        <meta property="og:description" content="@yield('og_description', 'Discover authentic luxury brands, exclusive products, and premium shopping experience at ' . config('app.name'))">
        <meta property="og:type" content="@yield('og_type', 'website')">
        <meta property="og:url" content="@yield('og_url', url()->current())">
        <meta property="og:image" content="@yield('og_image', asset('logo/logo.png'))">
        <meta property="og:site_name" content="{{ config('app.name') }}">
        <meta property="og:locale" content="{{ app()->getLocale() }}">

        <!-- Twitter Card Meta Tags -->
        <meta name="twitter:card" content="@yield('twitter_card', 'summary_large_image')">
        <meta name="twitter:title" content="@yield('twitter_title', config('app.name'))">
        <meta name="twitter:description" content="@yield('twitter_description', 'Discover authentic luxury brands, exclusive products, and premium shopping experience at ' . config('app.name'))">
        <meta name="twitter:image" content="@yield('twitter_image', asset('logo/logo.png'))">
        <meta name="twitter:site" content="@{{ config('app.name') }}">

        <!-- Additional SEO Meta Tags -->
        <meta name="theme-color" content="#3B82F6">
        <meta name="msapplication-TileColor" content="#3B82F6">
        <meta name="apple-mobile-web-app-capable" content="yes">
        <meta name="apple-mobile-web-app-status-bar-style" content="default">
        <meta name="apple-mobile-web-app-title" content="{{ config('app.name') }}">

        <!-- Preconnect to external domains for performance -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link rel="preconnect" href="https://maps.googleapis.com">
        <link rel="dns-prefetch" href="//fonts.bunny.net">
        <link rel="dns-prefetch" href="//maps.googleapis.com">

        <!-- Schema.org Structured Data -->
        @yield('schema_markup')

        <!-- Google Maps API (async defer) -->
        <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_GOOGLE_MAPS_API_KEY" async defer></script>

        <!-- Fonts -->
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Font Awesome -->
        <link rel="stylesheet" href="{{ asset('global/css/all.min.css') }}">

        <link rel="stylesheet" href="{{ asset('site/css/global.css') }}">

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])

        <!-- Favicon -->
        <link rel="icon" type="image/x-icon" href="{{ asset('logo/header.png') }}">
    </head>
    <body class="font-sans antialiased">
        <div class="min-h-screen bg-gray-100">
            <nav class="bg-white border-b border-gray-100">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <div class="flex justify-between h-16">
                        <div class="flex">
                            <!-- Logo -->
                            <div class="flex items-center">
                                <a href="{{ route('home') }}">
                                    <img src="{{ asset('logo/header.png') }}" alt="Logo" class="h-12 md:h-16 lg:h-20 w-auto">
                                </a>
                            </div>

                            <!-- Desktop Navigation Links -->
                            <div class="hidden lg:flex space-x-8 ml-10">
                                <x-nav-link :href="route('home')" :active="request()->routeIs('home')">
                                    {{ __('Home') }}
                                </x-nav-link>
                                <x-nav-link :href="route('products.index')" :active="request()->routeIs('products.*')">
                                    {{ __('Products') }}
                                </x-nav-link>
                                <x-nav-link :href="route('contact')" :active="request()->routeIs('contact')">
                                    {{ __('Contact') }}
                                </x-nav-link>
                                <x-nav-link :href="route('cooperation')">
                                    Cooperation With Us
                                </x-nav-link>
                                @php
                                    $headerPages = \App\Models\Page::where('is_active', 1)->orderBy('sort_order')->get();
                                @endphp
                                @foreach($headerPages as $page)
                                    <x-nav-link :href="route('pages.show.public', $page->slug)" :active="request()->routeIs('pages.show.public') && request()->route('slug') == $page->slug">
                                        {{ $page->title }}
                                    </x-nav-link>
                                @endforeach
                            </div>
                        </div>

                        <!-- Desktop Right Side -->
                        <div class="hidden lg:flex lg:items-center lg:ml-6">
                            <!-- Language Switcher -->
                            <div class="ml-3 relative">
                                <x-dropdown align="right" width="48">
                                    <x-slot name="trigger">
                                        <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 bg-white hover:text-gray-700 focus:outline-none transition ease-in-out duration-150">
                                            <div>{{ strtoupper(app()->getLocale()) }}</div>
                                            <div class="ml-1">
                                                <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                                </svg>
                                            </div>
                                        </button>
                                    </x-slot>

                                    <x-slot name="content">
                                        <x-dropdown-link :href="route('language.switch', 'en')">
                                            English
                                        </x-dropdown-link>
                                        <x-dropdown-link :href="route('language.switch', 'ar')">
                                            Arabic
                                        </x-dropdown-link>
                                    </x-slot>
                                </x-dropdown>
                            </div>

                            <!-- Shopping Cart -->
                            <div class="ml-3 relative">
                                <a href="{{ route('cart.index') }}" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 bg-white hover:text-gray-700 focus:outline-none transition ease-in-out duration-150">
                                    <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                                    </svg>
                                    <span class="ml-1">{{ \App\Models\Cart::count() }}</span>
                                </a>
                            </div>

                            <!-- Settings Dropdown -->
                            <div class="ml-3 relative">
                                @auth
                                    <x-dropdown align="right" width="48">
                                        <x-slot name="trigger">
                                            <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 bg-white hover:text-gray-700 focus:outline-none transition ease-in-out duration-150">
                                                <div>{{ Auth::user()->name }}</div>

                                                <div class="ml-1">
                                                    <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                                    </svg>
                                                </div>
                                            </button>
                                        </x-slot>

                                        <x-slot name="content">
                                            <x-dropdown-link :href="route('profile.edit')">
                                                {{ __('Profile') }}
                                            </x-dropdown-link>
                                            <x-dropdown-link :href="route('dashboard')">
                                                {{ __('Dashboard') }}
                                            </x-dropdown-link>
                                            <!-- Authentication -->
                                            <form method="POST" action="{{ route('logout') }}">
                                                @csrf
                                                <x-dropdown-link :href="route('logout')"
                                                        onclick="event.preventDefault();
                                                                    this.closest('form').submit();">
                                                    {{ __('Log Out') }}
                                                </x-dropdown-link>
                                            </form>
                                        </x-slot>
                                    </x-dropdown>
                                @else
                                    <a href="{{ route('login') }}" class="text-sm text-gray-700 underline">{{ __('Log in') }}</a>
                                    <a href="{{ route('register') }}" class="ml-4 text-sm text-gray-700 underline">{{ __('Register') }}</a>
                                @endauth
                            </div>
                        </div>

                        <!-- Mobile menu button -->
                        <div class="lg:hidden flex items-center">
                            <button id="mobile-menu-button" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-blue-500">
                                <span class="sr-only">Open main menu</span>
                                <svg class="block h-6 w-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Mobile menu -->
                <div id="mobile-menu" class="lg:hidden hidden">
                    <div class="px-2 pt-2 pb-3 space-y-1 sm:px-3 bg-white border-t border-gray-200">
                        <a href="{{ route('home') }}" class="block px-3 py-2 rounded-md text-base font-medium {{ request()->routeIs('home') ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50' }}">
                            {{ __('Home') }}
                        </a>
                        <a href="{{ route('products.index') }}" class="block px-3 py-2 rounded-md text-base font-medium {{ request()->routeIs('products.*') ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50' }}">
                            {{ __('Products') }}
                        </a>
                        <a href="{{ route('contact') }}" class="block px-3 py-2 rounded-md text-base font-medium {{ request()->routeIs('contact') ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50' }}">
                            {{ __('Contact') }}
                        </a>
                        <a href="{{ route('cooperation') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:text-gray-900 hover:bg-gray-50">
                            Cooperation With Us
                        </a>
                        @foreach($headerPages as $page)
                            <a href="{{ route('pages.show.public', $page->slug) }}" class="block px-3 py-2 rounded-md text-base font-medium {{ request()->routeIs('pages.show.public') && request()->route('slug') == $page->slug ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50' }}">
                                {{ $page->title }}
                            </a>
                        @endforeach
                    </div>

                    <!-- Mobile menu bottom section -->
                    <div class="pt-4 pb-3 border-t border-gray-200">
                        <div class="flex items-center px-4">
                            <!-- Mobile Cart -->
                            <a href="{{ route('cart.index') }}" class="flex items-center px-3 py-2 text-base font-medium text-gray-700 hover:text-gray-900">
                                <svg class="h-6 w-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                                </svg>
                                {{ __('Cart') }} ({{ \App\Models\Cart::count() }})
                            </a>
                        </div>

                        @auth
                            <div class="mt-3 space-y-1">
                                <a href="{{ route('profile.edit') }}" class="block px-4 py-2 text-base font-medium text-gray-500 hover:text-gray-800 hover:bg-gray-100">
                                    {{ __('Profile') }}
                                </a>
                                <a href="{{ route('dashboard') }}" class="block px-4 py-2 text-base font-medium text-gray-500 hover:text-gray-800 hover:bg-gray-100">
                                    {{ __('Dashboard') }}
                                </a>
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <button type="submit" class="block w-full text-left px-4 py-2 text-base font-medium text-gray-500 hover:text-gray-800 hover:bg-gray-100">
                                        {{ __('Log Out') }}
                                    </button>
                                </form>
                            </div>
                        @else
                            <div class="mt-3 space-y-1">
                                <a href="{{ route('login') }}" class="block px-4 py-2 text-base font-medium text-gray-500 hover:text-gray-800 hover:bg-gray-100">
                                    {{ __('Log in') }}
                                </a>
                                <a href="{{ route('register') }}" class="block px-4 py-2 text-base font-medium text-gray-500 hover:text-gray-800 hover:bg-gray-100">
                                    {{ __('Register') }}
                                </a>
                            </div>
                        @endauth

                        <!-- Mobile Language Switcher -->
                        <div class="mt-3 pt-3 border-t border-gray-200">
                            <div class="px-4">
                                <label class="text-sm font-medium text-gray-500">{{ __('Language') }}</label>
                                <div class="mt-2 space-y-1">
                                    <a href="{{ route('language.switch', 'en') }}" class="block px-3 py-2 text-base font-medium text-gray-500 hover:text-gray-800 hover:bg-gray-100 rounded-md">
                                        English
                                    </a>
                                    <a href="{{ route('language.switch', 'ar') }}" class="block px-3 py-2 text-base font-medium text-gray-500 hover:text-gray-800 hover:bg-gray-100 rounded-md">
                                        Arabic
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>

            <!-- Page Heading -->
            @if (isset($header))
                <header class="bg-white shadow">
                    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                        {{ $header }}
                    </div>
                </header>
            @endif

            <!-- Page Content -->
            <main>
                {{ $slot }}
            </main>
        </div>
        @include('layouts.footer')
        @include('layouts.scripts')
        @stack('scripts')

        <!-- Mobile Menu JavaScript -->
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const mobileMenuButton = document.getElementById('mobile-menu-button');
                const mobileMenu = document.getElementById('mobile-menu');

                mobileMenuButton.addEventListener('click', function() {
                    mobileMenu.classList.toggle('hidden');
                });

                // Close mobile menu when clicking outside
                document.addEventListener('click', function(event) {
                    if (!mobileMenuButton.contains(event.target) && !mobileMenu.contains(event.target)) {
                        mobileMenu.classList.add('hidden');
                    }
                });

                // Close mobile menu on window resize
                window.addEventListener('resize', function() {
                    if (window.innerWidth >= 1024) { // lg breakpoint
                        mobileMenu.classList.add('hidden');
                    }
                });
            });
        </script>

        <!-- Chat Icon Floating Button -->
        <div id="chat-fab" onclick="toggleChat()" class="fixed right-6 bottom-6 z-[9999] bg-blue-600 text-white rounded-full w-16 h-16 shadow-lg flex items-center justify-center cursor-pointer text-2xl transition hover:bg-blue-700 hover:scale-110 group" style="position:fixed;">
            <svg width="32" height="32" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
            </svg>
            <span id="chat-unread-badge" class="hidden absolute -top-2 -right-2 bg-red-500 text-white rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold z-[10001] shadow-md"></span>
        </div>

        <div id="chat-popup" class="hidden fixed right-6 bottom-28 w-[400px] h-[500px] max-w-[95vw] bg-white rounded-2xl shadow-2xl z-[10000] overflow-hidden">
            <button class="absolute top-1 right-2 bg-red-500 text-white rounded-full w-8 h-8 flex items-center justify-center text-lg font-bold z-[10001] hover:bg-red-600 transition" onclick="toggleChat()">×</button>
            <div class="h-full" id="chat-body-container">
                <!-- iframe only added when open -->
            </div>
        </div>

        <script>
        function toggleChat() {
            const popup = document.getElementById('chat-popup');
            const body = document.getElementById('chat-body-container');
            if (!popup.classList.contains('hidden')) {
                // بستن: iframe را حذف کن
                body.innerHTML = '';
                popup.classList.add('hidden');
            } else {
                // باز کردن: iframe را اضافه کن
                body.innerHTML = '<iframe src="{{ route('chat.user') }}" class="w-full h-full border-0"></iframe>';
                popup.classList.remove('hidden');
            }
        }

        // --- Unread badge logic ---
        @auth
        function fetchUnreadCount() {
            const badge = document.getElementById('chat-unread-badge');
            const chatFab = document.getElementById('chat-fab');
            if (!badge || !chatFab || chatFab.offsetParent === null) return; // اگر المنت یا دکمه چت مخفی بود تلاش نکن
            fetch("{{ url('/chat/unread-count') }}", {
                headers: { 'X-Requested-With': 'XMLHttpRequest' }
            })
            .then(res => {
                if (!res.ok) return { unread: 0 };
                return res.json();
            })
            .then(data => {
                if (data.unread > 0) {
                    badge.textContent = data.unread > 99 ? '99+' : data.unread;
                    badge.classList.remove('hidden');
                    badge.classList.add('animate-bounce');
                } else {
                    badge.classList.add('hidden');
                    badge.classList.remove('animate-bounce');
                }
            })
            .catch(() => {/* هیچ کاری نکن */});
        }
        setInterval(fetchUnreadCount, 3000); // هر ۳ ثانیه
        fetchUnreadCount();
        @endauth
        </script>

        @php
            $unreadUserChats = Auth::check() ? \App\Http\Controllers\Controller::getTotalUnreadUserChats(Auth::id()) : 0;
        @endphp
        @if($unreadUserChats > 0)
            <div class="fixed right-6 bottom-28 z-[10000] bg-red-100 border-l-4 border-red-500 text-red-800 p-3 mb-2 rounded-lg flex items-center justify-between shadow-lg animate-bounce" style="min-width:220px; max-width:90vw;">
                <div class="flex items-center">
                    <svg class="w-6 h-6 mr-2 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M12 20a8 8 0 100-16 8 8 0 000 16z" />
                    </svg>
                    <span class="font-bold">{{ $unreadUserChats }} unread support message{{ $unreadUserChats > 1 ? 's' : '' }}</span>
                </div>
                <a href="{{ route('chat.user') }}" class="ml-3 bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded-lg font-bold transition">View Chat</a>
            </div>
        @endif
    </body>
</html>
