    <!-- Newsletter Section -->
    {{-- <div class="bg-gradient-to-r from-blue-600 to-purple-600">
        <div class="max-w-7xl mx-auto py-8 px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-xl md:text-2xl font-bold text-white mb-2">
                {{ __('Stay Updated with Latest Deals') }}
            </h2>
            <p class="text-sm md:text-base text-blue-100 mb-4 max-w-lg mx-auto">
                {{ __('Enter your email to get notified about new products and exclusive offers.') }}
            </p>
            <form class="max-w-sm mx-auto flex flex-col sm:flex-row gap-2 sm:gap-3">
                <input type="email" placeholder="{{ __('Your Email') }}"
                       class="flex-1 px-4 py-2 rounded-lg border-0 text-gray-900 placeholder-gray-500 focus:ring-2 focus:ring-white/50 text-sm">
                <button type="submit" class="px-6 py-2 bg-white text-blue-600 font-semibold rounded-lg hover:bg-gray-100 transition-colors duration-300 text-sm">
                    {{ __('Subscribe') }}
                </button>
            </form>
        </div>
    </div> --}}

    <!-- Main Footer -->
    <footer class="bg-gray-900 text-white">
        <div class="max-w-7xl mx-auto py-12 px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- Company Info -->
                <div class="space-y-4">
                    <img src="{{ asset('logo/logo.png') }}" alt="{{ config('app.name') }}" class="h-12 w-auto">
                    <p class="text-gray-300 text-sm">
                        {{ __('Discover authentic luxury brands and premium shopping experience.') }}
                    </p>
                    <div class="mt-4 space-y-1 text-xs text-gray-300">
                        <div><span class="font-semibold">Phone:</span> {{ \App\Models\Setting::getValue('contact_phone', '-') }}</div>
                        <div class="flex space-x-3 mt-2">
                            <a href="{{ \App\Models\Setting::getValue('contact_telegram', '#') }}" class="hover:text-blue-400" target="_blank" title="Telegram">
                                <i class="fab fa-telegram-plane text-xl"></i>
                            </a>
                            <a href="{{ \App\Models\Setting::getValue('contact_instagram', '#') }}" class="hover:text-pink-400" target="_blank" title="Instagram">
                                <i class="fab fa-instagram text-xl"></i>
                            </a>
                            <a href="{{ \App\Models\Setting::getValue('contact_facebook', '#') }}" class="hover:text-blue-600" target="_blank" title="Facebook">
                                <i class="fab fa-facebook-f text-xl"></i>
                            </a>
                            <a href="{{ \App\Models\Setting::getValue('contact_twitter', '#') }}" class="hover:text-blue-300" target="_blank" title="Twitter">
                                <i class="fab fa-twitter text-xl"></i>
                            </a>
                            <a href="{{ \App\Models\Setting::getValue('contact_instagram', '#') }}" class="text-gray-400 hover:text-white transition-colors" target="_blank" rel="noopener">
                                <span class="sr-only">Instagram</span>
                                <svg class="h-6 w-6" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M12.017 0C5.396 0 .029 5.367.029 11.987c0 6.62 5.367 11.987 11.988 11.987 6.62 0 11.987-5.367 11.987-11.987C24.014 5.367 18.637.001 12.017.001zM8.449 16.988c-1.297 0-2.448-.49-3.323-1.297C4.198 14.895 3.708 13.744 3.708 12.447s.49-2.448 1.418-3.323c.875-.807 2.026-1.297 3.323-1.297s2.448.49 3.323 1.297c.928.875 1.418 2.026 1.418 3.323s-.49 2.448-1.418 3.244c-.875.807-2.026 1.297-3.323 1.297zm7.83-9.781c-.49 0-.928-.175-1.297-.49-.368-.315-.49-.753-.49-1.243 0-.49.122-.928.49-1.243.369-.315.807-.49 1.297-.49s.928.175 1.297.49c.368.315.49.753.49 1.243 0 .49-.122.928-.49 1.243-.369.315-.807.49-1.297.49z"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Quick Links -->
                <div class="space-y-4">
                    <h3 class="text-lg font-semibold">{{ __('Quick Links') }}</h3>
                    <ul class="space-y-2 text-sm">
                        <li><a href="{{ route('home') }}" class="text-gray-300 hover:text-white transition-colors">{{ __('Home') }}</a></li>
                        <li><a href="{{ route('products.index') }}" class="text-gray-300 hover:text-white transition-colors">{{ __('Products') }}</a></li>
                        @foreach(\App\Models\Page::where('is_active', 1)->where('show_in_menu', 1)->take(3)->get() as $page)
                            <li><a href="{{ route('pages.show.public', $page->slug) }}" class="text-gray-300 hover:text-white transition-colors">{{ $page->title }}</a></li>
                        @endforeach
                    </ul>
                </div>

                <!-- Customer Service -->
                <div class="space-y-4">
                    <h3 class="text-lg font-semibold">{{ __('Customer Service') }}</h3>
                    <ul class="space-y-2 text-sm">
                        <li><a href="/contact" class="text-gray-300 hover:text-white transition-colors">{{ __('Contact Us') }}</a></li>
                        <li><a href="/page/shipping" class="text-gray-300 hover:text-white transition-colors">{{ __('Shipping Info') }}</a></li>
                        <li><a href="#" class="text-gray-300 hover:text-white transition-colors">{{ __('Returns') }}</a></li>
                        <li><a href="#" class="text-gray-300 hover:text-white transition-colors">{{ __('FAQ') }}</a></li>
                    </ul>
                </div>

                <!-- Newsletter & Contact -->
                <div class="space-y-4">
                    <h3 class="text-lg font-semibold">{{ __('Stay Updated') }}</h3>
                    <p class="text-sm text-gray-300 mb-3">
                        {{ __('Get notified about new products and exclusive offers.') }}
                    </p>

                    @if(session('newsletter_success'))
                        <div class="bg-green-600 text-white px-3 py-2 rounded-md text-sm">
                            {{ session('newsletter_success') }}
                        </div>
                    @endif

                    @if($errors->has('email'))
                        <div class="bg-red-600 text-white px-3 py-2 rounded-md text-sm">
                            {{ $errors->first('email') }}
                        </div>
                    @endif

                    <form action="{{ route('newsletter.subscribe') }}" method="POST" class="space-y-2">
                        @csrf
                        <input type="email" name="email" placeholder="{{ __('Your Email') }}" required
                               class="w-full px-3 py-2 bg-gray-800 border border-gray-700 rounded-md text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent text-sm">
                        <button type="submit" class="w-full px-4 py-2 bg-blue-600 text-white font-medium rounded-md hover:bg-blue-700 transition-colors duration-300 text-sm">
                            {{ __('Subscribe') }}
                        </button>
                    </form>

                    <div class="pt-4 border-t border-gray-700">
                        <h4 class="text-sm font-medium mb-2">{{ __('Contact Info') }}</h4>
                        <div class="space-y-1 text-xs text-gray-300">
                            <p>{{ __('Email:') }} {{ \App\Models\Setting::getValue('contact_email', 'info@example.com') }}</p>
                            <p>{{ __('Phone:') }} {{ \App\Models\Setting::getValue('contact_phone', '+1 (555) 123-4567') }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Bottom Footer -->
            <div class="border-t border-gray-800 mt-12 pt-8">
                <div class="flex flex-col md:flex-row justify-between items-center space-y-4 md:space-y-0">
                    <p class="text-sm text-gray-400">
                        © {{ date('Y') }} {{ config('app.name') }}. {{ __('All rights reserved.') }}
                    </p>
                    <div class="flex space-x-6 text-sm">
                        <a href="#" class="text-gray-400 hover:text-white transition-colors">{{ __('Privacy Policy') }}</a>
                        <a href="#" class="text-gray-400 hover:text-white transition-colors">{{ __('Terms of Service') }}</a>
                        <a href="#" class="text-gray-400 hover:text-white transition-colors">{{ __('Cookie Policy') }}</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
