<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=inter:300,400,500,600,700&display=swap" rel="stylesheet" />
        <link href="{{asset('global/css/all.min.css')}}" rel="stylesheet">
        <link href="{{asset('site/css/global.css')}}" rel="stylesheet">

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-inter antialiased min-h-screen overflow-x-hidden">
        <!-- Background with animated gradients -->
        <div class="fixed inset-0 bg-gradient-to-br from-purple-900 via-blue-900 to-indigo-900">
            <!-- Animated background shapes -->
            <div class="absolute top-1/4 left-1/4 w-96 h-96 bg-purple-500/20 rounded-full blur-3xl float-animation"></div>
            <div class="absolute top-3/4 right-1/4 w-80 h-80 bg-pink-500/20 rounded-full blur-3xl float-animation" style="animation-delay: -2s;"></div>
            <div class="absolute bottom-1/4 left-1/3 w-72 h-72 bg-blue-500/20 rounded-full blur-3xl float-animation" style="animation-delay: -4s;"></div>

            <!-- Overlay -->
            <div class="absolute inset-0 bg-gradient-to-br from-purple-900/50 via-transparent to-blue-900/50"></div>
        </div>

        <div class="relative min-h-screen flex flex-col justify-center items-center px-4 sm:px-6 lg:px-8">
            <!-- Logo Section -->
            <div class="flex items-center justify-center mb-8 fade-in-up">
                <div class="relative">
                    <div class="absolute inset-0 bg-gradient-to-r from-purple-600 to-pink-600 rounded-3xl blur-lg opacity-75 pulse-glow"></div>
                    <div class="relative bg-white/10 backdrop-blur-lg rounded-3xl p-6 border border-white/20">
                        <a href="/" class="block">
                            <img src="{{asset('logo/royalux.jpg')}}"
                                 alt="Royalux Logo"
                                 class="w-24 h-24 object-cover rounded-2xl shadow-2xl transform hover:scale-105 transition-all duration-300">
                        </a>
                    </div>
                </div>
            </div>

            <!-- Welcome Text -->
            <div class="text-center mb-8 fade-in-up" style="animation-delay: 0.2s;">
                <h1 class="text-4xl md:text-5xl font-bold text-white mb-4">
                    <span class="bg-gradient-to-r from-yellow-400 via-pink-400 to-purple-400 bg-clip-text text-transparent">
                        Welcome
                    </span>
                </h1>
                <p class="text-lg text-purple-100/80 max-w-md mx-auto">
                    Please sign in to continue
                </p>
            </div>

            <!-- Main Card -->
            <div class="w-full max-w-md fade-in-up" style="animation-delay: 0.4s;">
                <div class="relative">
                    <!-- Card glow effect -->
                    <div class="absolute inset-0 bg-gradient-to-r from-purple-500 to-pink-500 rounded-2xl blur-xl opacity-20"></div>

                    <!-- Main card -->
                    <div class="relative bg-white/95 backdrop-blur-xl rounded-2xl shadow-2xl border border-white/20 overflow-hidden">
                        <!-- Card header with gradient -->
                        <div class="bg-gradient-to-r from-purple-600 to-pink-600 px-8 py-6">
                            <h2 class="text-xl font-semibold text-white text-center">
                                Sign In
                            </h2>
                        </div>

                        <!-- Card content -->
                        <div class="px-8 py-6">
                            {{ $slot }}
                        </div>

                        <!-- Card footer -->
                        <div class="bg-gray-50/50 px-8 py-4 border-t border-gray-200/50 text-center">
                            <p class="text-sm text-gray-600">
                                © {{ date('Y') }} {{ config('app.name') }}. All rights reserved.
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Additional decorative elements -->
            <div class="absolute top-10 left-10 w-20 h-20 border border-white/10 rounded-full"></div>
            <div class="absolute top-20 right-20 w-16 h-16 border border-purple-400/20 rounded-full"></div>
            <div class="absolute bottom-20 left-1/4 w-12 h-12 border border-pink-400/20 rounded-full"></div>
            <div class="absolute bottom-32 right-1/3 w-8 h-8 bg-yellow-400/20 rounded-full"></div>
        </div>

        <!-- Particles effect (optional) -->
        <div class="fixed inset-0 pointer-events-none overflow-hidden">
            @for($i = 0; $i < 10; $i++)
                <div class="absolute w-1 h-1 bg-white/30 rounded-full"
                     style="left: {{ rand(0, 100) }}%;
                            top: {{ rand(0, 100) }}%;
                            animation: float {{ rand(3, 8) }}s ease-in-out infinite {{ rand(0, 5) }}s;">
                </div>
            @endfor
        </div>
    </body>
</html>
