@section('title', 'My Orders')
@section('meta_description', 'List of your orders at ' . config('app.name') . '. View status, details, and track your orders easily.')

<x-app-layout>
    <x-slot name="header">
        <div class="bg-gradient-to-r from-purple-600 to-blue-600 -mx-8 -mt-8 px-8 pt-8 pb-6">
            <h2 class="font-black text-3xl text-white leading-tight">
                {{ __('My Orders') }}
            </h2>
            <p class="text-purple-100 mt-2">{{ __('Track and manage your orders') }}</p>
        </div>
    </x-slot>

    <div class="py-12 bg-gradient-to-br from-gray-50 to-blue-50 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if($orders->isEmpty())
                <!-- Empty State -->
                <div class="bg-white rounded-2xl shadow-xl overflow-hidden text-center py-20">
                    <div class="mx-auto w-32 h-32 bg-gradient-to-br from-purple-100 to-blue-100 rounded-full flex items-center justify-center mb-8">
                        <svg class="w-16 h-16 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                        </svg>
                    </div>
                    <h3 class="text-3xl font-bold text-gray-900 mb-4">{{ __('No Orders Yet') }}</h3>
                    <p class="text-gray-600 text-lg mb-8 max-w-md mx-auto">
                        {{ __('Start shopping to see your orders here. Discover amazing products waiting for you!') }}
                    </p>
                    <a href="{{ route('home') }}"
                       class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-purple-600 to-blue-600 text-white font-semibold rounded-xl hover:from-purple-700 hover:to-blue-700 transform hover:scale-105 transition-all duration-300 shadow-lg hover:shadow-xl">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                        </svg>
                        {{ __('Start Shopping') }}
                    </a>
                </div>
            @else
                <!-- Orders Grid -->
                <div class="space-y-6">
                    @foreach($orders as $order)
                        <div class="bg-white rounded-2xl shadow-xl overflow-hidden hover:shadow-2xl transform hover:-translate-y-1 transition-all duration-300 border border-gray-100">
                            <!-- Order Header -->
                            <div class="bg-gradient-to-r from-gray-50 to-blue-50 px-8 py-6 border-b border-gray-200">
                                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                                    <div class="flex items-center space-x-4 mb-4 lg:mb-0">
                                        <div class="bg-gradient-to-br from-purple-500 to-blue-500 text-white rounded-xl p-3">
                                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                                            </svg>
                                        </div>
                                        <div>
                                            <h3 class="text-2xl font-bold text-gray-900">
                                                {{ __('Order') }} #{{ $order->id }}
                                            </h3>
                                            <p class="text-gray-600">
                                                {{ $order->created_at->format('M d, Y \a\t H:i') }}
                                            </p>
                                        </div>
                                    </div>
                                    <div class="flex items-center space-x-4">
                                        <span class="px-4 py-2 rounded-full text-sm font-semibold
                                            {{ $order->status === 'completed' ? 'bg-green-100 text-green-800' :
                                               ($order->status === 'pending' ? 'bg-yellow-100 text-yellow-800' :
                                               ($order->status === 'processing' ? 'bg-blue-100 text-blue-800' :
                                               'bg-red-100 text-red-800')) }}">
                                            @if($order->status === 'completed')
                                                <svg class="w-4 h-4 inline mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                                </svg>
                                            @elseif($order->status === 'pending')
                                                <svg class="w-4 h-4 inline mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"/>
                                                </svg>
                                            @elseif($order->status === 'processing')
                                                <svg class="w-4 h-4 inline mr-1 animate-spin" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M4 2a2 2 0 00-2 2v6a2 2 0 002 2h12a2 2 0 002-2V4a2 2 0 00-2-2H4z"/>
                                                </svg>
                                            @endif
                                            {{ ucfirst($order->status) }}
                                        </span>
                                        <span class="text-3xl font-black text-gray-900">
                                            ${{ number_format($order->total_amount, 2) }}
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <!-- Order Details -->
                            <div class="px-8 py-6">
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                                    <div class="flex items-center space-x-3">
                                        <div class="bg-blue-100 text-blue-600 rounded-lg p-2">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
                                            </svg>
                                        </div>
                                        <div>
                                            <p class="text-sm text-gray-500">{{ __('Payment Method') }}</p>
                                            <p class="font-semibold text-gray-900">{{ ucfirst($order->payment_method) }}</p>
                                        </div>
                                    </div>

                                    <div class="flex items-center space-x-3">
                                        <div class="bg-green-100 text-green-600 rounded-lg p-2">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                            </svg>
                                        </div>
                                        <div>
                                            <p class="text-sm text-gray-500">{{ __('Delivery Status') }}</p>
                                            <p class="font-semibold text-gray-900">
                                                @if($order->status === 'completed')
                                                    {{ __('Delivered') }}
                                                @elseif($order->status === 'processing')
                                                    {{ __('In Transit') }}
                                                @else
                                                    {{ __('Preparing') }}
                                                @endif
                                            </p>
                                        </div>
                                    </div>

                                    <div class="flex items-center space-x-3">
                                        <div class="bg-purple-100 text-purple-600 rounded-lg p-2">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                                            </svg>
                                        </div>
                                        <div>
                                            <p class="text-sm text-gray-500">{{ __('Items') }}</p>
                                            <p class="font-semibold text-gray-900">{{ $order->items->count() ?? 0 }} {{ __('Products') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <!-- Order Actions -->
                                <div class="flex flex-col sm:flex-row gap-4 pt-6 border-t border-gray-200">
                                    <a href="{{ route('orders.show', $order) }}"
                                       class="flex-1 inline-flex items-center justify-center px-6 py-3 bg-gradient-to-r from-purple-600 to-blue-600 text-white font-semibold rounded-xl hover:from-purple-700 hover:to-blue-700 transform hover:scale-105 transition-all duration-300 shadow-lg hover:shadow-xl">
                                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                        </svg>
                                        {{ __('View Details') }}
                                    </a>

                                    @if($order->status === 'completed')
                                        <button class="flex-1 inline-flex items-center justify-center px-6 py-3 bg-gradient-to-r from-green-500 to-emerald-600 text-white font-semibold rounded-xl hover:from-green-600 hover:to-emerald-700 transform hover:scale-105 transition-all duration-300 shadow-lg hover:shadow-xl">
                                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                                            </svg>
                                            {{ __('Reorder') }}
                                        </button>
                                    @endif

                                    <button class="flex-1 inline-flex items-center justify-center px-6 py-3 bg-white border-2 border-gray-300 text-gray-700 font-semibold rounded-xl hover:border-gray-400 hover:bg-gray-50 transform hover:scale-105 transition-all duration-300">
                                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-1l-4 4z"/>
                                        </svg>
                                        {{ __('Contact Support') }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Pagination -->
                @if($orders->hasPages())
                    <div class="mt-12 flex justify-center">
                        <div class="bg-white rounded-2xl shadow-lg p-6">
                            {{ $orders->links() }}
                        </div>
                    </div>
                @endif
            @endif
        </div>
    </div>

    <style>
        .hover\:scale-105:hover {
            transform: scale(1.05);
        }

        .transition-all {
            transition-property: all;
            transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
            transition-duration: 300ms;
        }
    </style>
</x-app-layout>
