@section('title', 'Invoice')
@section('meta_description', 'View and print your invoice for your order at ' . config('app.name') . '. Includes all order details and payment status.')
<x-app-layout>
    <div class="min-h-screen bg-gray-50 py-8">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Invoice Header -->
            <div class="bg-gradient-to-r from-blue-600 to-purple-600 text-white rounded-lg p-8 mb-8 text-center">
                <h1 class="text-4xl font-bold mb-2">INVOICE</h1>
                <p class="text-xl opacity-90">{{ $invoiceData['invoice_number'] }}</p>
            </div>

            <!-- Invoice Details -->
            <div class="bg-white rounded-lg shadow-lg p-8 mb-8">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8">
                    <!-- Bill To -->
                    <div>
                        <h3 class="text-lg font-semibold text-blue-600 border-b-2 border-blue-600 pb-2 mb-4">
                            Bill To
                        </h3>
                        <div class="space-y-2">
                            <p class="font-medium">{{ $invoiceData['order']->first_name }} {{ $invoiceData['order']->last_name }}</p>
                            <p class="text-gray-600">{{ $invoiceData['order']->email }}</p>
                            <p class="text-gray-600">{{ $invoiceData['order']->phone }}</p>
                            <p class="text-gray-600">{{ $invoiceData['order']->shipping_address }}</p>
                            <p class="text-gray-600">{{ $invoiceData['order']->city }}, {{ $invoiceData['order']->country }}</p>
                        </div>
                    </div>

                    <!-- Invoice Details -->
                    <div>
                        <h3 class="text-lg font-semibold text-blue-600 border-b-2 border-blue-600 pb-2 mb-4">
                            Invoice Details
                        </h3>
                        <div class="space-y-2">
                            <p><span class="font-medium">Invoice Number:</span> {{ $invoiceData['invoice_number'] }}</p>
                            <p><span class="font-medium">Order Number:</span> #{{ $invoiceData['order']->id }}</p>
                            <p><span class="font-medium">Issue Date:</span> {{ $invoiceData['issue_date'] }}</p>
                            <p><span class="font-medium">Due Date:</span> {{ $invoiceData['due_date'] }}</p>
                            <p><span class="font-medium">Payment Method:</span> {{ ucfirst($invoiceData['order']->payment_method) }}</p>
                            <p><span class="font-medium">Status:</span>
                                <span class="inline-block px-3 py-1 text-xs font-semibold rounded-full
                                    {{ $invoiceData['order']->status === 'paid' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                    {{ ucfirst($invoiceData['order']->status) }}
                                </span>
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Items Table -->
                <div class="overflow-x-auto">
                    <table class="w-full border-collapse bg-white rounded-lg overflow-hidden shadow-lg">
                        <thead class="bg-blue-600 text-white">
                            <tr>
                                <th class="px-6 py-4 text-left font-semibold">Item</th>
                                <th class="px-6 py-4 text-left font-semibold">Description</th>
                                <th class="px-6 py-4 text-left font-semibold">Quantity</th>
                                <th class="px-6 py-4 text-left font-semibold">Unit Price</th>
                                <th class="px-6 py-4 text-left font-semibold">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($invoiceData['order_items'] as $item)
                            <tr class="border-b border-gray-200 hover:bg-gray-50">
                                <td class="px-6 py-4">
                                    <div class="flex items-center space-x-3">
                                        @if($item->product->image)
                                            <img src="{{ asset('products/' . $item->product->image) }}"
                                                 alt="{{ $item->product->name }}"
                                                 class="w-12 h-12 object-cover rounded">
                                        @endif
                                        <div>
                                            <p class="font-medium">{{ $item->product->name }}</p>
                                            <p class="text-sm text-gray-500">SKU: {{ $item->product->id }}</p>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <p class="text-gray-700">{{ Str::limit($item->product->description, 50) }}</p>
                                    @if($item->dynamic_selections)
                                        <p class="text-sm text-gray-500 mt-1">
                                            Options: {{ json_encode($item->dynamic_selections) }}
                                        </p>
                                    @endif
                                </td>
                                <td class="px-6 py-4 font-medium">{{ $item->quantity }}</td>
                                <td class="px-6 py-4">${{ number_format($item->price, 2) }}</td>
                                <td class="px-6 py-4 font-medium">${{ number_format($item->price * $item->quantity, 2) }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Totals -->
            <div class="bg-white rounded-lg shadow-lg p-8 mb-8">
                <div class="max-w-md ml-auto space-y-4">
                    <div class="flex justify-between py-2 border-b border-gray-200">
                        <span class="font-medium">Subtotal:</span>
                        <span>${{ number_format($invoiceData['subtotal'], 2) }}</span>
                    </div>
                    <div class="flex justify-between py-2 border-b border-gray-200">
                        <span class="font-medium">Tax (8%):</span>
                        <span>${{ number_format($invoiceData['tax'], 2) }}</span>
                    </div>
                    <div class="flex justify-between py-2 text-lg font-bold text-blue-600">
                        <span>Total:</span>
                        <span>${{ number_format($invoiceData['total'], 2) }}</span>
                    </div>
                </div>
            </div>

            @if($invoiceData['order']->order_notes)
            <div class="bg-white rounded-lg shadow-lg p-8 mb-8">
                <h3 class="text-lg font-semibold text-blue-600 border-b-2 border-blue-600 pb-2 mb-4">
                    Order Notes
                </h3>
                <p class="text-gray-700">{{ $invoiceData['order']->order_notes }}</p>
            </div>
            @endif

            <!-- Action Buttons -->
            <div class="bg-white rounded-lg shadow-lg p-8 mb-8">
                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="{{ route('orders.show', $invoiceData['order']->id) }}"
                       class="inline-flex items-center px-6 py-3 bg-blue-600 text-white font-semibold rounded-lg hover:bg-blue-700 transition-colors">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        View Order Details
                    </a>

                    <button onclick="window.print()"
                            class="inline-flex items-center px-6 py-3 bg-green-600 text-white font-semibold rounded-lg hover:bg-green-700 transition-colors">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                        </svg>
                        Print Invoice
                    </button>

                    <a href="{{ route('dashboard') }}"
                       class="inline-flex items-center px-6 py-3 bg-gray-600 text-white font-semibold rounded-lg hover:bg-gray-700 transition-colors">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                        </svg>
                        Back to Dashboard
                    </a>
                </div>
            </div>

            <!-- Footer -->
            <div class="bg-white rounded-lg shadow-lg p-8 text-center">
                <p class="text-lg font-semibold text-gray-800 mb-2">Thank you for your business!</p>
                <p class="text-gray-600 mb-2">If you have any questions about this invoice, please contact our support team.</p>
                <p class="text-gray-600 mb-4">Payment is due within 30 days of the invoice date.</p>
                <p class="text-sm text-gray-500">© {{ date('Y') }} Amazoon. All rights reserved.</p>
            </div>
        </div>
    </div>

    <!-- Print Styles -->
    <style>
        @media print {
            body { margin: 0; }
            .max-w-4xl { max-width: none; }
            .bg-gray-50 { background: white; }
            .shadow-lg { box-shadow: none; }
            .rounded-lg { border-radius: 0; }
            .py-8 { padding: 0; }
            .mb-8 { margin-bottom: 20px; }
            .px-4 { padding-left: 0; padding-right: 0; }
            .sm\:px-6 { padding-left: 0; padding-right: 0; }
            .lg\:px-8 { padding-left: 0; padding-right: 0; }
        }
        .status-paid {
            background-color: #d4edda;
            color: #155724;
        }
        .status-pending {
            background-color: #fff3cd;
            color: #856404;
        }
        .status-failed {
            background-color: #f8d7da;
            color: #721c24;
        }
        .status-cancelled {
            background-color: #e2e3e5;
            color: #383d41;
        }
        .status-completed {
            background-color: #d1ecf1;
            color: #0c5460;
        }
    </style>
</x-app-layout>
