<x-app-layout>
    @section('title', $page->meta_title ?: $page->title)
    @section('meta_description', $page->meta_description ?? Str::limit(strip_tags($page->content), 150))
    @section('meta_keywords', $page->meta_keywords)
    @section('canonical', $page->canonical_url ?: url()->current())
    @section('og_title', $page->og_title ?: $page->meta_title ?: $page->title)
    @section('og_description', $page->og_description ?: $page->meta_description ?: Str::limit(strip_tags($page->content), 160))
    @section('og_image', $page->og_image)
    @section('og_type', 'article')
    @section('og_url', $page->canonical_url ?: url()->current())
    @section('twitter_card', 'summary_large_image')
    @section('twitter_title', $page->twitter_title ?: $page->meta_title ?: $page->title)
    @section('twitter_description', $page->twitter_description ?: $page->meta_description ?: Str::limit(strip_tags($page->content), 160))
    @section('twitter_image', $page->twitter_image ?: $page->og_image)
    @section('robots', $page->robots_directive ?: 'index,follow')

    <!-- Structured Data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebPage",
        "name": "{{ $page->title }}",
        "description": "{{ $page->meta_description ?: Str::limit(strip_tags($page->content), 160) }}",
        "url": "{{ $page->canonical_url ?: url()->current() }}",
        "mainEntity": {
            "@type": "Article",
            "headline": "{{ $page->title }}",
            "description": "{{ $page->meta_description ?: Str::limit(strip_tags($page->content), 160) }}",
            "author": {
                "@type": "Organization",
                "name": "{{ config('app.name') }}"
            },
            "publisher": {
                "@type": "Organization",
                "name": "{{ config('app.name') }}",
                "logo": {
                    "@type": "ImageObject",
                    "url": "{{ asset('logo/logo.png') }}"
                }
            },
            "datePublished": "{{ $page->created_at?->toISOString() }}",
            "dateModified": "{{ $page->updated_at?->toISOString() }}",
            "image": "{{ $page->og_image ?: asset('logo/logo.png') }}"
        },
        "breadcrumb": {
            "@type": "BreadcrumbList",
            "itemListElement": [
                {
                    "@type": "ListItem",
                    "position": 1,
                    "name": "Home",
                    "item": "{{ route('home') }}"
                },
                {
                    "@type": "ListItem",
                    "position": 2,
                    "name": "{{ $page->title }}",
                    "item": "{{ url()->current() }}"
                }
            ]
        }
    }
    </script>

    <div class="bg-gradient-to-r from-blue-600 to-purple-600 py-12 mb-8 shadow-lg">
        <div class="container mx-auto px-4">
            <h1 class="text-4xl md:text-5xl font-extrabold text-white text-center drop-shadow-lg">{{ $page->title }}</h1>
        </div>
    </div>
    <div class="container mx-auto px-4">
        <div class="max-w-3xl mx-auto bg-white rounded-2xl shadow-2xl p-8 mb-12">
            <div class="prose prose-lg max-w-none text-gray-800">
                {!! $page->content !!}
            </div>
        </div>
    </div>
</x-app-layout>
