<x-app-layout>
    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="max-w-2xl mx-auto">
                        <div class="text-center mb-8">
                            <h2 class="text-2xl font-bold text-gray-900 mb-2">Complete Your Crypto Payment</h2>
                            <p class="text-gray-600">Please send the exact amount to the address below</p>
                        </div>

                        <div class="bg-gray-50 rounded-lg p-6 mb-6">
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Payment Amount (USD)</label>
                                    <div class="flex items-center justify-between bg-white p-3 rounded-lg border border-gray-200">
                                        <span class="text-lg font-semibold">${{ number_format(session('crypto_payment.amount') / 100, 2) }}</span>
                                        <button onclick="copyToClipboard('{{ session('crypto_payment.amount') / 100 }}')" class="text-blue-600 hover:text-blue-800">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3"/>
                                            </svg>
                                        </button>
                                    </div>
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Payment Amount (BTC)</label>
                                    <div class="flex items-center justify-between bg-white p-3 rounded-lg border border-gray-200">
                                        <span class="text-lg font-semibold">{{ session('crypto_payment.amount') }} {{ strtoupper(session('crypto_payment.currency')) }}</span>
                                        <button onclick="copyToClipboard('{{ session('crypto_payment.amount') }} {{ strtoupper(session('crypto_payment.currency')) }}')" class="text-blue-600 hover:text-blue-800">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3"/>
                                            </svg>
                                        </button>
                                    </div>
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Payment Address</label>
                                    <div class="flex items-center justify-between bg-white p-3 rounded-lg border border-gray-200">
                                        <span class="font-mono text-sm break-all">{{ session('crypto_payment.address') }}</span>
                                        <button onclick="copyToClipboard('{{ session('crypto_payment.address') }}')" class="text-blue-600 hover:text-blue-800 ml-2">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3"/>
                                            </svg>
                                        </button>
                                    </div>
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Payment Status</label>
                                    <div class="flex items-center justify-between bg-white p-3 rounded-lg border border-gray-200">
                                        <span class="text-lg font-semibold capitalize">{{ session('crypto_payment.payment_status') }}</span>
                                        <div class="ml-2">
                                            @if(session('crypto_payment.payment_status') === 'waiting')
                                                <div class="animate-spin rounded-full h-5 w-5 border-b-2 border-blue-600"></div>
                                            @elseif(session('crypto_payment.payment_status') === 'confirmed')
                                                <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                                </svg>
                                            @elseif(session('crypto_payment.payment_status') === 'failed')
                                                <svg class="w-5 h-5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                                </svg>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 mb-6">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-yellow-400" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <p class="text-sm text-yellow-700">
                                        Please make sure to send the exact amount. The payment will be confirmed automatically once received.
                                        <br>
                                        <strong>Note:</strong> The exchange rate is fixed for 30 minutes.
                                    </p>
                                </div>
                            </div>
                        </div>

                        <div class="text-center space-y-4">
                            <a href="{{ route('checkout.cancel') }}" class="inline-flex items-center px-4 py-2 bg-gray-100 border border-transparent rounded-md font-semibold text-xs text-gray-700 uppercase tracking-widest hover:bg-gray-200 focus:bg-gray-200 active:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2 transition ease-in-out duration-150">
                                Cancel Payment
                            </a>

                            <div class="mt-4">
                                <button onclick="checkPaymentStatus()" class="inline-flex items-center px-4 py-2 bg-blue-100 border border-transparent rounded-md font-semibold text-xs text-blue-700 uppercase tracking-widest hover:bg-blue-200 focus:bg-blue-200 active:bg-blue-300 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition ease-in-out duration-150">
                                    Check Payment Status
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(() => {
                // Show a temporary success message
                const button = event.currentTarget;
                const originalHTML = button.innerHTML;
                button.innerHTML = `
                    <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                `;
                setTimeout(() => {
                    button.innerHTML = originalHTML;
                }, 2000);
            });
        }

        function checkPaymentStatus() {
            // Add payment status checking logic here
            // This could be an AJAX call to your backend to check the payment status
            alert('Checking payment status...');
        }
    </script>
    @endpush
</x-app-layout>
