<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\ReviewController;
use App\Http\Controllers\Auth\GoogleController;
use App\Http\Controllers\Admin\ProductController as AdminProductController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\Admin\Auth\LoginController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\Admin\OrderController as AdminOrderController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\ChatController;
use App\Http\Controllers\InvoiceController;
use Illuminate\Support\Facades\Broadcast;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Auth;
use App\Models\ChatRoom;
use App\Services\ChatFileService;
use App\Http\Controllers\NewsletterController;
use App\Http\Controllers\Admin\ReviewController as AdminReviewController;
use App\Http\Controllers\Admin\AdminManagerController;

require __DIR__.'/channels.php';

Route::get('/', [HomeController::class, 'index'])->name('home');

// Contact routes
Route::get('/contact', [\App\Http\Controllers\ContactController::class, 'index'])->name('contact');
Route::post('/contact', [\App\Http\Controllers\ContactController::class, 'store'])->name('contact.store');

// Public product routes
Route::get('/productss', [ProductController::class, 'index'])->name('products.index');
Route::get('/products/{product}', [ProductController::class, 'show'])->name('products.show');

Route::middleware(['auth'])->group(function () {
    Route::get('/cart', [CartController::class, 'index'])->name('cart.index');
    Route::post('/cart/add/{product}', [CartController::class, 'add'])->name('cart.add');
    Route::patch('/cart/update/{rowId}', [CartController::class, 'update'])->name('cart.update');
    Route::delete('/cart/remove/{rowId}', [CartController::class, 'remove'])->name('cart.remove');

    Route::get('/checkout', [CheckoutController::class, 'index'])->name('checkout.index');
    Route::post('/checkout/process', [CheckoutController::class, 'process'])->name('checkout.process');
    Route::get('/checkout/success', [CheckoutController::class, 'success'])->name('checkout.success');
    Route::get('/checkout/cancel', [CheckoutController::class, 'cancel'])->name('checkout.cancel');

    // Payment routes
    Route::post('/payment/crypto/callback', [PaymentController::class, 'cryptoCallback'])->name('payment.crypto.callback');
    Route::get('/payment/crypto/show', [PaymentController::class, 'showCryptoPayment'])->name('payment.crypto.show');

    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Product Management Routes (only for authenticated users)
    Route::get('/products/create', [ProductController::class, 'create'])->name('products.create');
    Route::post('/products', [ProductController::class, 'store'])->name('products.store');
    Route::get('/products/{product}/edit', [ProductController::class, 'edit'])->name('products.edit');
    Route::put('/products/{product}', [ProductController::class, 'update'])->name('products.update');
    Route::delete('/products/{product}', [ProductController::class, 'destroy'])->name('products.destroy');

    // Order Management Routes
    Route::get('/orders', [OrderController::class, 'index'])->name('orders.index');
    Route::get('/orders/{order}', [OrderController::class, 'show'])->name('orders.show');

    // Invoice routes
    Route::get('/invoice/{orderId}', [InvoiceController::class, 'show'])->name('invoice.show');
    Route::get('/invoice/{orderId}/download', [InvoiceController::class, 'download'])->name('invoice.download');
    Route::post('/invoice/{orderId}/resend-email', [InvoiceController::class, 'resendEmail'])->name('invoice.resend-email');

    // Review routes
    Route::post('/products/{product}/reviews', [ReviewController::class, 'store'])->name('reviews.store');
    Route::delete('/reviews/{review}', [ReviewController::class, 'destroy'])->name('reviews.destroy');

    // Chat routes
    Route::get('/chat', [ChatController::class, 'userChat'])->name('chat.user');
    Route::get('/chat/{chat}', [ChatController::class, 'show'])->name('chat.show');
    Route::post('/chat/{chat}/send', [ChatController::class, 'sendMessage'])->name('chat.send');
    Route::post('/chat/{chat}/typing', [ChatController::class, 'typing'])->name('chat.typing');
    Route::get('/chat/{chat}/typing-status', [ChatController::class, 'checkTyping'])->name('chat.typing-status');
    Route::post('/chat/{chat}/mark-read', [ChatController::class, 'markAsRead'])->name('chat.mark-read');
    Route::post('/chat/{chat}/mark-delivered', [ChatController::class, 'markAsDelivered'])->name('chat.mark-delivered');
    Route::get('/chat/{chat}/messages', [ChatController::class, 'getNewMessages'])->name('chat.messages');
    Route::get('/chat/{chat}/new-messages', [ChatController::class, 'getNewMessages']);

    // Invoice routes
    Route::get('/invoices', [InvoiceController::class, 'index'])->name('invoices.index');
    Route::get('/invoices/{invoice}', [InvoiceController::class, 'show'])->name('invoices.show');
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::get('language/{lang}', function ($lang) {
    if (in_array($lang, ['en', 'ar'])) {
        session(['locale' => $lang]);
    }
    return back();
})->name('language.switch');

Route::get('auth/google', [GoogleController::class, 'redirectToGoogle'])->name('google.login');
Route::get('auth/google/callback', [GoogleController::class, 'handleGoogleCallback'])->name('google.callback');

Route::get('/test', function () {
    return view('test');
})->name('test');

Route::get('/test-pusher', function () {
    event(new \App\Events\MyEvent('hello world from laravel!'));
    return 'Event sent!';
});

// Route for testing server outgoing IP
Route::get('/test-server-ip', function() {
    $response = Http::timeout(10)->get('https://api.ipify.org');
    return 'Server outgoing IP: ' . $response->body();
});

// تعداد پیام خوانده‌نشده برای badge چت (باید بیرون از هر middleware باشد)
Route::get('/chat/unread-count', function() {
    if (!Auth::check()) return response()->json(['unread' => 0]);
    $userId = Auth::id();
    $unread = 0;
    $chatRooms = ChatRoom::where('user_id', $userId)->get();
    $fileService = app(ChatFileService::class);
    foreach ($chatRooms as $chat) {
        $messages = $fileService->getMessages($chat->id);
        foreach ($messages as $msg) {
            if (
                isset($msg['sender_type'], $msg['is_read']) &&
                $msg['sender_type'] === 'admin' &&
                !$msg['is_read']
            ) {
                $unread++;
            }
        }
    }
    return response()->json(['unread' => $unread]);
});

// Fallback for chat unread count to avoid 404
Route::get('/chat/unread-count', function () {
    return response()->json(['unread' => 0]);
});

// Admin Auth Routes (فقط برای مهمان‌های ادمین)
Route::prefix('admin')->name('admin.')->middleware('guest:admin')->group(function () {
    Route::get('login', [LoginController::class, 'showLoginForm'])->name('login');
    Route::post('login', [LoginController::class, 'login']);
});

// Admin Protected Routes (فقط برای ادمین لاگین‌شده)
Route::prefix('admin')->name('admin.')->middleware('auth:admin')->group(function () {
    // Dashboard
    Route::get('dashboard', [AdminDashboardController::class, 'index'])
        ->name('dashboard');
    // Logout (no permission needed, just must be admin)
    Route::post('logout', [LoginController::class, 'logout'])->name('logout');
    // Products
    Route::get('products', [AdminProductController::class, 'index'])
        ->name('products.index');
    Route::get('products/create', [AdminProductController::class, 'create'])
        ->name('products.create');
    Route::post('products', [AdminProductController::class, 'store'])
        ->name('products.store');
    Route::get('products/{product}/edit', [AdminProductController::class, 'edit'])
        ->name('products.edit');
    Route::put('products/{product}', [AdminProductController::class, 'update'])
        ->name('products.update');
    Route::delete('products/{product}', [AdminProductController::class, 'destroy'])
        ->name('products.destroy');
    Route::post('/products/{product}/delete-image', [AdminProductController::class, 'deleteImage'])
        ->name('products.delete-image');
    // Orders
    Route::get('orders', [AdminOrderController::class, 'index'])
        ->name('orders.index');
    Route::get('orders/approved', [AdminOrderController::class, 'approved'])
        ->name('orders.approved');
    Route::get('orders/shipped', [AdminOrderController::class, 'shipped'])
        ->name('orders.shipped');
    Route::get('orders/{order}', [AdminOrderController::class, 'show'])
        ->name('orders.show');
    Route::put('orders/{order}/status', [AdminOrderController::class, 'updateStatus'])
        ->name('orders.update-status');
    Route::post('orders/{order}/approve', [AdminOrderController::class, 'approveOrder'])
        ->name('orders.approve');
    Route::post('orders/{order}/ship', [AdminOrderController::class, 'markAsShipped'])
        ->name('orders.ship');
    Route::post('orders/{order}/deliver', [AdminOrderController::class, 'markAsDelivered'])
        ->name('orders.deliver');
    // Users
    Route::get('users', [UserController::class, 'index'])
        ->name('users.index');
    Route::get('users/{user}', [UserController::class, 'show'])
        ->name('users.show');
    Route::put('users/{user}/status', [UserController::class, 'updateStatus'])
        ->name('users.update-status');
    // Categories
    Route::get('categories', [CategoryController::class, 'index'])
        ->name('categories.index');
    Route::get('categories/create', [CategoryController::class, 'create'])
        ->name('categories.create');
    Route::post('categories', [CategoryController::class, 'store'])
        ->name('categories.store');
    Route::get('categories/{category}/edit', [CategoryController::class, 'edit'])
        ->name('categories.edit');
    Route::put('categories/{category}', [CategoryController::class, 'update'])
        ->name('categories.update');
    Route::delete('categories/{category}', [CategoryController::class, 'destroy'])
        ->name('categories.destroy');
    // Settings
    Route::get('settings', [SettingController::class, 'index'])
        ->name('settings.index');
    Route::put('settings', [SettingController::class, 'update'])
        ->name('settings.update');
    // Chat
    Route::get('chat/unread-messages', [ChatController::class, 'adminUnreadMessages'])
        ->name('chat.unread-messages');
    Route::get('chats', [ChatController::class, 'adminChats'])
        ->name('chats');
    Route::get('chats/refresh', [ChatController::class, 'refreshChats'])
        ->name('chats.refresh');
    Route::post('chat/{chat}/assign', [ChatController::class, 'assignAdmin'])
        ->name('chat.assign');
    Route::post('chat/{chat}/close', [ChatController::class, 'close'])
        ->name('chat.close');
    Route::post('chat/{chat}/reopen', [ChatController::class, 'reopen'])
        ->name('chat.reopen');
    Route::get('chat/{chat}/view', [ChatController::class, 'show'])
        ->name('chat.view');
    Route::post('chat/{chat}/send', [ChatController::class, 'sendMessage'])->name('chat.send');
    Route::post('chat/{chat}/typing', [ChatController::class, 'typing'])
        ->name('chat.typing');
    Route::get('chat/{chat}/typing-status', [ChatController::class, 'checkTyping'])
        ->name('chat.typing-status');
    Route::post('chat/{chat}/mark-read', [ChatController::class, 'markAsRead'])
        ->name('chat.mark-read');
    Route::post('chat/{chat}/mark-delivered', [ChatController::class, 'markAsDelivered'])
        ->name('chat.mark-delivered');
    Route::get('chat/{chat}/messages', [ChatController::class, 'getNewMessages'])
        ->name('chat.messages');
    Route::get('chat/{chat}/new-messages', [\App\Http\Controllers\ChatController::class, 'getNewMessages']);
    Route::post('chat/{chat}/refresh-lock', [ChatController::class, 'refreshLock'])->name('chat.refresh-lock');
    // Pages
    Route::get('pages', [\App\Http\Controllers\Admin\PageController::class, 'index'])
        ->name('pages.index');
    Route::get('pages/create', [\App\Http\Controllers\Admin\PageController::class, 'create'])
        ->name('pages.create');
    Route::post('pages', [\App\Http\Controllers\Admin\PageController::class, 'store'])
        ->name('pages.store');
    Route::get('pages/{page}/edit', [\App\Http\Controllers\Admin\PageController::class, 'edit'])
        ->name('pages.edit');
    Route::put('pages/{page}', [\App\Http\Controllers\Admin\PageController::class, 'update'])
        ->name('pages.update');
    Route::delete('pages/{page}', [\App\Http\Controllers\Admin\PageController::class, 'destroy'])
        ->name('pages.destroy');
    Route::get('pages/{page}', [\App\Http\Controllers\Admin\PageController::class, 'show'])
        ->name('pages.show');
    Route::post('pages/{page}/toggle', [\App\Http\Controllers\Admin\PageController::class, 'toggle'])
        ->name('pages.toggle');
    // Contacts
    Route::get('contacts', [\App\Http\Controllers\Admin\ContactController::class, 'index'])
        ->name('contacts.index');
    Route::get('contacts/{contact}', [\App\Http\Controllers\Admin\ContactController::class, 'show'])
        ->name('contacts.show');
    Route::delete('contacts/{contact}', [\App\Http\Controllers\Admin\ContactController::class, 'destroy'])
        ->name('contacts.destroy');
    Route::get('contacts/unread', [\App\Http\Controllers\Admin\ContactController::class, 'unread'])->name('contacts.unread');
    Route::post('contacts/{contact}/mark-read', [\App\Http\Controllers\Admin\ContactController::class, 'markAsRead'])->name('contacts.mark-read');
    // Reviews
    Route::get('reviews', [AdminReviewController::class, 'index'])
        ->name('reviews.index');
    Route::get('reviews/pending', [AdminReviewController::class, 'pending'])
        ->name('reviews.pending');
    Route::get('reviews/approved', [AdminReviewController::class, 'approved'])
        ->name('reviews.approved');
    Route::get('reviews/{review}', [AdminReviewController::class, 'show'])
        ->name('reviews.show');
    Route::post('reviews/{review}/approve', [AdminReviewController::class, 'approve'])
        ->name('reviews.approve');
    Route::post('reviews/{review}/reject', [AdminReviewController::class, 'reject'])
        ->name('reviews.reject');
    Route::delete('reviews/{review}', [AdminReviewController::class, 'destroy'])
        ->name('reviews.destroy');
    // Admins
    Route::get('admins', [AdminManagerController::class, 'index'])
        ->name('admins.index');
    Route::get('admins/create', [AdminManagerController::class, 'create'])
        ->name('admins.create');
    Route::post('admins', [AdminManagerController::class, 'store'])
        ->name('admins.store');
    Route::get('admins/{admin}', [AdminManagerController::class, 'show'])
        ->name('admins.show');
    Route::get('admins/{admin}/edit', [AdminManagerController::class, 'edit'])
        ->name('admins.edit');
    Route::put('admins/{admin}', [AdminManagerController::class, 'update'])
        ->name('admins.update');
    Route::delete('admins/{admin}', [AdminManagerController::class, 'destroy'])
        ->name('admins.destroy');
    Route::post('admins/{admin}/toggle-status', [AdminManagerController::class, 'toggleStatus'])
        ->name('admins.toggle-status');
    // Roles (legacy)
    Route::get('roles', [\App\Http\Controllers\Admin\RoleController::class, 'index'])
        ->name('roles.index');
    Route::get('roles/create', [\App\Http\Controllers\Admin\RoleController::class, 'create'])
        ->name('roles.create');
    Route::post('roles', [\App\Http\Controllers\Admin\RoleController::class, 'store'])
        ->name('roles.store');
    Route::get('roles/{role}', [\App\Http\Controllers\Admin\RoleController::class, 'show'])
        ->name('roles.show');
    Route::get('roles/{role}/edit', [\App\Http\Controllers\Admin\RoleController::class, 'edit'])
        ->name('roles.edit');
    Route::put('roles/{role}', [\App\Http\Controllers\Admin\RoleController::class, 'update'])
        ->name('roles.update');
    Route::delete('roles/{role}', [\App\Http\Controllers\Admin\RoleController::class, 'destroy'])
        ->name('roles.destroy');
    Route::get('cooperation-requests', [\App\Http\Controllers\Admin\CooperationRequestController::class, 'index'])->name('cooperation-requests.index');
    Route::get('cooperation-requests/{id}', [\App\Http\Controllers\Admin\CooperationRequestController::class, 'show'])->name('cooperation-requests.show');
    Route::put('cooperation-requests/{id}/approve', [\App\Http\Controllers\Admin\CooperationRequestController::class, 'approve'])->name('cooperation-requests.approve');
    Route::put('cooperation-requests/{id}/reject', [\App\Http\Controllers\Admin\CooperationRequestController::class, 'reject'])->name('cooperation-requests.reject');
});

// Admin newsletter subscribers management
Route::middleware(['auth:admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('newsletter-subscribers', [\App\Http\Controllers\Admin\NewsletterSubscriberController::class, 'index'])->name('newsletter-subscribers.index');
});

Broadcast::routes();

require __DIR__.'/auth.php';

// Show active page by slug (must be after all other specific routes)
Route::get('/page/{slug}', [\App\Http\Controllers\PageController::class, 'show'])->name('pages.show.public');

// Newsletter subscription
Route::post('/newsletter/subscribe', [NewsletterController::class, 'subscribe'])->name('newsletter.subscribe');

Route::get('/test-can', function() {
    return view('test-can');
});

Route::get('/api/available-cryptos', [\App\Http\Controllers\CheckoutController::class, 'availableCryptos']);

Route::get('/cooperation', [\App\Http\Controllers\CooperationController::class, 'index'])->name('cooperation');
Route::post('/cooperation', [\App\Http\Controllers\CooperationController::class, 'store'])->name('cooperation.store');

// Sitemap index and sub-sitemaps
Route::get('/sitemapx.xml', [\App\Http\Controllers\SitemapController::class, 'index'])->name('sitemap.xml');
Route::get('/sitemap-categories.xml', [\App\Http\Controllers\SitemapController::class, 'categories'])->name('sitemap.categories');
Route::get('/sitemap-products.xml', [\App\Http\Controllers\SitemapController::class, 'products'])->name('sitemap.products');
Route::get('/sitemap-pages.xml', [\App\Http\Controllers\SitemapController::class, 'pages'])->name('sitemap.pages');
