<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="container mx-auto px-4 py-8">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold">Create Category</h1>
            <a href="<?php echo e(route('admin.categories.index')); ?>" class="text-blue-600 hover:text-blue-900">
                ← Back to Categories
            </a>
        </div>

        <div class="bg-white rounded-lg shadow">
            <form action="<?php echo e(route('admin.categories.store')); ?>" method="POST" class="p-6" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <div class="mb-4">
                    <label for="name" class="block text-sm font-medium text-gray-700">Name</label>
                    <input type="text" name="name" id="name" value="<?php echo e(old('name')); ?>" required
                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="mb-4">
                    <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                    <textarea name="description" id="description" rows="3"
                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"><?php echo e(old('description')); ?></textarea>
                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Image Upload Section -->
                <div class="mb-6">
                    <label for="image" class="block text-sm font-medium text-gray-700 mb-2">Category Image</label>
                    <div class="flex items-center space-x-4">
                        <div class="flex-1">
                            <input type="file" name="image" id="image" accept="image/*"
                                class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                            <p class="text-xs text-gray-500 mt-1">Recommended size: 800x600px, Max size: 2MB</p>
                        </div>
                        <div id="image-preview" class="hidden">
                            <img id="preview-img" src="" alt="Preview" class="w-20 h-20 object-cover rounded-lg border">
                        </div>
                    </div>
                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- SEO Section -->
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-6 mb-6">
                    <h3 class="text-lg font-semibold text-blue-900 mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        SEO Settings
                    </h3>

                    <!-- Basic SEO -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                        <div>
                            <label for="meta_title" class="block text-sm font-medium text-gray-700">Meta Title</label>
                            <input type="text" name="meta_title" id="meta_title" value="<?php echo e(old('meta_title')); ?>" maxlength="60"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                placeholder="Auto-generated from category name">
                            <p class="text-xs text-gray-500 mt-1">Max 60 characters</p>
                        </div>

                        <div>
                            <label for="meta_description" class="block text-sm font-medium text-gray-700">Meta Description</label>
                            <textarea name="meta_description" id="meta_description" rows="2" maxlength="160"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                placeholder="Auto-generated from description"><?php echo e(old('meta_description')); ?></textarea>
                            <p class="text-xs text-gray-500 mt-1">Max 160 characters</p>
                        </div>
                    </div>

                    <div class="mb-6">
                        <label for="meta_keywords" class="block text-sm font-medium text-gray-700">Meta Keywords</label>
                        <input type="text" name="meta_keywords" id="meta_keywords" value="<?php echo e(old('meta_keywords')); ?>"
                            class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                            placeholder="Auto-generated from category name">
                        <p class="text-xs text-gray-500 mt-1">Comma separated keywords</p>
                    </div>

                    <!-- Category Settings -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                        <div>
                            <label for="category_type" class="block text-sm font-medium text-gray-700">Category Type</label>
                            <select name="category_type" id="category_type"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                                <option value="product" <?php echo e(old('category_type') == 'product' ? 'selected' : ''); ?>>Product</option>
                                <option value="service" <?php echo e(old('category_type') == 'service' ? 'selected' : ''); ?>>Service</option>
                                <option value="blog" <?php echo e(old('category_type') == 'blog' ? 'selected' : ''); ?>>Blog</option>
                            </select>
                        </div>

                        <div>
                            <label for="sort_order" class="block text-sm font-medium text-gray-700">Sort Order</label>
                            <input type="number" name="sort_order" id="sort_order" value="<?php echo e(old('sort_order', 0)); ?>" min="0"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                            <p class="text-xs text-gray-500 mt-1">Lower numbers appear first</p>
                        </div>
                    </div>

                    <!-- SEO Settings -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                        <div>
                            <label for="seo_url" class="block text-sm font-medium text-gray-700">SEO URL</label>
                            <input type="text" name="seo_url" id="seo_url" value="<?php echo e(old('seo_url')); ?>"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                placeholder="Auto-generated from category name">
                        </div>

                        <div>
                            <label for="seo_priority" class="block text-sm font-medium text-gray-700">SEO Priority</label>
                            <select name="seo_priority" id="seo_priority"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                                <option value="low" <?php echo e(old('seo_priority') == 'low' ? 'selected' : ''); ?>>Low</option>
                                <option value="normal" <?php echo e(old('seo_priority') == 'normal' ? 'selected' : ''); ?> selected>Normal</option>
                                <option value="high" <?php echo e(old('seo_priority') == 'high' ? 'selected' : ''); ?>>High</option>
                            </select>
                        </div>
                    </div>

                    <!-- SEO Options -->
                    <div class="flex items-center space-x-6">
                        <label class="inline-flex items-center">
                            <input type="checkbox" name="seo_indexable" value="1" <?php echo e(old('seo_indexable', true) ? 'checked' : ''); ?>

                                class="form-checkbox h-4 w-4 text-blue-600">
                            <span class="ml-2 text-sm text-gray-700">Allow search engines to index</span>
                        </label>

                        <label class="inline-flex items-center">
                            <input type="checkbox" name="show_in_menu" value="1" <?php echo e(old('show_in_menu', true) ? 'checked' : ''); ?>

                                class="form-checkbox h-4 w-4 text-blue-600">
                            <span class="ml-2 text-sm text-gray-700">Show in navigation menu</span>
                        </label>

                        <label class="inline-flex items-center">
                            <input type="checkbox" name="show_in_sitemap" value="1" <?php echo e(old('show_in_sitemap', true) ? 'checked' : ''); ?>

                                class="form-checkbox h-4 w-4 text-blue-600">
                            <span class="ml-2 text-sm text-gray-700">Include in sitemap</span>
                        </label>
                    </div>
                </div>

                <div class="flex justify-end">
                    <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-lg">
                        Create Category
                    </button>
                </div>
            </form>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        // Auto-generate SEO fields
        function autoGenerateSeoFields() {
            const name = document.getElementById('name').value;
            const description = document.getElementById('description').value;

            // Auto-generate meta title
            if (!document.getElementById('meta_title').value && name) {
                document.getElementById('meta_title').value = name + ' - ' + '<?php echo e(config("app.name")); ?>';
            }

            // Auto-generate meta description
            if (!document.getElementById('meta_description').value && description) {
                const cleanDescription = description.replace(/<[^>]*>/g, '').trim();
                document.getElementById('meta_description').value = cleanDescription.substring(0, 160);
            }

            // Auto-generate meta keywords
            if (!document.getElementById('meta_keywords').value && name) {
                const keywords = [name, 'category', 'products'];
                document.getElementById('meta_keywords').value = keywords.join(', ');
            }

            // Auto-generate SEO URL
            if (!document.getElementById('seo_url').value && name) {
                document.getElementById('seo_url').value = name.toLowerCase()
                    .replace(/[^a-z0-9\s-]/g, '')
                    .replace(/\s+/g, '-')
                    .replace(/-+/g, '-')
                    .trim('-');
            }
        }

        // Add event listeners for auto-generation
        document.getElementById('name').addEventListener('input', autoGenerateSeoFields);
        document.getElementById('description').addEventListener('input', autoGenerateSeoFields);

        // Image preview functionality
        document.getElementById('image').addEventListener('change', function(e) {
            const file = e.target.files[0];
            const preview = document.getElementById('image-preview');
            const previewImg = document.getElementById('preview-img');

            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    previewImg.src = e.target.result;
                    preview.classList.remove('hidden');
                };
                reader.readAsDataURL(file);
            } else {
                preview.classList.add('hidden');
            }
        });

        // Character counter for meta description
        document.getElementById('meta_description').addEventListener('input', function() {
            const maxLength = 160;
            const currentLength = this.value.length;
            const remaining = maxLength - currentLength;

            // Update character count display
            let counter = this.parentNode.querySelector('.char-counter');
            if (!counter) {
                counter = document.createElement('p');
                counter.className = 'char-counter text-xs mt-1';
                this.parentNode.appendChild(counter);
            }

            if (remaining < 0) {
                counter.textContent = `${Math.abs(remaining)} characters over limit`;
                counter.className = 'char-counter text-xs mt-1 text-red-500';
            } else {
                counter.textContent = `${remaining} characters remaining`;
                counter.className = 'char-counter text-xs mt-1 text-gray-500';
            }
        });

        // Character counter for meta title
        document.getElementById('meta_title').addEventListener('input', function() {
            const maxLength = 60;
            const currentLength = this.value.length;
            const remaining = maxLength - currentLength;

            // Update character count display
            let counter = this.parentNode.querySelector('.char-counter');
            if (!counter) {
                counter = document.createElement('p');
                counter.className = 'char-counter text-xs mt-1';
                this.parentNode.appendChild(counter);
            }

            if (remaining < 0) {
                counter.textContent = `${Math.abs(remaining)} characters over limit`;
                counter.className = 'char-counter text-xs mt-1 text-red-500';
            } else {
                counter.textContent = `${remaining} characters remaining`;
                counter.className = 'char-counter text-xs mt-1 text-gray-500';
            }
        });
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\amazoon\resources\views/admin/categories/create.blade.php ENDPATH**/ ?>