
<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <style>
        /* Custom CSS styles for chat management */
        .container-fluid {
            background: #ffffff;
            min-height: 100vh;
            padding: 0;
        }

        .header-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 2rem 0;
            margin-bottom: 2rem;
        }

        .card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            border: 1px solid #e5e7eb;
            margin-bottom: 1.5rem;
            overflow: hidden;
        }

        .card-header {
            padding: 1.5rem;
            border-bottom: 1px solid #e5e7eb;
            font-weight: 600;
            font-size: 1.125rem;
        }

        .card-body {
            padding: 1.5rem;
        }

        .chat-item {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            transition: all 0.3s ease;
        }

        .chat-item:hover {
            background: #f3f4f6;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .btn {
            padding: 0.5rem 1rem;
            border-radius: 6px;
            font-weight: 500;
            font-size: 0.875rem;
            border: none;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }

        .btn-primary {
            background: linear-gradient(135deg, #3b82f6, #1d4ed8);
            color: white;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, #2563eb, #1e40af);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.4);
        }

        .btn-success {
            background: linear-gradient(135deg, #10b981, #059669);
            color: white;
        }

        .btn-success:hover {
            background: linear-gradient(135deg, #059669, #047857);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(16, 185, 129, 0.4);
        }

        .btn-danger {
            background: linear-gradient(135deg, #ef4444, #dc2626);
            color: white;
        }

        .btn-danger:hover {
            background: linear-gradient(135deg, #dc2626, #b91c1c);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(239, 68, 68, 0.4);
        }

        .btn-warning {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            color: white;
        }

        .btn-warning:hover {
            background: linear-gradient(135deg, #d97706, #b45309);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(245, 158, 11, 0.4);
        }

        .btn-secondary {
            background: linear-gradient(135deg, #6b7280, #4b5563);
            color: white;
        }

        .btn-secondary:hover {
            background: linear-gradient(135deg, #4b5563, #374151);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(107, 114, 128, 0.4);
        }

        .badge {
            display: inline-block;
            padding: 0.25rem 0.5rem;
            font-size: 0.75rem;
            font-weight: 600;
            border-radius: 9999px;
            color: white;
        }

        .badge-danger {
            background: #ef4444;
        }

        .badge-success {
            background: #10b981;
        }

        .badge-warning {
            background: #f59e0b;
        }

        .badge-secondary {
            background: #6b7280;
        }

        .text-primary {
            color: #3b82f6;
        }

        .text-success {
            color: #10b981;
        }

        .text-danger {
            color: #ef4444;
        }

        .text-warning {
            color: #f59e0b;
        }

        .text-muted {
            color: #6b7280;
        }

        .alert {
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
            border: 1px solid;
        }

        .alert-success {
            background: #d1fae5;
            border-color: #10b981;
            color: #047857;
        }

        .notification {
            position: fixed;
            top: 1rem;
            right: 1rem;
            z-index: 1000;
            padding: 1rem 1.5rem;
            border-radius: 8px;
            color: white;
            font-weight: 500;
            transform: translateX(100%);
            transition: transform 0.3s ease;
        }

        .notification.show {
            transform: translateX(0);
        }

        .notification-success {
            background: linear-gradient(135deg, #10b981, #059669);
        }

        .notification-info {
            background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        }

        .spinner {
            width: 1rem;
            height: 1rem;
            border: 2px solid #ffffff;
            border-top: 2px solid transparent;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Responsive Grid */
        .grid {
            display: grid;
            gap: 1.5rem;
        }

        .grid-1 {
            grid-template-columns: 1fr;
        }

        .grid-2 {
            grid-template-columns: repeat(2, 1fr);
        }

        .grid-3 {
            grid-template-columns: repeat(3, 1fr);
        }

        /* Responsive breakpoints */
        @media (max-width: 768px) {
            .grid-2, .grid-3 {
                grid-template-columns: 1fr;
            }

            .header-section {
                padding: 1.5rem 0;
            }

            .card-body, .card-header {
                padding: 1rem;
            }

            .chat-item {
                padding: 0.75rem;
            }

            .btn {
                padding: 0.5rem 0.75rem;
                font-size: 0.8rem;
            }

            .flex-actions {
                flex-direction: column;
                gap: 0.5rem;
            }

            .flex-actions .btn {
                width: 100%;
                justify-content: center;
            }
        }

        @media (min-width: 769px) and (max-width: 1024px) {
            .grid-3 {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        .flex {
            display: flex;
        }

        .flex-between {
            justify-content: space-between;
        }

        .flex-center {
            align-items: center;
        }

        .flex-actions {
            display: flex;
            gap: 0.5rem;
            align-items: center;
        }

        .w-full {
            width: 100%;
        }

        .text-center {
            text-align: center;
        }

        .mb-4 {
            margin-bottom: 1rem;
        }

        .mb-6 {
            margin-bottom: 1.5rem;
        }

        .mt-8 {
            margin-top: 2rem;
        }

        .py-4 {
            padding-top: 1rem;
            padding-bottom: 1rem;
        }

        h1 {
            font-size: 2rem;
            font-weight: 700;
            margin: 0;
        }

        h3 {
            font-size: 1.25rem;
            font-weight: 600;
            margin: 0;
        }

        h4 {
            font-size: 1.125rem;
            font-weight: 600;
            margin: 0 0 0.5rem 0;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 1rem;
        }

        @media (min-width: 640px) {
            .container {
                padding: 0 1.5rem;
            }
        }
    </style>

    <div class="container-fluid">
        <!-- Header Section -->
        <div class="header-section">
            <div class="container">
                <div class="flex flex-between flex-center mb-6">
                    <h1>Chat Management Dashboard</h1>
                    <?php if($total_unread_count > 0): ?>
                        <div class="flex flex-center" style="background: rgba(255,255,255,0.2); padding: 0.75rem 1rem; border-radius: 8px;">
                            <svg style="width: 1.25rem; height: 1.25rem; margin-right: 0.5rem;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M12 20a8 8 0 100-16 8 8 0 000 16z" />
                            </svg>
                            <span style="font-weight: 600;"><?php echo e($total_unread_count); ?> Unread Messages</span>
                        </div>
                    <?php endif; ?>
                    <button id="refresh-chats" class="btn btn-primary">
                        <svg style="width: 1rem; height: 1rem;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                        </svg>
                        Refresh Dashboard
                    </button>
                </div>
            </div>
        </div>

        <div class="container">
            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <!-- Main Dashboard Grid -->
            <div class="grid grid-2">
                <!-- Available Chats -->
                <div class="card">
                    <div class="card-header" style="background: linear-gradient(135deg, #10b981, #059669); color: white;">
                        <h3>Available Chats</h3>
                    </div>
                    <div class="card-body">
                        <?php
                            $availableChats = $chats->where('admin_id', null)->where('is_active', true);
                        ?>

                        <?php if($availableChats->count() > 0): ?>
                            <div>
                                <?php $__currentLoopData = $availableChats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="chat-item">
                                        <div class="flex flex-between flex-center">
                                            <div style="flex: 1;">
                                                <div class="flex flex-center mb-2">
                                                    <h4>
                                                        <?php echo e($chat->user->name); ?>

                                                        <?php if($chat->unread_count_file > 0): ?>
                                                            <div class="mt-2 bg-red-500 text-white text-xs px-3 py-2 rounded shadow font-bold">
                                                                تعداد پیام خوانده‌نشده: <?php echo e($chat->unread_count_file); ?>

                                                            </div>
                                                        <?php endif; ?>
                                                    </h4>
                                                </div>
                                                <p style="font-size: 0.875rem; color: #6b7280; margin: 0.25rem 0;"><?php echo e($chat->user->email); ?></p>
                                                <p style="font-size: 0.75rem; color: #9ca3af; margin: 0.25rem 0;">Created: <?php echo e($chat->created_at->format('M d, H:i')); ?></p>
                                                <p style="font-size: 0.75rem; margin: 0.25rem 0;" class="text-primary">Total Messages: <?php echo e($chat->message_count); ?></p>
                                                <p style="font-size: 0.75rem; margin: 0.25rem 0;" class="text-success">User Messages: <?php echo e($chat->user_message_count); ?></p>
                                                <?php if($chat->admin_id && $chat->admin): ?>
                                                    <p style="font-size: 0.75rem; color: #f59e0b; margin: 0.25rem 0;">Last chat with: <?php echo e($chat->admin->name); ?></p>
                                                <?php endif; ?>
                                                <?php if($chat->last_message): ?>
                                                    <p style="font-size: 0.75rem; color: #9ca3af; margin: 0.25rem 0;">
                                                        Last message: <?php echo e(\Illuminate\Support\Carbon::parse($chat->last_message['created_at'])->format('M d, H:i')); ?>

                                                        <?php if($chat->last_message['sender_type'] === 'user' && !$chat->last_message['is_read']): ?>
                                                            <span class="text-danger" style="font-weight: 600;"> (Unread)</span>
                                                        <?php elseif($chat->last_message['sender_type'] === 'admin' && !$chat->last_message['is_read']): ?>
                                                            <span class="text-warning" style="font-weight: 600;"> (Not delivered)</span>
                                                        <?php endif; ?>
                                                    </p>
                                                <?php endif; ?>
                                            </div>
                                            <form method="POST" action="<?php echo e(route('admin.chat.assign', $chat)); ?>">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-success">
                                                    Assign to Me
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-4">
                                <p class="text-muted">No available chats at the moment</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- My Active Chats -->
                <div class="card">
                    <div class="card-header" style="background: linear-gradient(135deg, #3b82f6, #1d4ed8); color: white;">
                        <h3>My Active Chats</h3>
                    </div>
                    <div class="card-body">
                        <?php
                            $myActiveChats = $chats->where('admin_id', auth('admin')->id())->where('is_active', true);
                        ?>

                        <?php if($myActiveChats->count() > 0): ?>
                            <div>
                                <?php $__currentLoopData = $myActiveChats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="chat-item">
                                        <div class="flex flex-between flex-center">
                                            <div style="flex: 1;">
                                                <div class="flex flex-center mb-2">
                                                    <h4>
                                                        <?php echo e($chat->user->name); ?>

                                                        <?php if($chat->unread_count_file > 0): ?>
                                                            <div class="mt-2 bg-red-500 text-white text-xs px-3 py-2 rounded shadow font-bold">
                                                                تعداد پیام خوانده‌نشده: <?php echo e($chat->unread_count_file); ?>

                                                            </div>
                                                        <?php endif; ?>
                                                    </h4>
                                                </div>
                                                <p style="font-size: 0.875rem; color: #6b7280; margin: 0.25rem 0;"><?php echo e($chat->user->email); ?></p>
                                                <p style="font-size: 0.75rem; color: #9ca3af; margin: 0.25rem 0;">Assigned: <?php echo e($chat->updated_at->format('M d, H:i')); ?></p>
                                                <p style="font-size: 0.75rem; margin: 0.25rem 0;" class="text-primary">Total Messages: <?php echo e($chat->message_count); ?></p>
                                                <p style="font-size: 0.75rem; margin: 0.25rem 0;" class="text-success">User Messages: <?php echo e($chat->user_message_count); ?></p>
                                                <?php if($chat->admin_id && $chat->admin): ?>
                                                    <p style="font-size: 0.75rem; color: #f59e0b; margin: 0.25rem 0;">Last chat with: <?php echo e($chat->admin->name); ?></p>
                                                <?php endif; ?>
                                                <?php if($chat->last_message): ?>
                                                    <p style="font-size: 0.75rem; color: #9ca3af; margin: 0.25rem 0;">
                                                        Last message: <?php echo e(\Illuminate\Support\Carbon::parse($chat->last_message['created_at'])->format('M d, H:i')); ?>

                                                        <?php if($chat->last_message['sender_type'] === 'user' && !$chat->last_message['is_read']): ?>
                                                            <span class="text-danger" style="font-weight: 600;"> (Unread)</span>
                                                        <?php elseif($chat->last_message['sender_type'] === 'admin' && !$chat->last_message['is_read']): ?>
                                                            <span class="text-warning" style="font-weight: 600;"> (Not delivered)</span>
                                                        <?php endif; ?>
                                                    </p>
                                                <?php endif; ?>
                                            </div>
                                            <div class="flex-actions">
                                                <a href="<?php echo e(route('admin.chat.view', $chat)); ?>" class="btn btn-primary">
                                                    Open Chat
                                                </a>
                                                <form method="POST" action="<?php echo e(route('admin.chat.close', $chat)); ?>" style="display: inline;">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-danger"
                                                            onclick="return confirm('Are you sure you want to close this chat?')">
                                                        Close Chat
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-4">
                                <p class="text-muted">No active assigned chats</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Other Admins' Active Chats -->
            <div class="mt-8">
                <div class="card">
                    <div class="card-header" style="background: linear-gradient(135deg, #f59e0b, #d97706); color: white;">
                        <h3>Other Admins' Active Chats</h3>
                    </div>
                    <div class="card-body">
                        <?php
                            $otherAdminChats = $chats->where('is_active', true)->where('admin_id', '!=', null)->where('admin_id', '!=', auth('admin')->id());
                        ?>

                        <?php if($otherAdminChats->count() > 0): ?>
                            <div class="grid grid-3">
                                <?php $__currentLoopData = $otherAdminChats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $userMessageCount = collect($chat->messages)->where('sender_type', 'user')->count();
                                    ?>
                                    <div class="chat-item">
                                        <div class="flex flex-between flex-center mb-2">
                                            <div>
                                                <div class="flex flex-center">
                                                    <h4>
                                                        <?php echo e($chat->user->name); ?>

                                                        <?php if($userMessageCount > 0): ?>
                                                            <span class="badge badge-danger" style="margin-left: 0.5rem;">
                                                                <?php echo e($userMessageCount); ?>

                                                            </span>
                                                        <?php endif; ?>
                                                    </h4>
                                                </div>
                                                <p style="font-size: 0.875rem; color: #6b7280; margin: 0.25rem 0;"><?php echo e($chat->user->email); ?></p>
                                            </div>
                                            <span class="badge badge-warning">
                                                Assigned
                                            </span>
                                        </div>
                                        <div style="font-size: 0.75rem; color: #9ca3af; margin-bottom: 0.75rem;">
                                            <p style="margin: 0.25rem 0;">Assigned to: <?php echo e($chat->admin->name); ?></p>
                                            <p style="margin: 0.25rem 0;">Assigned: <?php echo e($chat->updated_at->format('M d, H:i')); ?></p>
                                            <?php
                                                $messageCount = $chat->messages()->count();
                                                $unreadCount = $chat->messages()->where('sender_type', 'user')->where('is_read', false)->count();
                                                $lastMessage = $chat->messages()->latest()->first();
                                            ?>
                                            <p style="margin: 0.25rem 0;" class="text-primary">Total Messages: <?php echo e($messageCount); ?></p>
                                            <p style="margin: 0.25rem 0;" class="text-success">User Messages: <?php echo e($userMessageCount); ?></p>
                                            <?php if($lastMessage): ?>
                                                <p style="margin: 0.25rem 0; color: #9ca3af;">
                                                    Last message: <?php echo e($lastMessage->created_at->format('M d, H:i')); ?>

                                                    <?php if($lastMessage->sender_type === 'user' && !$lastMessage->is_read): ?>
                                                        <span class="text-danger" style="font-weight: 600;"> (Unread)</span>
                                                    <?php endif; ?>
                                                </p>
                                            <?php endif; ?>
                                        </div>
                                        <a href="<?php echo e(route('admin.chat.view', $chat)); ?>" class="btn btn-warning w-full">
                                            View Chat
                                        </a>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-4">
                                <p class="text-muted">No chats assigned to other admins</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Closed Chats Section -->
            <div class="mt-8">
                <div class="card">
                    <div class="card-header" style="background: linear-gradient(135deg, #6b7280, #4b5563); color: white;">
                        <h3>Closed Chats</h3>
                    </div>
                    <div class="card-body">
                        <?php
                            $closedChats = $chats->where('is_active', false);
                        ?>

                        <?php if($closedChats->count() > 0): ?>
                            <div class="grid grid-3">
                                <?php $__currentLoopData = $closedChats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $userMessageCount = collect($chat->messages)->where('sender_type', 'user')->count(); ?>
                                    <div class="chat-item">
                                        <div class="flex flex-between flex-center mb-2">
                                            <div>
                                                <div class="flex flex-center">
                                                    <h4>
                                                        <?php echo e($chat->user->name); ?>

                                                        <?php if($userMessageCount > 0): ?>
                                                            <span class="badge badge-danger" style="margin-left: 0.5rem;">
                                                                <?php echo e($userMessageCount); ?>

                                                            </span>
                                                        <?php endif; ?>
                                                    </h4>
                                                </div>
                                                <p style="font-size: 0.875rem; color: #6b7280; margin: 0.25rem 0;"><?php echo e($chat->user->email); ?></p>
                                            </div>
                                            <span class="badge badge-secondary">
                                                Closed
                                            </span>
                                        </div>
                                        <div style="font-size: 0.75rem; color: #9ca3af; margin-bottom: 0.75rem;">
                                            <p style="margin: 0.25rem 0;">Created: <?php echo e($chat->created_at->format('M d, H:i')); ?></p>
                                            <p style="margin: 0.25rem 0;">Closed: <?php echo e($chat->updated_at->format('M d, H:i')); ?></p>
                                            <?php if($chat->admin): ?>
                                                <p style="margin: 0.25rem 0;">Closed by: <?php echo e($chat->admin->name); ?></p>
                                            <?php endif; ?>
                                            <?php
                                                $messageCount = $chat->messages()->count();
                                                $unreadCount = $chat->messages()->where('sender_type', 'user')->where('is_read', false)->count();
                                                $lastMessage = $chat->messages()->latest()->first();
                                            ?>
                                            <p style="margin: 0.25rem 0;" class="text-primary">Total Messages: <?php echo e($messageCount); ?></p>
                                            <p style="margin: 0.25rem 0;" class="text-success">User Messages: <?php echo e($userMessageCount); ?></p>
                                            <?php if($lastMessage): ?>
                                                <p style="margin: 0.25rem 0; color: #9ca3af;">
                                                    Last message: <?php echo e($lastMessage->created_at->format('M d, H:i')); ?>

                                                    <?php if($lastMessage->sender_type === 'user' && !$lastMessage->is_read): ?>
                                                        <span class="text-danger" style="font-weight: 600;"> (Unread)</span>
                                                    <?php endif; ?>
                                                </p>
                                            <?php endif; ?>
                                        </div>
                                        <div class="flex-actions">
                                            <a href="<?php echo e(route('admin.chat.view', $chat)); ?>" class="btn btn-secondary">
                                                View History
                                            </a>
                                            <form method="POST" action="<?php echo e(route('admin.chat.reopen', $chat)); ?>" style="display: inline;">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-success">
                                                    Reopen
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-4">
                                <p class="text-muted">No closed chats</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
    $(document).ready(function() {
        // Manual refresh button
        $('#refresh-chats').on('click', function() {
            $(this).prop('disabled', true).html('<div class="spinner"></div>Refreshing Dashboard...');

            $.ajax({
                url: '<?php echo e(route("admin.chats.refresh")); ?>',
                method: 'GET',
                success: function(response) {
                    if (response.success) {
                        location.reload();
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error refreshing chats:', error);
                    $('#refresh-chats').prop('disabled', false).html('<svg style="width: 1rem; height: 1rem;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/></svg>Refresh Dashboard');
                }
            });
        });

        // Auto refresh admin chats every 10 seconds
        setInterval(function() {
            $.ajax({
                url: '<?php echo e(route("admin.chats.refresh")); ?>',
                method: 'GET',
                success: function(response) {
                    if (response.success) {
                        // Check if there are changes in chat counts
                        const currentAvailable = <?php echo e($chats->where('admin_id', null)->where('is_active', true)->count()); ?>;
                        const currentMyActive = <?php echo e($chats->where('admin_id', auth('admin')->id())->where('is_active', true)->count()); ?>;
                        const currentClosed = <?php echo e($chats->where('is_active', false)->count()); ?>;

                        if (response.available_count !== currentAvailable ||
                            response.my_active_count !== currentMyActive ||
                            response.closed_count !== currentClosed) {
                            // Show notification and reload
                            if (response.available_count > currentAvailable) {
                                // New available chat
                                showNotification('New chat available!', 'success');
                            } else if (response.closed_count < currentClosed) {
                                // Chat reactivated
                                showNotification('Chat reactivated!', 'info');
                            }
                            setTimeout(() => {
                                location.reload();
                            }, 2000);
                        }
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error refreshing chats:', error);
                }
            });
        }, 10000); // Refresh every 10 seconds

        // Show notification function
        function showNotification(message, type = 'info') {
            const className = type === 'success' ? 'notification-success' : 'notification-info';
            const notification = $(`
                <div class="notification ${className}">
                    ${message}
                </div>
            `);

            $('body').append(notification);

            // Animate in
            setTimeout(() => {
                notification.addClass('show');
            }, 100);

            // Animate out and remove
            setTimeout(() => {
                notification.removeClass('show');
                setTimeout(() => {
                    notification.remove();
                }, 300);
            }, 3000);
        }
    });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\amazoon\resources\views/chat/admin_chats.blade.php ENDPATH**/ ?>