<?php $__env->startSection('title', $seoData['title'] ?? 'Home'); ?>
<?php $__env->startSection('meta_description', $seoData['description'] ?? 'Discover authentic luxury brands, exclusive products, and premium shopping experience at ' . config('app.name') . '. Shop the worlds best designer items with fast delivery and secure checkout.'); ?>

<?php if(isset($seoData)): ?>
    <?php $__env->startSection('meta_keywords', $seoData['meta_keywords'] ?? ''); ?>
    <?php $__env->startSection('canonical', $seoData['canonical'] ?? ''); ?>
    <?php $__env->startSection('og_title', $seoData['og_title'] ?? ''); ?>
    <?php $__env->startSection('og_description', $seoData['og_description'] ?? ''); ?>
    <?php $__env->startSection('og_type', $seoData['og_type'] ?? 'website'); ?>
    <?php $__env->startSection('og_url', $seoData['og_url'] ?? ''); ?>
    <?php $__env->startSection('og_image', $seoData['og_image'] ?? ''); ?>
    <?php $__env->startSection('twitter_card', $seoData['twitter_card'] ?? ''); ?>
    <?php $__env->startSection('twitter_title', $seoData['twitter_title'] ?? ''); ?>
    <?php $__env->startSection('twitter_description', $seoData['twitter_description'] ?? ''); ?>
    <?php $__env->startSection('twitter_image', $seoData['twitter_image'] ?? ''); ?>
    <?php $__env->startSection('structured_data', json_encode($seoData['structured_data'] ?? [])); ?>
<?php endif; ?>

<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>

    <!-- Hero Section - Compact and Responsive -->
    <div class="relative bg-gradient-to-br from-blue-900 via-purple-900 to-indigo-900 overflow-hidden min-h-[60vh] lg:min-h-[70vh]">
        <!-- Animated Background Pattern -->
        <div class="absolute inset-0">
            <div class="absolute inset-0 bg-[radial-gradient(circle_at_50%_50%,rgba(120,119,198,0.3),rgba(255,255,255,0))]"></div>
            <div class="absolute top-0 left-0 w-full h-full bg-gradient-to-r from-purple-800/90 to-blue-900/90"></div>
        </div>

        <!-- Floating Animated Elements - Smaller and fewer -->
        <div class="absolute top-10 left-5 w-12 h-12 bg-yellow-400/30 rounded-full blur-lg animate-pulse"></div>
        <div class="absolute top-20 right-10 w-16 h-16 bg-pink-400/30 rounded-full blur-lg animate-bounce"></div>
        <div class="absolute bottom-10 left-1/4 w-10 h-10 bg-green-400/30 rounded-full blur-lg animate-ping"></div>

        <!-- Main Hero Content - Compact -->
        <div class="relative max-w-6xl mx-auto py-16 px-4 sm:py-20 sm:px-6 lg:px-8 text-center">
            <!-- Luxury Badge - Smaller -->
            <div class="mb-4 inline-block">
                <div class="bg-gradient-to-r from-yellow-400 to-orange-500 text-black px-4 py-1 rounded-full font-bold text-xs shadow-lg animate-bounce">
                    🏆 EXCLUSIVE LUXURY 🏆
                </div>
            </div>

            <!-- Main Title - Smaller and more responsive -->
            <h1 class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-black tracking-tight text-white mb-4 animate-fade-in-up">
                <span class="bg-gradient-to-r from-yellow-400 via-pink-400 to-purple-400 bg-clip-text text-transparent drop-shadow-xl">
                    <?php echo e(__('Welcome to ') . config('app.name', 'Royalux')); ?>

                </span>
            </h1>

            <!-- Subtitle - Compact -->
            <div class="relative mb-6">
                <p class="mt-4 text-sm sm:text-base md:text-lg text-gray-200 max-w-3xl mx-auto leading-relaxed animate-fade-in-up-delay font-medium">
                    <?php echo e(__('🌟 The premier destination for authentic luxury brands in the UAE and elite countries. Only original, world-renowned labels—exclusively for those who demand the best.')); ?>

                </p>
                <div class="absolute inset-0 bg-gradient-to-r from-transparent via-white/10 to-transparent blur-sm"></div>
            </div>

            <!-- Action Button - Smaller -->
            <div class="mt-6 flex justify-center">
                <a href="#products" class="group relative inline-flex items-center px-6 py-3 text-base font-bold text-white bg-gradient-to-r from-pink-500 via-purple-600 to-indigo-600 rounded-full hover:from-pink-600 hover:via-purple-700 hover:to-indigo-700 transform hover:scale-105 transition-all duration-300 shadow-xl hover:shadow-pink-500/50">
                    <span class="absolute inset-0 bg-gradient-to-r from-pink-400 to-purple-600 rounded-full blur-lg opacity-50 group-hover:opacity-75 animate-pulse"></span>
                    <svg class="w-5 h-5 mr-2 relative z-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                    </svg>
                    <span class="relative z-10"><?php echo e(__('🛍️ START SHOPPING')); ?></span>
                </a>
            </div>

            <!-- Congratulations Message - Compact -->
            <div class="mt-6 p-4 bg-gradient-to-r from-yellow-400/20 to-orange-500/20 backdrop-blur-lg rounded-xl border border-yellow-400/30 shadow-xl">
                <p class="text-sm sm:text-base md:text-lg text-yellow-300 font-bold animate-bounce">
                    <?php echo e(__('🎉 Congratulations! You\'ve unlocked access to ') . config('app.name', 'Royalux') . __(' —where only the world\'s most exclusive luxury shoppers belong! 🥂')); ?>

                </p>
            </div>
        </div>

        <!-- Decorative Elements - Smaller -->
        <div class="absolute top-5 left-5 w-12 h-12 border-2 border-white/20 rounded-full animate-spin" style="animation-duration: 8s;"></div>
        <div class="absolute top-10 right-10 w-10 h-10 border-2 border-purple-400/30 rounded-full animate-ping"></div>
        <div class="absolute bottom-10 left-1/4 w-8 h-8 border-2 border-pink-400/40 rounded-full animate-pulse"></div>
    </div>

    <!-- Breadcrumbs Navigation - Compact -->
    <?php if(isset($seoData['breadcrumbs']) && count($seoData['breadcrumbs']) > 1): ?>
        <div class="bg-white border-b border-gray-200">
            <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 py-2">
                <nav class="flex" aria-label="Breadcrumb">
                    <ol class="flex items-center space-x-2 text-sm">
                        <?php $__currentLoopData = $seoData['breadcrumbs']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $breadcrumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="flex items-center">
                                <?php if($index > 0): ?>
                                    <svg class="flex-shrink-0 h-4 w-4 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" />
                                    </svg>
                                <?php endif; ?>
                                <?php if($index === count($seoData['breadcrumbs']) - 1): ?>
                                    <span class="text-gray-500 font-medium"><?php echo e($breadcrumb['title']); ?></span>
                                <?php else: ?>
                                    <a href="<?php echo e($breadcrumb['url']); ?>" class="text-blue-600 hover:text-blue-800 font-medium">
                                        <?php echo e($breadcrumb['title']); ?>

                                    </a>
                                <?php endif; ?>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ol>
                </nav>
            </div>
        </div>
    <?php endif; ?>

    <!-- Premium Search Section - Compact -->
    <div class="bg-gradient-to-r from-white via-gray-50 to-white shadow-lg border-t-4 border-gradient-to-r from-blue-500 via-purple-500 to-pink-500">
        <div class="max-w-6xl mx-auto py-8 px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-6">
                <h2 class="text-2xl sm:text-3xl font-black text-gray-900 mb-2">
                    <span class="bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent">
                        🔍 <?php echo e(__('Find Your Perfect Luxury Item')); ?> 🔍
                    </span>
                </h2>
            </div>

            <form action="<?php echo e(route('home')); ?>" method="GET" class="space-y-4">
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                    <div class="sm:col-span-2">
                        <div class="relative group">
                            <label for="search" class="sr-only"><?php echo e(__('Search Products')); ?></label>
                            <input type="text"
                                   name="search"
                                   id="search"
                                   value="<?php echo e(request('search')); ?>"
                                   placeholder="<?php echo e(__('Search luxury products...')); ?>"
                                   aria-label="<?php echo e(__('Search for luxury products')); ?>"
                                   class="w-full pl-12 pr-4 py-3 rounded-xl border-2 border-gray-200 shadow-md focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 text-base bg-white/90 backdrop-blur-sm hover:shadow-lg group-hover:border-purple-400">
                            <svg class="absolute left-4 top-1/2 transform -translate-y-1/2 w-5 h-5 text-gray-400 group-hover:text-purple-500 transition-colors duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                            </svg>
                        </div>
                    </div>
                    <div>
                        <label for="category" class="sr-only"><?php echo e(__('Select Category')); ?></label>
                        <select name="category" id="category" aria-label="<?php echo e(__('Filter by category')); ?>"
                                class="w-full py-3 px-4 rounded-xl border-2 border-gray-200 shadow-md focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 text-base bg-white/90 backdrop-blur-sm hover:shadow-lg hover:border-purple-400">
                            <option value=""><?php echo e(__('🏷️ All Categories')); ?></option>
                            <?php $__currentLoopData = $categories ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>" <?php echo e(request('category') == $category->id || request('category') == (string)$category->id ? 'selected' : ''); ?>>
                                    <?php echo e($category->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label for="sort" class="sr-only"><?php echo e(__('Sort Products')); ?></label>
                        <select name="sort" id="sort" aria-label="<?php echo e(__('Sort products by')); ?>"
                                class="w-full py-3 px-4 rounded-xl border-2 border-gray-200 shadow-md focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 text-base bg-white/90 backdrop-blur-sm hover:shadow-lg hover:border-purple-400">
                            <option value="newest" <?php echo e(request('sort') == 'newest' ? 'selected' : ''); ?>><?php echo e(__('⭐ Newest')); ?></option>
                            <option value="price_asc" <?php echo e(request('sort') == 'price_asc' ? 'selected' : ''); ?>><?php echo e(__('💰 Price: Low to High')); ?></option>
                            <option value="price_desc" <?php echo e(request('sort') == 'price_desc' ? 'selected' : ''); ?>><?php echo e(__('💎 Price: High to Low')); ?></option>
                            <option value="name" <?php echo e(request('sort') == 'name' ? 'selected' : ''); ?>><?php echo e(__('📝 Name A-Z')); ?></option>
                        </select>
                    </div>
                </div>
                <div class="flex justify-center">
                    <button type="submit"
                            aria-label="<?php echo e(__('Search for products')); ?>"
                            class="group relative inline-flex items-center px-8 py-3 border-0 rounded-xl shadow-lg text-base font-bold text-white bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 hover:from-blue-700 hover:via-purple-700 hover:to-pink-700 focus:outline-none focus:ring-4 focus:ring-blue-300 transform hover:scale-105 transition-all duration-300">
                        <span class="absolute inset-0 bg-gradient-to-r from-blue-400 to-purple-600 rounded-xl blur-lg opacity-50 group-hover:opacity-75 animate-pulse"></span>
                        <svg class="w-5 h-5 mr-2 relative z-10" fill="none" stroke="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                        </svg>
                        <span class="relative z-10"><?php echo e(__('🔍 SEARCH NOW')); ?></span>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Featured Products Section - Compact -->
    <div class="bg-gradient-to-br from-gray-50 via-blue-50 to-purple-50" id="products">
        <div class="max-w-6xl mx-auto py-12 px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl sm:text-4xl md:text-5xl font-black text-gray-900 mb-4">
                    <span class="bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 bg-clip-text text-transparent">
                        ✨ <?php echo e(__('Featured Luxury Products')); ?> ✨
                    </span>
                </h2>
                <div class="w-24 h-1 bg-gradient-to-r from-blue-500 via-purple-500 to-pink-500 mx-auto rounded-full shadow-lg mb-4"></div>
                <p class="text-base sm:text-lg text-gray-600 max-w-2xl mx-auto">
                    <?php echo e(__('Discover our handpicked selection of the finest luxury items from around the world')); ?>

                </p>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                <?php $__currentLoopData = $featuredProducts ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="group bg-white/80 backdrop-blur-lg rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transform hover:-translate-y-2 hover:rotate-1 transition-all duration-500 border border-white/50 hover:border-purple-300">
                        <div class="relative overflow-hidden">
                            <img src="<?php echo e($product->first_image ? asset($product->first_image) : 'https://via.placeholder.com/400x300?text=Luxury+Product'); ?>"
                                 alt="<?php echo e($product->name); ?> - <?php echo e(__('Luxury Product')); ?>"
                                 class="w-full h-48 object-cover group-hover:scale-110 transition-transform duration-500">

                            <!-- Luxury Badge - Smaller -->
                            <div class="absolute top-2 right-2">
                                <span class="bg-gradient-to-r from-yellow-400 to-orange-500 text-black text-xs font-bold px-2 py-1 rounded-full shadow-md animate-pulse">
                                    ⭐ <?php echo e(__('FEATURED')); ?>

                                </span>
                            </div>

                            <?php if(($product->stock ?? 0) <= 5): ?>
                                <div class="absolute top-2 left-2">
                                    <span class="bg-red-500 text-white text-xs font-bold px-2 py-1 rounded-full animate-bounce shadow-md">
                                        🚨 <?php echo e(__('LIMITED')); ?>

                                    </span>
                                </div>
                            <?php endif; ?>

                            <!-- Overlay Effect -->
                            <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                        </div>

                        <div class="p-4">
                            <h3 class="text-lg font-bold text-gray-900 mb-2 group-hover:text-blue-600 transition-colors duration-300">
                                <?php echo e($product->name ?? 'Luxury Product'); ?>

                            </h3>
                            <p class="text-gray-600 text-xs mb-4 leading-relaxed">
                                <?php echo e(Str::limit($product->description ?? 'Premium luxury item', 60)); ?>

                            </p>

                            <div class="flex items-center justify-between mb-4">
                                <?php if(method_exists($product ?? new stdClass, 'hasDiscount') && $product->hasDiscount()): ?>
                                    <div class="flex items-center space-x-1">
                                        <span class="text-xl font-bold text-gray-900">
                                            $<?php echo e(number_format($product->discounted_price, 2)); ?>

                                        </span>
                                        <span class="text-sm text-gray-400 line-through">
                                            $<?php echo e(number_format($product->price, 2)); ?>

                                        </span>
                                        <span class="text-xs text-red-500 font-bold bg-red-100 px-1 py-0.5 rounded-full">
                                            <?php echo e($product->discount_percentage); ?>% OFF
                                        </span>
                                    </div>
                                <?php else: ?>
                                    <span class="text-xl font-bold bg-gradient-to-r from-green-600 to-blue-600 bg-clip-text text-transparent">
                                        $<?php echo e(number_format($product->price ?? 999, 2)); ?>

                                    </span>
                                <?php endif; ?>

                                <div class="flex items-center text-yellow-400">
                                    <?php for($i = 0; $i < 5; $i++): ?>
                                        <svg class="w-4 h-4 fill-current drop-shadow-lg" viewBox="0 0 20 20">
                                            <path d="M10 15l-5.878 3.09 1.123-6.545L.489 6.91l6.572-.955L10 0l2.939 5.955 6.572.955-4.756 4.635 1.123 6.545z"/>
                                        </svg>
                                    <?php endfor; ?>
                                    <span class="text-gray-500 text-xs ml-1 font-semibold">(<?php echo e(rand(50, 200)); ?>)</span>
                                </div>
                            </div>

                            <a href="<?php echo e(route('products.show', $product) ?? '#'); ?>"
                               class="block w-full text-center bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 hover:from-blue-700 hover:via-purple-700 hover:to-pink-700 text-white font-bold py-2 px-4 rounded-xl transition-all duration-300 transform hover:scale-105 shadow-lg hover:shadow-purple-500/50 group-hover:animate-pulse text-sm">
                                💎 <?php echo e(__('VIEW DETAILS')); ?>

                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <!-- All Products Section - Compact -->
    <div class="bg-white">
        <div class="max-w-6xl mx-auto py-12 px-4 sm:px-6 lg:px-8">
            <!-- Search Results Header - Compact -->
            <?php if(request('search') || request('category')): ?>
                <div class="text-center mb-8">
                    <h1 class="text-2xl sm:text-3xl md:text-4xl font-black text-gray-900 mb-3">
                        <span class="bg-gradient-to-r from-purple-600 to-pink-600 bg-clip-text text-transparent">
                            <?php if(request('search') && request('category')): ?>
                                <?php echo e(__('Search Results for')); ?> "<?php echo e(request('search')); ?>" <?php echo e(__('in')); ?> <?php echo e($categories->find(request('category'))->name ?? ''); ?>

                            <?php elseif(request('search')): ?>
                                <?php echo e(__('Search Results for')); ?> "<?php echo e(request('search')); ?>"
                            <?php elseif(request('category')): ?>
                                <?php echo e($categories->find(request('category'))->name ?? ''); ?> <?php echo e(__('Products')); ?>

                            <?php endif; ?>
                        </span>
                    </h1>
                    <div class="w-16 h-1 bg-gradient-to-r from-purple-500 to-pink-500 mx-auto rounded-full mb-3"></div>
                    <p class="text-sm sm:text-base text-gray-600">
                        <?php if(request('search') && request('category')): ?>
                            <?php echo e(__('Found')); ?> <?php echo e($products->total()); ?> <?php echo e(__('products matching')); ?> "<?php echo e(request('search')); ?>" <?php echo e(__('in')); ?> <?php echo e($categories->find(request('category'))->name ?? ''); ?>

                        <?php elseif(request('search')): ?>
                            <?php echo e(__('Found')); ?> <?php echo e($products->total()); ?> <?php echo e(__('products matching')); ?> "<?php echo e(request('search')); ?>"
                        <?php elseif(request('category')): ?>
                            <?php echo e(__('Found')); ?> <?php echo e($products->total()); ?> <?php echo e(__('products in')); ?> <?php echo e($categories->find(request('category'))->name ?? ''); ?>

                        <?php endif; ?>
                    </p>

                    <!-- Active Filters - Compact -->
                    <?php if(request('search') || request('category') || request('sort')): ?>
                        <div class="mt-4 flex flex-wrap justify-center gap-2">
                            <?php if(request('search')): ?>
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                    <?php echo e(__('Search:')); ?> <?php echo e(request('search')); ?>

                                    <a href="<?php echo e(route('home', array_filter(['category' => request('category'), 'sort' => request('sort')]))); ?>" class="ml-1 text-blue-600 hover:text-blue-800">
                                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414z" clip-rule="evenodd"/>
                                        </svg>
                                    </a>
                                </span>
                            <?php endif; ?>
                            <?php if(request('category')): ?>
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                    <?php echo e(__('Category:')); ?> <?php echo e($categories->find(request('category'))->name ?? ''); ?>

                                    <a href="<?php echo e(route('home', array_filter(['search' => request('search'), 'sort' => request('sort')]))); ?>" class="ml-1 text-green-600 hover:text-green-800">
                                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                                        </svg>
                                    </a>
                                </span>
                            <?php endif; ?>
                            <?php if(request('sort') && request('sort') !== 'newest'): ?>
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                                    <?php echo e(__('Sort:')); ?>

                                    <?php switch(request('sort')):
                                        case ('price_asc'): ?>
                                            <?php echo e(__('Price: Low to High')); ?>

                                            <?php break; ?>
                                        <?php case ('price_desc'): ?>
                                            <?php echo e(__('Price: High to Low')); ?>

                                            <?php break; ?>
                                        <?php case ('name'): ?>
                                            <?php echo e(__('Name A-Z')); ?>

                                            <?php break; ?>
                                        <?php default: ?>
                                            <?php echo e(__('Newest')); ?>

                                    <?php endswitch; ?>
                                    <a href="<?php echo e(route('home', array_filter(['search' => request('search'), 'category' => request('category')]))); ?>" class="ml-1 text-purple-600 hover:text-purple-800">
                                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                                        </svg>
                                    </a>
                                </span>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <div class="text-center mb-12">
                    <h2 class="text-2xl sm:text-3xl md:text-4xl font-black text-gray-900 mb-3">
                        <span class="bg-gradient-to-r from-purple-600 to-pink-600 bg-clip-text text-transparent">
                            <?php echo e(__('All Products')); ?>

                        </span>
                    </h2>
                    <div class="w-16 h-1 bg-gradient-to-r from-purple-500 to-pink-500 mx-auto rounded-full"></div>
                </div>
            <?php endif; ?>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="group bg-white rounded-xl shadow-md overflow-hidden hover:shadow-lg transform hover:-translate-y-1 transition-all duration-300 border border-gray-100">
                        <div class="relative overflow-hidden">
                            <img src="<?php echo e($product->first_image ? asset($product->first_image) : 'https://via.placeholder.com/400x300?text=Product+Image'); ?>"
                                 alt="<?php echo e($product->name); ?> - <?php echo e(__('Product Image')); ?>"
                                 class="w-full h-48 object-cover group-hover:scale-105 transition-transform duration-300">
                            <?php if($product->stock <= 5): ?>
                                <div class="absolute top-2 right-2">
                                    <span class="bg-red-500 text-white text-xs font-bold px-2 py-1 rounded-full animate-pulse">
                                        <?php echo e(__('Low Stock')); ?>

                                    </span>
                                </div>
                            <?php endif; ?>
                            <?php if($product->is_approved): ?>
                                <div class="absolute bottom-2 right-2">
                                    <span class="bg-green-500 text-white text-xs font-bold px-1 py-0.5 rounded-full">
                                        <svg class="w-3 h-3 inline" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                        </svg>
                                    </span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="p-4">
                            <h3 class="text-base font-bold text-gray-900 mb-2 group-hover:text-purple-600 transition-colors duration-300">
                                <?php echo e($product->name); ?>

                            </h3>
                            <p class="text-gray-600 text-xs mb-3 leading-relaxed">
                                <?php echo e(Str::limit($product->description, 60)); ?>

                            </p>
                            <div class="flex items-center justify-between mb-3">
                                <?php if($product->hasDiscount()): ?>
                                    <div class="flex items-center space-x-1">
                                        <span class="text-lg font-bold text-gray-900">
                                            $<?php echo e(number_format($product->discounted_price, 2)); ?>

                                        </span>
                                        <span class="text-sm text-gray-400 line-through">
                                            $<?php echo e(number_format($product->price, 2)); ?>

                                        </span>
                                        <span class="text-xs text-red-500 font-semibold">
                                            <?php echo e($product->discount_percentage); ?>% OFF
                                        </span>
                                    </div>
                                <?php else: ?>
                                    <span class="text-lg font-bold text-gray-900">
                                        $<?php echo e(number_format($product->price, 2)); ?>

                                    </span>
                                <?php endif; ?>
                                <span class="text-xs text-gray-500">
                                    Stock: <?php echo e($product->stock); ?>

                                </span>
                            </div>
                            <a href="<?php echo e(route('products.show', $product)); ?>"
                               class="block w-full text-center bg-gradient-to-r from-purple-600 to-pink-600 hover:from-purple-700 hover:to-pink-700 text-white font-semibold py-2 px-4 rounded-lg transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg text-sm">
                                <?php echo e(__('View Details')); ?>

                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-span-4 text-center py-12">
                        <div class="mx-auto w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mb-4">
                            <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-2"><?php echo e(__('No Products Found')); ?></h3>
                        <p class="text-gray-600 mb-6 text-sm"><?php echo e(__('Try adjusting your search or filter criteria to find what you\'re looking for.')); ?></p>
                        <a href="<?php echo e(route('home')); ?>" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white font-semibold rounded-lg hover:bg-blue-700 transition-colors duration-300 text-sm">
                            <?php echo e(__('View All Products')); ?>

                        </a>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Pagination - Compact -->
            <?php if($products->hasPages()): ?>
                <div class="mt-8 flex justify-center">
                    <div class="bg-white rounded-lg shadow-md p-3">
                        <?php echo e($products->links()); ?>

                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\amazoon\resources\views/home.blade.php ENDPATH**/ ?>