<?php if(isset($selectedCategory) && $selectedCategory): ?>
    <?php $__env->startSection('title', $selectedCategory->seo_title); ?>
    <?php $__env->startSection('meta_description', $selectedCategory->seo_description); ?>
    <?php $__env->startSection('meta_keywords', $selectedCategory->seo_keywords); ?>
    <?php $__env->startSection('og_title', $selectedCategory->og_title); ?>
    <?php $__env->startSection('og_description', $selectedCategory->og_description); ?>
    <?php $__env->startSection('og_image', asset($selectedCategory->og_image ?: 'logo/logo.png')); ?>
    <?php $__env->startSection('og_type', 'website'); ?>
    <?php $__env->startSection('og_url', $selectedCategory->canonical_url); ?>
    <?php $__env->startSection('twitter_card', 'summary_large_image'); ?>
    <?php $__env->startSection('twitter_title', $selectedCategory->twitter_title); ?>
    <?php $__env->startSection('twitter_description', $selectedCategory->twitter_description); ?>
    <?php $__env->startSection('twitter_image', asset($selectedCategory->twitter_image ?: 'logo/logo.png')); ?>
    <?php $__env->startSection('canonical_url', $selectedCategory->canonical_url); ?>
    <?php if($selectedCategory->schema_markup): ?>
        <?php $__env->startSection('schema_markup'); ?>
            <script type="application/ld+json"><?php echo json_encode($selectedCategory->schema_markup); ?></script>
        <?php $__env->stopSection(); ?>
    <?php endif; ?>
<?php else: ?>
    <?php $__env->startSection('title', 'All Products'); ?>
    <?php $__env->startSection('meta_description', 'Browse all products at ' . config('app.name') . '. Find the best deals, new arrivals, and top-rated items in our online store.'); ?>
    <?php $__env->startSection('meta_keywords', 'products, shop, buy, deals, ' . config('app.name')); ?>
    <?php $__env->startSection('og_title', 'All Products - ' . config('app.name')); ?>
    <?php $__env->startSection('og_description', 'Browse all products at ' . config('app.name') . '. Find the best deals, new arrivals, and top-rated items in our online store.'); ?>
    <?php $__env->startSection('og_image', asset('logo/logo.png')); ?>
    <?php $__env->startSection('og_type', 'website'); ?>
    <?php $__env->startSection('og_url', url()->current()); ?>
    <?php $__env->startSection('twitter_card', 'summary_large_image'); ?>
    <?php $__env->startSection('twitter_title', 'All Products - ' . config('app.name')); ?>
    <?php $__env->startSection('twitter_description', 'Browse all products at ' . config('app.name') . '. Find the best deals, new arrivals, and top-rated items in our online store.'); ?>
    <?php $__env->startSection('twitter_image', asset('logo/logo.png')); ?>
    <?php $__env->startSection('canonical_url', url()->current()); ?>
<?php endif; ?>

<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <?php if(isset($selectedCategory) && $selectedCategory && $selectedCategory->image): ?>
        <div class="relative w-full h-64 md:h-96 overflow-hidden mb-8">
            <img src="<?php echo e(asset($selectedCategory->image)); ?>" alt="<?php echo e($selectedCategory->name); ?>" class="absolute inset-0 w-full h-full object-cover">
            <div class="absolute inset-0 bg-gradient-to-r from-black/60 to-black/20 flex flex-col justify-center items-center">
                <h2 class="text-4xl md:text-5xl font-extrabold text-white drop-shadow mb-2"><?php echo e($selectedCategory->name); ?></h2>
                <?php if($selectedCategory->description): ?>
                    <p class="text-lg md:text-xl text-gray-100 text-center max-w-2xl drop-shadow"><?php echo e($selectedCategory->description); ?></p>
                <?php endif; ?>
            </div>
        </div>
    <?php else: ?>
        <!-- Hero Section with Add Product Button -->
        <div class="relative bg-gradient-to-br from-blue-900 via-purple-900 to-indigo-900 overflow-hidden mb-8">
            <div class="absolute inset-0">
                <img class="w-full h-full object-cover opacity-30"
                     src="https://images.unsplash.com/photo-1607082348824-0a96f2a4b9da?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=2070&q=80"
                     alt="Hero background">
                <div class="absolute inset-0 bg-gradient-to-r from-purple-800/90 to-blue-900/90"></div>
            </div>
            <!-- Floating Elements -->
            <div class="absolute top-20 left-10 w-20 h-20 bg-yellow-400/20 rounded-full blur-xl animate-pulse"></div>
            <div class="absolute top-40 right-20 w-32 h-32 bg-pink-400/20 rounded-full blur-xl animate-bounce"></div>
            <div class="absolute bottom-20 left-1/4 w-16 h-16 bg-green-400/20 rounded-full blur-xl animate-ping"></div>
            <div class="relative max-w-7xl mx-auto py-24 px-4 sm:py-32 sm:px-6 lg:px-8">
                <div class="flex flex-col lg:flex-row items-center justify-between">
                    <div class="text-center lg:text-left lg:flex-1">
                        <h1 class="text-4xl md:text-5xl lg:text-6xl font-black tracking-tight text-white mb-6 animate-fade-in-up">
                            <span class="bg-gradient-to-r from-yellow-400 to-pink-400 bg-clip-text text-transparent">
                                <?php echo e(__('Products')); ?>

                            </span>
                        </h1>
                        <p class="mt-6 text-lg md:text-xl text-gray-200 max-w-3xl leading-relaxed animate-fade-in-up-delay">
                            
                            <?php echo e(__('luxur site products.')); ?>

                        </p>
                    </div>
                    
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="py-12 bg-gradient-to-br from-gray-50 to-blue-50">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <?php if(session('success')): ?>
                <div class="bg-green-100 border-l-4 border-green-500 text-green-700 px-6 py-4 rounded-lg relative mb-8 shadow-lg animate-fade-in-up" role="alert">
                    <div class="flex items-center">
                        <svg class="w-6 h-6 mr-3" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span class="font-semibold"><?php echo e(session('success')); ?></span>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Enhanced Search and Filter Section -->
            <div class="bg-white shadow-xl rounded-2xl overflow-hidden mb-8 border border-gray-100">
                <div class="bg-gradient-to-r from-blue-600 to-purple-600 px-6 py-4">
                    <h3 class="text-xl font-bold text-white flex items-center">
                        <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                        </svg>
                        <?php echo e(__('Search & Filter Products')); ?>

                    </h3>
                </div>
                <div class="p-6">
                    <form action="<?php echo e(route('products.index')); ?>" method="GET" class="space-y-6">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                            <!-- Enhanced Search -->
                            <div class="relative">
                                <label for="search" class="block text-sm font-semibold text-gray-700 mb-2">
                                    <?php echo e(__('Search Products')); ?>

                                </label>
                                <div class="relative">
                                    <input type="text" name="search" id="search" value="<?php echo e(request('search')); ?>"
                                        class="w-full pl-12 pr-4 py-3 rounded-xl border-2 border-gray-200 shadow-sm focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 text-lg"
                                        placeholder="<?php echo e(__('Search by name, description...')); ?>">
                                    <svg class="absolute left-4 top-1/2 transform -translate-y-1/2 w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                                    </svg>
                                </div>
                            </div>

                            <!-- Enhanced Category Filter -->
                            <div>
                                <label for="category" class="block text-sm font-semibold text-gray-700 mb-2">
                                    <?php echo e(__('Category')); ?>

                                </label>
                                <select name="category" id="category"
                                    class="w-full py-3 px-4 rounded-xl border-2 border-gray-200 shadow-sm focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 text-lg bg-white">
                                    <option value=""><?php echo e(__('All Categories')); ?></option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>" <?php echo e(request('category') == $category->id ? 'selected' : ''); ?>>
                                            <?php echo e($category->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <!-- Enhanced Sort -->
                            <div>
                                <label for="sort" class="block text-sm font-semibold text-gray-700 mb-2">
                                    <?php echo e(__('Sort By')); ?>

                                </label>
                                <select name="sort" id="sort"
                                    class="w-full py-3 px-4 rounded-xl border-2 border-gray-200 shadow-sm focus:border-blue-500 focus:ring-4 focus:ring-blue-200 transition-all duration-300 text-lg bg-white">
                                    <option value="newest" <?php echo e(request('sort') == 'newest' ? 'selected' : ''); ?>><?php echo e(__('Newest First')); ?></option>
                                    <option value="price_asc" <?php echo e(request('sort') == 'price_asc' ? 'selected' : ''); ?>><?php echo e(__('Price: Low to High')); ?></option>
                                    <option value="price_desc" <?php echo e(request('sort') == 'price_desc' ? 'selected' : ''); ?>><?php echo e(__('Price: High to Low')); ?></option>
                                    <option value="name" <?php echo e(request('sort') == 'name' ? 'selected' : ''); ?>><?php echo e(__('Name A-Z')); ?></option>
                                </select>
                            </div>
                        </div>

                        <div class="flex justify-center">
                            <button type="submit" class="inline-flex items-center px-8 py-3 border border-transparent rounded-xl shadow-lg text-lg font-semibold text-white bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 focus:outline-none focus:ring-4 focus:ring-blue-300 transform hover:scale-105 transition-all duration-300">
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                                </svg>
                                <?php echo e(__('Apply Filters')); ?>

                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Enhanced Products Grid -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-8">
                <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="group bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-500 border border-gray-100">
                        <div class="relative overflow-hidden">
                            <a href="<?php echo e(route('products.show', $product)); ?>" class="block">
                                <?php
                                    $images = is_string($product->image) ? json_decode($product->image, true) : $product->image;
                                    $firstImage = !empty($images) ? (is_array($images) ? $images[0] : $images) : null;
                                ?>
                                <img src="<?php echo e($firstImage ? asset($firstImage) : asset('images/no-image.png')); ?>" alt="<?php echo e($product->name); ?>"
                                    class="w-full h-40 sm:h-48 md:h-56 object-cover group-hover:scale-110 transition-transform duration-500 rounded-t-2xl">
                            </a>

                            <!-- Status Badges -->
                            <div class="absolute top-4 right-4 space-y-2">
                                <?php if($product->hasDiscount()): ?>
                                    <span class="bg-red-500 text-white text-xs font-bold px-3 py-1 rounded-full animate-pulse">
                                        <?php echo e($product->discount_percentage); ?>% OFF
                                    </span>
                                <?php endif; ?>
                                <?php if($product->stock <= 5 && $product->stock > 0): ?>
                                    <span class="bg-yellow-500 text-white text-xs font-bold px-3 py-1 rounded-full">
                                        <?php echo e(__('Low Stock')); ?>

                                    </span>
                                <?php elseif($product->stock == 0): ?>
                                    <span class="bg-red-500 text-white text-xs font-bold px-3 py-1 rounded-full">
                                        <?php echo e(__('Out of Stock')); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="bg-green-500 text-white text-xs font-bold px-3 py-1 rounded-full">
                                        <?php echo e(__('In Stock')); ?>

                                    </span>
                                <?php endif; ?>
                            </div>

                            <!-- Quick Actions -->
                            <div class="absolute top-4 left-4 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                                <div class="flex flex-col space-y-2">
                                    
                                    <form action="<?php echo e(route('products.destroy', $product)); ?>" method="POST" class="inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="p-6">
                            <a href="<?php echo e(route('products.show', $product)); ?>" class="block">
                                <h3 class="text-xl font-bold text-gray-900 mb-2 group-hover:text-blue-600 transition-colors duration-300">
                                    <?php echo e($product->name); ?>

                                </h3>
                                <p class="text-gray-600 text-sm mb-4 leading-relaxed">
                                    <?php echo e(Str::limit($product->description, 80)); ?>

                                </p>
                            </a>

                            <!-- Price Section -->
                            <div class="mb-4">
                                <?php if($product->hasDiscount()): ?>
                                    <div class="flex items-center space-x-2">
                                        <span class="text-2xl font-black text-green-600">
                                            $<?php echo e(number_format($product->discounted_price, 2)); ?>

                                        </span>
                                        <span class="text-lg text-gray-400 line-through">
                                            $<?php echo e(number_format($product->price, 2)); ?>

                                        </span>
                                    </div>
                                <?php else: ?>
                                    <span class="text-2xl font-black text-gray-900">
                                        $<?php echo e(number_format($product->price, 2)); ?>

                                    </span>
                                <?php endif; ?>
                            </div>

                            <!-- Stock and Actions -->
                            <div class="flex items-center justify-between">
                                <div class="text-sm">
                                    <span class="font-semibold text-gray-700"><?php echo e(__('Stock:')); ?></span>
                                    <span class="text-gray-600"><?php echo e($product->stock); ?></span>
                                </div>
                                <a href="<?php echo e(route('products.show', $product)); ?>"
                                   class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-semibold text-sm rounded-lg transition-all duration-300 transform hover:scale-105">
                                    <?php echo e(__('View Details')); ?>

                                    <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-span-full">
                        <div class="text-center py-20 bg-white rounded-2xl shadow-lg">
                            <div class="mx-auto w-24 h-24 bg-gray-100 rounded-full flex items-center justify-center mb-6">
                                <svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2 2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"/>
                                </svg>
                            </div>
                            <h3 class="text-2xl font-bold text-gray-900 mb-2"><?php echo e(__('No Products Found')); ?></h3>
                            <p class="text-gray-600 mb-8"><?php echo e(__('You haven\'t added any products yet or no products match your search criteria.')); ?></p>
                            <a href="<?php echo e(route('products.create')); ?>"
                               class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-green-500 to-emerald-600 text-white font-semibold rounded-xl hover:from-green-600 hover:to-emerald-700 transition-all duration-300 transform hover:scale-105">
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                                </svg>
                                <?php echo e(__('Add Your First Product')); ?>

                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Enhanced Pagination -->
            <?php if($products->hasPages()): ?>
                <div class="mt-12 flex justify-center">
                    <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
                        <?php echo e($products->links()); ?>

                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\amazoon\resources\views/products/index.blade.php ENDPATH**/ ?>