<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="container mx-auto px-4 py-8 max-w-2xl bg-slate-100">
        <h1 class="text-2xl font-bold mb-6">Edit Page</h1>
        <form action="<?php echo e(route('admin.pages.update', $page)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="mb-4">
                <label for="title" class="block text-sm font-medium text-gray-700">Title</label>
                <input type="text" name="title" id="title" value="<?php echo e(old('title', $page->title)); ?>" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
            </div>
            <div class="mb-4">
                <label for="slug" class="block text-sm font-medium text-gray-700">Slug</label>
                <input type="text" name="slug" id="slug" value="<?php echo e(old('slug', $page->slug)); ?>" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
            </div>
            <div class="mb-4">
                <label for="content" class="block text-sm font-medium text-gray-700">Content</label>
                <textarea name="content" id="content" rows="6" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"><?php echo e(old('content', $page->content)); ?></textarea>
            </div>

            <!-- SEO Section -->
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-6 mb-6 mt-8">
                <h3 class="text-lg font-semibold text-blue-900 mb-4 flex items-center">
                    <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    SEO Settings
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                    <div>
                        <label for="meta_title" class="block text-sm font-medium text-gray-700">Meta Title</label>
                        <input type="text" name="meta_title" id="meta_title" value="<?php echo e(old('meta_title', $page->meta_title)); ?>" maxlength="60"
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                               placeholder="Auto-generated from page title">
                        <p class="text-xs text-gray-500 mt-1">Max 60 characters</p>
                    </div>
                    <div>
                        <label for="meta_description" class="block text-sm font-medium text-gray-700">Meta Description</label>
                        <textarea name="meta_description" id="meta_description" rows="2" maxlength="160"
                                  class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                  placeholder="Auto-generated from content"><?php echo e(old('meta_description', $page->meta_description)); ?></textarea>
                        <p class="text-xs text-gray-500 mt-1">Max 160 characters</p>
                    </div>
                </div>
                <div class="mb-6">
                    <label for="meta_keywords" class="block text-sm font-medium text-gray-700">Meta Keywords</label>
                    <input type="text" name="meta_keywords" id="meta_keywords" value="<?php echo e(old('meta_keywords', $page->meta_keywords)); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                           placeholder="Comma separated keywords, auto-generated from title">
                    <p class="text-xs text-gray-500 mt-1">Comma separated keywords</p>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                    <div>
                        <label for="og_title" class="block text-sm font-medium text-gray-700">Open Graph Title</label>
                        <input type="text" name="og_title" id="og_title" value="<?php echo e(old('og_title', $page->og_title)); ?>"
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                               placeholder="Auto-generated from meta title">
                    </div>
                    <div>
                        <label for="og_description" class="block text-sm font-medium text-gray-700">Open Graph Description</label>
                        <textarea name="og_description" id="og_description" rows="2"
                                  class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                  placeholder="Auto-generated from meta description"><?php echo e(old('og_description', $page->og_description)); ?></textarea>
                    </div>
                </div>
                <div class="mb-6">
                    <label for="og_image" class="block text-sm font-medium text-gray-700">Open Graph Image URL</label>
                    <input type="text" name="og_image" id="og_image" value="<?php echo e(old('og_image', $page->og_image)); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                           placeholder="URL of the image for social sharing">
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                    <div>
                        <label for="twitter_title" class="block text-sm font-medium text-gray-700">Twitter Title</label>
                        <input type="text" name="twitter_title" id="twitter_title" value="<?php echo e(old('twitter_title', $page->twitter_title)); ?>"
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                               placeholder="Auto-generated from meta title">
                    </div>
                    <div>
                        <label for="twitter_description" class="block text-sm font-medium text-gray-700">Twitter Description</label>
                        <textarea name="twitter_description" id="twitter_description" rows="2"
                                  class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                  placeholder="Auto-generated from meta description"><?php echo e(old('twitter_description', $page->twitter_description)); ?></textarea>
                    </div>
                </div>
                <div class="mb-6">
                    <label for="twitter_image" class="block text-sm font-medium text-gray-700">Twitter Image URL</label>
                    <input type="text" name="twitter_image" id="twitter_image" value="<?php echo e(old('twitter_image', $page->twitter_image)); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                           placeholder="URL of the image for Twitter card">
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                    <div>
                        <label for="canonical_url" class="block text-sm font-medium text-gray-700">Canonical URL</label>
                        <input type="text" name="canonical_url" id="canonical_url" value="<?php echo e(old('canonical_url', $page->canonical_url)); ?>"
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                               placeholder="Auto-generated from slug">
                    </div>
                    <div>
                        <label for="robots_directive" class="block text-sm font-medium text-gray-700">Robots Directive</label>
                        <select name="robots_directive" id="robots_directive"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                            <option value="index,follow" <?php echo e(old('robots_directive', $page->robots_directive ?? 'index,follow') == 'index,follow' ? 'selected' : ''); ?>>index,follow</option>
                            <option value="noindex,follow" <?php echo e(old('robots_directive', $page->robots_directive) == 'noindex,follow' ? 'selected' : ''); ?>>noindex,follow</option>
                            <option value="index,nofollow" <?php echo e(old('robots_directive', $page->robots_directive) == 'index,nofollow' ? 'selected' : ''); ?>>index,nofollow</option>
                            <option value="noindex,nofollow" <?php echo e(old('robots_directive', $page->robots_directive) == 'noindex,nofollow' ? 'selected' : ''); ?>>noindex,nofollow</option>
                        </select>
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                    <div>
                        <label for="seo_priority" class="block text-sm font-medium text-gray-700">SEO Priority</label>
                        <select name="seo_priority" id="seo_priority"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                            <option value="low" <?php echo e(old('seo_priority', $page->seo_priority) == 'low' ? 'selected' : ''); ?>>Low</option>
                            <option value="normal" <?php echo e(old('seo_priority', $page->seo_priority ?? 'normal') == 'normal' ? 'selected' : ''); ?>>Normal</option>
                            <option value="high" <?php echo e(old('seo_priority', $page->seo_priority) == 'high' ? 'selected' : ''); ?>>High</option>
                        </select>
                    </div>
                    <div class="flex items-center space-x-6 mt-6">
                        <label class="inline-flex items-center">
                            <input type="checkbox" name="seo_indexable" value="1" <?php echo e(old('seo_indexable', $page->seo_indexable ?? true) ? 'checked' : ''); ?>

                                   class="form-checkbox h-4 w-4 text-blue-600">
                            <span class="ml-2 text-sm text-gray-700">Allow search engines to index</span>
                        </label>
                        <label class="inline-flex items-center">
                            <input type="checkbox" name="show_in_sitemap" value="1" <?php echo e(old('show_in_sitemap', $page->show_in_sitemap ?? true) ? 'checked' : ''); ?>

                                   class="form-checkbox h-4 w-4 text-blue-600">
                            <span class="ml-2 text-sm text-gray-700">Include in sitemap</span>
                        </label>
                        <label class="inline-flex items-center">
                            <input type="checkbox" name="show_in_menu" value="1" <?php echo e(old('show_in_menu', $page->show_in_menu ?? false) ? 'checked' : ''); ?>

                                   class="form-checkbox h-4 w-4 text-blue-600">
                            <span class="ml-2 text-sm text-gray-700">Show in navigation menu</span>
                        </label>
                    </div>
                </div>
                <div class="flex items-center mt-2">
                    <button type="button" onclick="autoGenerateSeoFields()" class="bg-blue-100 hover:bg-blue-200 text-blue-700 px-3 py-1 rounded text-xs font-semibold mr-2">Auto-generate SEO</button>
                    <span class="text-xs text-gray-500">(Based on title and content)</span>
                </div>
            </div>

            <div class="mb-4">
                <label class="inline-flex items-center">
                    <input type="checkbox" name="is_active" value="1" class="form-checkbox" <?php echo e($page->is_active ? 'checked' : ''); ?>>
                    <span class="ml-2">Active</span>
                </label>
            </div>
            <div class="flex justify-end">
                <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-lg">Update Page</button>
            </div>
        </form>

        <?php $__env->startPush('scripts'); ?>
        <script>
        function autoGenerateSeoFields() {
            const title = document.getElementById('title').value;
            const content = document.getElementById('content').value;
            // Meta Title
            if (!document.getElementById('meta_title').value && title) {
                document.getElementById('meta_title').value = title + ' - ' + '<?php echo e(config('app.name')); ?>';
            }
            // Meta Description
            if (!document.getElementById('meta_description').value && content) {
                const cleanContent = content.replace(/<[^>]*>/g, '').trim();
                document.getElementById('meta_description').value = cleanContent.substring(0, 160);
            }
            // Meta Keywords
            if (!document.getElementById('meta_keywords').value && title) {
                document.getElementById('meta_keywords').value = title + ', page, ' + '<?php echo e(config('app.name')); ?>';
            }
            // OG Title
            if (!document.getElementById('og_title').value && document.getElementById('meta_title').value) {
                document.getElementById('og_title').value = document.getElementById('meta_title').value;
            }
            // OG Description
            if (!document.getElementById('og_description').value && document.getElementById('meta_description').value) {
                document.getElementById('og_description').value = document.getElementById('meta_description').value;
            }
            // Twitter Title
            if (!document.getElementById('twitter_title').value && document.getElementById('meta_title').value) {
                document.getElementById('twitter_title').value = document.getElementById('meta_title').value;
            }
            // Twitter Description
            if (!document.getElementById('twitter_description').value && document.getElementById('meta_description').value) {
                document.getElementById('twitter_description').value = document.getElementById('meta_description').value;
            }
            // Canonical URL
            if (!document.getElementById('canonical_url').value && document.getElementById('slug').value) {
                document.getElementById('canonical_url').value = window.location.origin + '/pages/' + document.getElementById('slug').value;
            }
        }
        // Character counter for meta description
        document.getElementById('meta_description').addEventListener('input', function() {
            const maxLength = 160;
            const currentLength = this.value.length;
            const remaining = maxLength - currentLength;
            let counter = this.parentNode.querySelector('.char-counter');
            if (!counter) {
                counter = document.createElement('p');
                counter.className = 'char-counter text-xs mt-1';
                this.parentNode.appendChild(counter);
            }
            if (remaining < 0) {
                counter.textContent = `${Math.abs(remaining)} characters over limit`;
                counter.className = 'char-counter text-xs mt-1 text-red-500';
            } else {
                counter.textContent = `${remaining} characters remaining`;
                counter.className = 'char-counter text-xs mt-1 text-gray-500';
            }
        });
        // Character counter for meta title
        document.getElementById('meta_title').addEventListener('input', function() {
            const maxLength = 60;
            const currentLength = this.value.length;
            const remaining = maxLength - currentLength;
            let counter = this.parentNode.querySelector('.char-counter');
            if (!counter) {
                counter = document.createElement('p');
                counter.className = 'char-counter text-xs mt-1';
                this.parentNode.appendChild(counter);
            }
            if (remaining < 0) {
                counter.textContent = `${Math.abs(remaining)} characters over limit`;
                counter.className = 'char-counter text-xs mt-1 text-red-500';
            } else {
                counter.textContent = `${remaining} characters remaining`;
                counter.className = 'char-counter text-xs mt-1 text-gray-500';
            }
        });
        </script>
        <?php $__env->stopPush(); ?>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\amazoon\resources\views/admin/pages/edit.blade.php ENDPATH**/ ?>