<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> 
        Contact Message Details
     <?php $__env->endSlot(); ?>

    <div class="container mx-auto px-4 py-8">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-3xl font-bold text-gray-900">Contact Message Details</h1>
            <div class="flex space-x-2">
                <a href="<?php echo e(route('admin.contacts.index')); ?>"
                   class="px-4 py-2 bg-gray-600 text-white rounded-md hover:bg-gray-700 transition-colors">
                    Back to List
                </a>
                <form action="<?php echo e(route('admin.contacts.destroy', $contact)); ?>" method="POST" class="inline"
                      onsubmit="return confirm('Are you sure you want to delete this message?')">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700 transition-colors">
                        Delete Message
                    </button>
                </form>
            </div>
        </div>

        <?php if(session('success')): ?>
            <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <div class="bg-white shadow-md rounded-lg overflow-hidden">
            <div class="p-6">
                <!-- Message Header -->
                <div class="border-b border-gray-200 pb-4 mb-6">
                    <div class="flex justify-between items-start">
                        <div>
                            <h2 class="text-2xl font-bold text-gray-900 mb-2"><?php echo e($contact->subject); ?></h2>
                            <div class="flex items-center space-x-4 text-sm text-gray-600">
                                <span><strong>From:</strong> <?php echo e($contact->name); ?></span>
                                <span><strong>Email:</strong> <?php echo e($contact->email); ?></span>
                                <span><strong>Date:</strong> <?php echo e($contact->created_at->format('F d, Y \a\t H:i')); ?></span>
                            </div>
                        </div>
                        <div class="text-right">
                            <?php if(!$contact->is_read): ?>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-red-100 text-red-800">
                                    Unread
                                </span>
                            <?php else: ?>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800">
                                    Read
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Message Content -->
                <div class="mb-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Message:</h3>
                    <div class="bg-gray-50 p-4 rounded-lg">
                        <p class="text-gray-800 whitespace-pre-wrap"><?php echo e($contact->message); ?></p>
                    </div>
                </div>

                <!-- Contact Information -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="bg-blue-50 p-4 rounded-lg">
                        <h3 class="text-lg font-semibold text-gray-900 mb-3">Contact Information</h3>
                        <div class="space-y-2">
                            <div>
                                <span class="font-medium text-gray-700">Name:</span>
                                <span class="text-gray-900"><?php echo e($contact->name); ?></span>
                            </div>
                            <div>
                                <span class="font-medium text-gray-700">Email:</span>
                                <span class="text-gray-900"><?php echo e($contact->email); ?></span>
                            </div>
                            <div>
                                <span class="font-medium text-gray-700">Subject:</span>
                                <span class="text-gray-900"><?php echo e($contact->subject); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="bg-green-50 p-4 rounded-lg">
                        <h3 class="text-lg font-semibold text-gray-900 mb-3">Message Details</h3>
                        <div class="space-y-2">
                            <div>
                                <span class="font-medium text-gray-700">Status:</span>
                                <?php if(!$contact->is_read): ?>
                                    <span class="text-red-600 font-medium">Unread</span>
                                <?php else: ?>
                                    <span class="text-green-600 font-medium">Read</span>
                                <?php endif; ?>
                            </div>
                            <div>
                                <span class="font-medium text-gray-700">Received:</span>
                                <span class="text-gray-900"><?php echo e($contact->created_at->format('F d, Y \a\t H:i')); ?></span>
                            </div>
                            <?php if($contact->is_read): ?>
                                <div>
                                    <span class="font-medium text-gray-700">Read at:</span>
                                    <span class="text-gray-900"><?php echo e($contact->updated_at->format('F d, Y \a\t H:i')); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Actions -->
                <div class="mt-6 pt-6 border-t border-gray-200">
                    <div class="flex space-x-3">
                        <?php if(!$contact->is_read): ?>
                            <form action="<?php echo e(route('admin.contacts.mark-read', $contact)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 transition-colors">
                                    Mark as Read
                                </button>
                            </form>
                        <?php endif; ?>

                        <a href="mailto:<?php echo e($contact->email); ?>?subject=Re: <?php echo e($contact->subject); ?>"
                           class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 transition-colors">
                            Reply via Email
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\amazoon\resources\views/admin/contacts/show.blade.php ENDPATH**/ ?>