<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <?php $__env->startSection('title', 'Contact Information'); ?>
    <?php $__env->startSection('description', 'We\'d love to hear from you. Send us a message and we\'ll respond as soon as possible.'); ?>
    <?php $__env->startSection('keywords', 'contact amazoon, amazoon contact, amazoon support, amazoon help, amazoon dubai, amazoon uae, amazoon customer service, amazoon office, amazoon location'); ?>
    <?php $__env->startSection('og_title', 'Contact Us - Amazoon | Get in Touch'); ?>
    <?php $__env->startSection('og_description', 'Contact Amazoon - Get in touch with our team. We\'re here to help with any questions about our products and services.'); ?>
    <?php $__env->startSection('og_image', asset('logo/logo.png')); ?>
    <?php $__env->startSection('og_url', url()->current()); ?>
    <?php $__env->startSection('og_type', 'website'); ?>
    <?php $__env->startSection('og_site_name', 'Amazoon'); ?>
    <?php $__env->startSection('twitter_title', 'Contact Us - Amazoon | Get in Touch'); ?>
    <?php $__env->startSection('twitter_description', 'Contact Amazoon - Get in touch with our team. We\'re here to help with any questions about our products and services.'); ?>
    <?php $__env->startSection('twitter_image', asset('logo/logo.png')); ?>
    <?php $__env->startSection('twitter_card', 'summary_large_image'); ?>
    <?php $__env->startSection('twitter_site', '@amazoon'); ?>
    <?php $__env->startSection('canonical', url()->current()); ?>
    <?php $__env->startSection('robots', 'index, follow'); ?>
    <?php $__env->startSection('author', 'Amazoon'); ?>
    <?php $__env->startSection('language', 'en'); ?>
    <?php $__env->startSection('geo_region', 'AE'); ?>
    <?php $__env->startSection('geo_placename', 'Dubai'); ?>
    <?php $__env->startSection('geo_position', '25.2048;55.2708'); ?>
    <?php $__env->startSection('icbm', '25.2048, 55.2708'); ?>

    <div class="min-h-screen bg-gray-50 dark:bg-gray-100 py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Page Header in Frame -->
            <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8 border border-gray-100 dark:border-gray-700 mb-12">
                <div class="text-center">
                    <h1 class="text-4xl font-bold text-gray-900 dark:text-white mb-4">Get in Touch</h1>
                    <p class="text-xl text-gray-600 dark:text-gray-400">We'd love to hear from you. Send us a message and we'll respond as soon as possible.</p>
                </div>
            </div>

            <div class="grid lg:grid-cols-2 gap-12">
                <!-- Contact Form -->
                <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8 border border-gray-100 dark:border-gray-700">
                    <h2 class="text-2xl font-bold text-gray-900 dark:text-white mb-6">Send us a Message</h2>

                    <?php if(session('success')): ?>
                        <div class="mb-6 p-4 bg-green-50 dark:bg-green-900/30 border border-green-200 dark:border-green-700 rounded-lg">
                            <p class="text-green-800 dark:text-green-200"><?php echo e(session('success')); ?></p>
                        </div>
                    <?php endif; ?>

                    <?php if($errors->any()): ?>
                        <div class="mb-6 p-4 bg-red-50 dark:bg-red-900/30 border border-red-200 dark:border-red-700 rounded-lg">
                            <ul class="text-red-800 dark:text-red-200 text-sm">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <form action="<?php echo e(route('contact.store')); ?>" method="POST" class="space-y-6">
                        <?php echo csrf_field(); ?>
                        <div class="grid md:grid-cols-2 gap-6">
                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Full Name</label>
                                <input type="text" id="name" name="name" required
                                       class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-700 dark:text-white"
                                       placeholder="Your full name" value="<?php echo e(old('name')); ?>">
                            </div>
                            <div>
                                <label for="email" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Email Address</label>
                                <input type="email" id="email" name="email" required
                                       class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-700 dark:text-white"
                                       placeholder="your@email.com" value="<?php echo e(old('email')); ?>">
                            </div>
                        </div>
                        <div>
                            <label for="subject" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Subject</label>
                            <input type="text" id="subject" name="subject" required
                                   class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-700 dark:text-white"
                                   placeholder="What is this about?" value="<?php echo e(old('subject')); ?>">
                        </div>
                        <div>
                            <label for="message" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Message</label>
                            <textarea id="message" name="message" rows="6" required
                                      class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-700 dark:text-white resize-none"
                                      placeholder="Tell us more about your inquiry..."><?php echo e(old('message')); ?></textarea>
                        </div>
                        <button type="submit"
                                class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-6 rounded-lg transition duration-200 transform hover:scale-105">
                            Send Message
                        </button>
                    </form>
                </div>

                <!-- Contact Info -->
                <div class="space-y-8">
                    <!-- Contact Information -->
                    <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8 border border-gray-100 dark:border-gray-700">
                        <h2 class="text-2xl font-bold text-gray-900 dark:text-white mb-6">Contact Information</h2>
                        <div class="space-y-6">
                            <div class="flex items-start space-x-4">
                                <div class="flex-shrink-0">
                                    <div class="w-12 h-12 bg-blue-100 dark:bg-blue-900/30 rounded-lg flex items-center justify-center">
                                        <svg class="w-6 h-6 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                        </svg>
                                    </div>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900 dark:text-white">Email</h3>
                                    <p class="text-green-600 dark:text-green-400"><?php echo e(\App\Models\Setting::getValue('contact_email', 'info@amazoon.com')); ?></p>
                                </div>
                            </div>

                            <div class="flex items-start space-x-4">
                                <div class="flex-shrink-0">
                                    <div class="w-12 h-12 bg-green-100 dark:bg-green-900/30 rounded-lg flex items-center justify-center">
                                        <svg class="w-6 h-6 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                                        </svg>
                                    </div>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900 dark:text-white">Phone</h3>
                                    <p class="text-green-600 dark:text-green-400"><?php echo e(\App\Models\Setting::getValue('contact_phone', '+971 45827552')); ?></p>
                                </div>
                            </div>

                            <div class="flex items-start space-x-4">
                                <div class="flex-shrink-0">
                                    <div class="w-12 h-12 bg-gray-100 dark:bg-gray-700 rounded-lg flex items-center justify-center">
                                        <svg class="w-6 h-6 text-gray-600 dark:text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                        </svg>
                                    </div>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900 dark:text-white">Address</h3>
                                    <p class="text-purple-600 dark:text-purple-400"><?php echo nl2br(e(\App\Models\Setting::getValue('contact_address', 'Al Arabiya 4U Business Centre<br>Al Saaha Offices C<br>Old Town, Downtown Dubai<br>Level 2 Office No. W202<br>P.O Box 282615, Dubai, UAE.'))); ?></p>
                                </div>
                            </div>

                            <!-- Social Links -->
                            <div class="flex items-center space-x-4 mt-4">
                                <a href="<?php echo e(\App\Models\Setting::getValue('contact_telegram', '#')); ?>" class="hover:text-blue-400" target="_blank" title="Telegram">
                                    <i class="fab fa-telegram-plane text-2xl"></i>
                                </a>
                                <a href="<?php echo e(\App\Models\Setting::getValue('contact_instagram', '#')); ?>" class="hover:text-pink-400" target="_blank" title="Instagram">
                                    <i class="fab fa-instagram text-2xl"></i>
                                </a>
                                <a href="<?php echo e(\App\Models\Setting::getValue('contact_facebook', '#')); ?>" class="hover:text-blue-600" target="_blank" title="Facebook">
                                    <i class="fab fa-facebook-f text-2xl"></i>
                                </a>
                                <a href="<?php echo e(\App\Models\Setting::getValue('contact_twitter', '#')); ?>" class="hover:text-blue-300" target="_blank" title="Twitter">
                                    <i class="fab fa-twitter text-2xl"></i>
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Business Hours -->
                    <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8 border border-gray-100 dark:border-gray-700">
                        <h2 class="text-2xl font-bold text-gray-900 dark:text-white mb-6">Business Hours</h2>
                        <div class="space-y-3">
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600 dark:text-gray-400">Monday - Friday</span>
                                <span class="font-semibold text-gray-900 dark:text-white">9:00 AM - 6:00 PM</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600 dark:text-gray-400">Saturday</span>
                                <span class="font-semibold text-gray-900 dark:text-white">10:00 AM - 4:00 PM</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600 dark:text-gray-400">Sunday</span>
                                <span class="font-semibold text-gray-900 dark:text-white">Closed</span>
                            </div>
                        </div>
                    </div>

                    <!-- Map -->
                    <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8 border border-gray-100 dark:border-gray-700">
                        <div class="text-center mb-6">
                            <h3 class="text-2xl font-bold text-gray-900 dark:text-white mb-2">Our Location</h3>
                            <p class="text-gray-600 dark:text-gray-400">Find us on the map</p>
                        </div>

                        <!-- Map Container -->
                        <div id="map" class="w-full h-80 rounded-xl overflow-hidden shadow-lg"></div>

                        <!-- Fallback Address Display -->
                        <div id="map-fallback" class="hidden w-full h-80 rounded-xl overflow-hidden shadow-lg bg-gradient-to-br from-blue-50 to-indigo-50 dark:from-blue-900/20 dark:to-indigo-900/20 border-2 border-dashed border-blue-200 dark:border-blue-700">
                            <div class="h-full flex items-center justify-center p-8">
                                <div class="text-center">
                                    <div class="w-16 h-16 bg-blue-500 rounded-full flex items-center justify-center mx-auto mb-4">
                                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                        </svg>
                                    </div>
                                    <h3 style="margin: 0 0 8px 0; color: #495057; font-weight: 600;">Amazoon Office</h3>
                                    <p style="margin: 0; color: #6c757d; font-size: 14px;"><?php echo e(\App\Models\Setting::getValue('contact_address', 'Al Arabiya 4U Business Centre, Dubai, UAE')); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        function initMap() {
            // Dubai coordinates
            var location = { lat: 25.2048, lng: 55.2708 }; // Downtown Dubai

            try {
            var map = new google.maps.Map(document.getElementById('map'), {
                    zoom: 16,
                    center: location,
                    mapTypeId: google.maps.MapTypeId.ROADMAP,
                    styles: [
                        {
                            "featureType": "all",
                            "elementType": "geometry.fill",
                            "stylers": [{"weight": "2.00"}]
                        },
                        {
                            "featureType": "all",
                            "elementType": "geometry.stroke",
                            "stylers": [{"color": "#9c9c9c"}]
                        },
                        {
                            "featureType": "all",
                            "elementType": "labels.text",
                            "stylers": [{"visibility": "on"}]
                        },
                        {
                            "featureType": "landscape",
                            "elementType": "all",
                            "stylers": [{"color": "#f2f2f2"}]
                        },
                        {
                            "featureType": "landscape",
                            "elementType": "geometry.fill",
                            "stylers": [{"color": "#ffffff"}]
                        },
                        {
                            "featureType": "landscape.man_made",
                            "elementType": "geometry.fill",
                            "stylers": [{"color": "#ffffff"}]
                        },
                        {
                            "featureType": "poi",
                            "elementType": "all",
                            "stylers": [{"visibility": "off"}]
                        },
                        {
                            "featureType": "road",
                            "elementType": "all",
                            "stylers": [{"saturation": -100}, {"lightness": 45}]
                        },
                        {
                            "featureType": "road",
                            "elementType": "geometry.fill",
                            "stylers": [{"color": "#eeeeee"}]
                        },
                        {
                            "featureType": "road",
                            "elementType": "labels.text.fill",
                            "stylers": [{"color": "#7b7b7b"}]
                        },
                        {
                            "featureType": "road",
                            "elementType": "labels.text.stroke",
                            "stylers": [{"color": "#ffffff"}]
                        },
                        {
                            "featureType": "road.highway",
                            "elementType": "all",
                            "stylers": [{"visibility": "simplified"}]
                        },
                        {
                            "featureType": "road.arterial",
                            "elementType": "labels.icon",
                            "stylers": [{"visibility": "off"}]
                        },
                        {
                            "featureType": "transit",
                            "elementType": "all",
                            "stylers": [{"visibility": "off"}]
                        },
                        {
                            "featureType": "water",
                            "elementType": "all",
                            "stylers": [{"color": "#46bcec"}, {"visibility": "on"}]
                        },
                        {
                            "featureType": "water",
                            "elementType": "geometry.fill",
                            "stylers": [{"color": "#c8d7d4"}]
                        },
                        {
                            "featureType": "water",
                            "elementType": "labels.text.fill",
                            "stylers": [{"color": "#070707"}]
                        },
                        {
                            "featureType": "water",
                            "elementType": "labels.text.stroke",
                            "stylers": [{"color": "#ffffff"}]
                        }
                    ]
                });

            var marker = new google.maps.Marker({
                position: location,
                map: map,
                    title: 'Amazoon Office - Dubai',
                    icon: {
                        url: 'https://maps.google.com/mapfiles/ms/icons/red-dot.png',
                        scaledSize: new google.maps.Size(40, 40)
                    }
                });

                // Add info window
                var infoWindow = new google.maps.InfoWindow({
                    content: `
                        <div style="padding: 15px; max-width: 250px;">
                            <h3 style="margin: 0 0 8px 0; font-weight: bold; color: #333; font-size: 16px;">Amazoon Office</h3>
                            <p style="margin: 0 0 5px 0; color: #666; font-size: 14px;"><?php echo e(\App\Models\Setting::getValue('contact_address', 'Al Arabiya 4U Business Centre, Dubai, UAE')); ?></p>
                            <p style="margin: 0 0 5px 0; color: #666; font-size: 14px;">Al Saaha Offices C, Level 2 Office No. W202</p>
                            <p style="margin: 0 0 8px 0; color: #666; font-size: 14px;">Downtown Dubai, UAE</p>
                            <p style="margin: 0; color: #007bff; font-size: 14px; font-weight: 500;"><?php echo e(\App\Models\Setting::getValue('contact_email', 'info@amazoon.com')); ?></p>
                        </div>
                    `
                });

                marker.addListener('click', function() {
                    infoWindow.open(map, marker);
                });

                // Auto-open info window on load
                setTimeout(function() {
                    infoWindow.open(map, marker);
                }, 1000);

            } catch (error) {
                console.error('Error initializing map:', error);
                showMapFallback();
            }
        }

        function showMapFallback() {
            document.getElementById('map').style.display = 'none';
            document.getElementById('map-fallback').classList.remove('hidden');
        }

        function handleMapError() {
            console.error('Google Maps failed to load');
            showMapFallback();
        }

        // Check if Google Maps API Key is available
        var apiKey = '<?php echo e(config("services.google.maps_api_key")); ?>';

        if (!apiKey || apiKey === 'null' || apiKey === '') {
            // No API key available, show fallback immediately
            showMapFallback();
        } else {
            // Load Google Maps API
            var script = document.createElement('script');
            script.src = 'https://maps.googleapis.com/maps/api/js?key=' + apiKey + '&callback=initMap';
            script.async = true;
            script.defer = true;
            script.onerror = handleMapError;
            document.head.appendChild(script);
        }
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\amazoon\resources\views/contact.blade.php ENDPATH**/ ?>